﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.IO;
using System.Data;
using xabaraCOM;

public partial class webXabara_class_ClassList : System.Web.UI.Page
{
    admin a = new admin();
    classify c = new classify();
    sqlServer sql = new sqlServer();
    javasrcipt js = new javasrcipt();
    fileDocument f = new fileDocument();

    string typeClss = HttpContext.Current.Request.QueryString["tClass"];
    string titleTemp = HttpContext.Current.Request.QueryString["title"];
    string[] strValue = new string[10];

    protected void Page_Load(object sender, EventArgs e)
    {
        a.check("|" + typeClss + "Class|");
        if (!IsPostBack)
        {
            classListName.Visible = true;
            classListName.Text = "如需排序，请选择带有子级分类的父分类并点击 显示所选分类排序 按钮！";

            titleTemp = Server.UrlDecode(titleTemp);
            if (string.IsNullOrEmpty(titleTemp as string))
            {
                titleTemp = "管理分类";
            }
            titleClass.Text = titleTemp;

            string adminClassStr = Request.QueryString["cid"];
            if (!string.IsNullOrEmpty(adminClassStr as string))
            {
                c.bindingSingleClass(adminClass, 0, true, "professional");
                linkClass.Text = Request.QueryString["cidStr"];

                if (!string.IsNullOrEmpty(Session["adminClass"] as string))
                {
                    this.adminClass.Items.FindByValue(Session["adminClass"].ToString().Trim()).Selected = true;
                }

                c.bindingDropDownList("all", false, xabara.isNum(adminClass.Text), typeClss, DropDownListClass);
            }
            else
            {
                linkClassTr.Visible = false;
                c.bindingDropDownList("all", false, 0, typeClss, DropDownListClass);
            }
            c.bindingTreeList(xabara.isNum(adminClass.Text), typeClss, treeList, "", "", false, true, "");

            DataTable dt = sql.getDataTable("select Tid from newsTree where treeNameTxt is null");
            for (int i = 0; i < dt.Rows.Count; i++)
            {
                long cid = xabara.isNum(dt.Rows[i]["Tid"].ToString().Trim());
                c.updateClassName(cid);
                c.updateIDs(typeClss, cid);
            }
            dt.Dispose();
        }
    }

    protected void editClass_Click(object sender, EventArgs e)
    {
        string cid = DropDownListClass.Text.Trim();
        string classNameTemp = className.Text.Trim();
        if (!String.IsNullOrEmpty(classNameTemp as string))
        {
            strValue[0] = classNameTemp;
            strValue[1] = classUrl.Text;
            strValue[2] = DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss");
            sql.log(a.uid, "admin", "修改分类：" + classNameTemp);
            string returnStr = sql.update("NewsTree", "@TreeName,@TreeUrl,@PostDate", strValue, "Tid=" + cid + " and TreeType='" + typeClss + "'");

            string strSql = "select Tid from newsTree where Tid=" + cid;
            strSql += " union select Tid from newsTree where CHARINDEX('|" + cid + "|',idLayerStr)>0 ";
            DataTable dt = sql.getDataTable(strSql);
            for (int i = 0; i < dt.Rows.Count; i++)
            {
                c.updateClassName(xabara.isNum(dt.Rows[i]["Tid"].ToString().Trim()));
            }
            dt.Dispose();

            c.updateClassName(xabara.isNum(cid));

            js.div(false, "", "text", returnStr, 300, 0, "classList.aspx?tClass=" + Request.QueryString["tClass"] + "&title=" + Request.QueryString["title"] + "&cid=" + Request.QueryString["cid"] + "&cidStr=" + Request.QueryString["cidStr"], "goto");
        }
        else
        {
            js.div(false, "", "text", "请填写分类名称！", 300, 0, "classList.aspx?tClass=" + Request.QueryString["tClass"] + "&title=" + Request.QueryString["title"] + "&cid=" + Request.QueryString["cid"] + "&cidStr=" + Request.QueryString["cidStr"], "goto");
        }
    }

    protected void delClass_Click(object sender, EventArgs e)
    {
        if (!String.IsNullOrEmpty(DropDownListClass.Text.Trim() as string))
        {
            Session.Add(typeClss, string.Empty); //缓存
            Session.Add("adminClass", string.Empty);

            string ClassID = DropDownListClass.Text.Trim();
            string strREADsql = "select TreeID,treeDel,TreeName,TreeNameImg from NewsTree where Tid=" + ClassID + " and TreeType='" + typeClss + "'";
            DataTable dt = sql.getDataTable(strREADsql);

            if (dt.Rows.Count > 0)
            {
                if (xabara.isNum(dt.Rows[0]["treeDel"].ToString()) > 0)
                {
                    js.div(false, "", "text", "该分类为前台固定分类，不允许删除！", 300, 0, "classList.aspx?tClass=" + Request.QueryString["tClass"] + "&title=" + Request.QueryString["title"] + "&cid=" + Request.QueryString["cid"] + "&cidStr=" + Request.QueryString["cidStr"], "goto");
                }
                else
                {
                    long updateID = xabara.isNum(dt.Rows[0]["TreeID"].ToString());

                    sql.log(a.uid, "admin", "删除分类：" + dt.Rows[0]["TreeName"].ToString());
                    string oldImg = dt.Rows[0]["TreeNameImg"].ToString().Trim();
                    if (!string.IsNullOrEmpty(oldImg as string))
                    {
                        string DelFilePath = oldImg.Substring(5, 8) + "/" + oldImg;
                        f.del(DelFilePath);
                    }

                    if (sql.del("NewsTree", "Tid", ClassID, string.Empty, false, string.Empty).Equals("删除成功"))
                    {
                        js.div(false, "", "text", "删除分类成功，建议执行一次数据缓存及清理！", 300, 0, "classList.aspx?tClass=" + Request.QueryString["tClass"] + "&title=" + Request.QueryString["title"] + "&cid=" + Request.QueryString["cid"] + "&cidStr=" + Request.QueryString["cidStr"], "goto");
                    }
                    else
                    {
                        js.div(false, "", "text", "删除分类失败！", 300, 0, "classList.aspx?tClass=" + Request.QueryString["tClass"] + "&title=" + Request.QueryString["title"] + "&cid=" + Request.QueryString["cid"] + "&cidStr=" + Request.QueryString["cidStr"], "goto");
                    }
                }
            }
            else
            {
                js.div(false, "", "text", "请从子分类最底层删除分类！", 300, 0, "classList.aspx?tClass=" + Request.QueryString["tClass"] + "&title=" + Request.QueryString["title"] + "&cid=" + Request.QueryString["cid"] + "&cidStr=" + Request.QueryString["cidStr"], "goto");
            }
            dt.Dispose();
        }
        else
        {
            js.div(false, "", "text", "请选择相关分类再进行操作！", 300, 0, "classList.aspx?tClass=" + Request.QueryString["tClass"] + "&title=" + Request.QueryString["title"] + "&cid=" + Request.QueryString["cid"] + "&cidStr=" + Request.QueryString["cidStr"], "goto");
        }
    }

    protected void displayClassList_Click(object sender, EventArgs e)
    {
        classListName.Text = string.Empty;

        string strSql = "select Tid,ListID,TreeName from NewsTree where TreeID=" + DropDownListClass.Text.Trim() + " and TreeType='" + typeClss + "' and treeAdmin=" + xabara.isNum(adminClass.Text) + " order by ListID ASC";
        DataTable dt = sql.getDataTable(strSql);

        if (dt.Rows.Count > 0)
        {
            treeCount.Value = dt.Rows.Count.ToString();

            for (int i = 0; i < dt.Rows.Count; i++)
            {
                classListName.Text += "<li><input name=\"tree" + i.ToString() + "\" type=\"text\" id=\"tree" + i.ToString() + "\" class=\"inputText\" value=\"" + dt.Rows[i]["ListID"].ToString().Trim() + "\" style=\"width:25px; text-align:center;\" />&nbsp;" + dt.Rows[i]["TreeName"].ToString().Trim() + "<input type=\"hidden\" name=\"hid" + i.ToString() + "\" id=\"hid" + i.ToString() + "\" value=\"" + dt.Rows[i]["Tid"].ToString().Trim() + "\" /></li>";
            }

            classListName.Visible = true;
            editClassbottom.Visible = true;
        }
        else
        {
            classListName.Visible = true;
            classListName.Text = "<li>如需排序，请选择带有子级分类的父分类！</li>";
        }
        dt.Dispose();
    }

    protected void editClassbottom_Click(object sender, EventArgs e)
    {
        for (int r = 0; r < xabara.isNum(treeCount.Value); r++)
        {
            strValue[0] = xabara.isNum(Request["tree" + r.ToString()]).ToString();
            sql.update("NewsTree", "@ListID", strValue, "Tid=" + xabara.isNum(Request.QueryString["hid" + r.ToString()]).ToString() + " and TreeType='" + typeClss + "'");
        }

        sql.log(a.uid, "admin", "修改分类排序");

        js.div(false, "", "text", "更新排序成功！", 300, 0, "classList.aspx?tClass=" + Request.QueryString["tClass"] + "&title=" + Request.QueryString["title"] + "&cid=" + Request.QueryString["cid"] + "&cidStr=" + Request.QueryString["cidStr"], "goto");
    }

    protected void waterImgButton_Click(object sender, EventArgs e)
    {
        uploadError.Text = string.Empty;
        string idTemp = DropDownListClass.Text;

        if (Convert.ToInt16(idTemp) > 0)
        {
            string UpFileReturnStr = f.upload(waterImgFileUpload, "Img", false);

            if (UpFileReturnStr.Equals("上传成功"))
            {
                DataTable dt = sql.getDataTable("select TreeNameImg from NewsTree where Tid=" + idTemp);
                if (dt.Rows.Count > 0)
                {
                    string oldImg = dt.Rows[0]["TreeNameImg"].ToString().Trim();
                    if (!string.IsNullOrEmpty(oldImg as string))
                    {
                        f.del(oldImg.Substring(5, 8) + "/" + oldImg);
                    }
                }
                dt.Dispose();

                strValue[0] = Session["NewFile"].ToString();
                sql.update("NewsTree", "@TreeNameImg", strValue, "Tid=" + idTemp + " and TreeType='" + typeClss + "'");

                sql.log(a.uid, "admin", "添加图片分类");

                uploadError.Text = "设置成功！";
            }
            else
            {
                js.div(false, "", "text", "操作失败，请重新操作！", 300, 0, "classList.aspx?tClass=" + Request.QueryString["tClass"] + "&title=" + Request.QueryString["title"] + "&cid=" + Request.QueryString["cid"] + "&cidStr=" + Request.QueryString["cidStr"], "goto");
            }
        }
        else
        {
            js.div(false, "", "text", "请选择具体子分类再进行操作！", 300, 0, "classList.aspx?tClass=" + Request.QueryString["tClass"] + "&title=" + Request.QueryString["title"] + "&cid=" + Request.QueryString["cid"] + "&cidStr=" + Request.QueryString["cidStr"], "goto");
        }
    }

    protected void DropDownListClass_SelectedIndexChanged(object sender, EventArgs e)
    {
        DataTable dt = sql.getDataTable("select * from newsTree where Tid=" + DropDownListClass.Text);
        if (dt.Rows.Count > 0)
        {
            className.Text = dt.Rows[0]["TreeName"].ToString().Trim();
            classUrl.Text = dt.Rows[0]["TreeUrl"].ToString().Trim();
        }
        dt.Dispose();
    }

    protected void adminClass_SelectedIndexChanged(object sender, EventArgs e)
    {
        Session.Add(typeClss, DropDownListClass.Text); //缓存
        Session.Add("adminClass", adminClass.Text);

        Response.Redirect("classList.aspx?tClass=" + Request.QueryString["tClass"] + "&title=" + Request.QueryString["title"] + "&cid=" + Request.QueryString["cid"] + "&cidStr=" + Request.QueryString["cidStr"], true);
    }

    protected void MoveClass_Click(object sender, EventArgs e)
    {

    }
}
