﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using xabaraCOM;
using System.Xml;
using System.IO;

public partial class webXabara_frame_area : System.Web.UI.Page
{
    admin a = new admin();
    sqlServer sql = new sqlServer();

    protected void Page_Load(object sender, EventArgs e)
    {
        a.check("xabaraCOM");

        cache.clear();

        HttpCookie ipCookies = new HttpCookie("XabaraWhere");  //cookies写入磁盘
        ipCookies.Expires = DateTime.Now.AddDays(-10);
        ipCookies.Domain = xml.read("xabara.config", "cookiesDomain", 180);
        ipCookies.Path = "/";
        Response.AppendCookie(ipCookies);

        if (!IsPostBack)
        {
            DataTable dt;
            dt = sql.getDataTable("select * from selectProvince order by id");
            this.ProvinceList.Items.Clear();
            this.ProvinceList.Items.Add(new ListItem("== 省份 ==", ""));
            for (int p = 0; p < dt.Rows.Count; p++)
            {
                this.ProvinceList.Items.Add(new ListItem(dt.Rows[p]["provinceTxt"].ToString().Trim(), dt.Rows[p]["provinceID"].ToString().Trim()));
            }
            this.ProvinceList.DataBind();
            if (xabara.isNum(xml.read("xabara.config", "province", 180)) > 0)
            {
                this.ProvinceList.Items.FindByValue(xml.read("xabara.config", "province", 180)).Selected = true;
            }
            dt.Dispose();

            DataTable dtCity = sql.getDataTable("select * from selectCity where cFather=" + xml.read("xabara.config", "province", 180) + " order by id");
            //this.CityList.Items.Clear();
            if (dtCity.Rows.Count > 0)
            {
                for (int p = 0; p < dtCity.Rows.Count; p++)
                {
                    this.CityList.Items.Add(new ListItem(dtCity.Rows[p]["cityTxt"].ToString().Trim(), dtCity.Rows[p]["cityID"].ToString().Trim()));
                }
            }
            this.CityList.DataBind();
            dtCity.Dispose();
            if (xabara.isNum(xml.read("xabara.config", "city", 180)) > 0)
            {
                this.CityList.Items.FindByValue(xml.read("xabara.config", "city", 180)).Selected = true;
            }

            DataTable dtArea = sql.getDataTable("select * from selectArea where aFather='" + xml.read("xabara.config", "city", 180) + "' order by id");
            //this.areaList.Items.Clear();
            if (dtArea.Rows.Count > 0)
            {
                for (int p = 0; p < dtArea.Rows.Count; p++)
                {
                    this.areaList.Items.Add(new ListItem(dtArea.Rows[p]["areaTxt"].ToString().Trim(), dtArea.Rows[p]["areaID"].ToString().Trim()));
                }
            }
            this.areaList.DataBind();
            if (xabara.isNum(xml.read("xabara.config", "area", 180)) > 0)
            {
                this.areaList.Items.FindByValue(xml.read("xabara.config", "area", 180)).Selected = true;
            }
            dtArea.Dispose();
        }
    }

    protected void sysSet_Click(object sender, EventArgs e)
    {
        string pathFlie = HttpContext.Current.Server.MapPath("/xabara.config");
        XmlDocument xmlDoc = new XmlDocument();
        xmlDoc.Load(pathFlie);

        XmlNodeList topM = xmlDoc.DocumentElement.ChildNodes; //得到顶层节点列表
        foreach (XmlElement xElement in topM)
        {
            if (xElement.Name == "appSettings") //判断读取子层
            {
                XmlNodeList nodelist = xElement.ChildNodes; //得到该节点的子节点               
                if (nodelist.Count > 0)
                {
                    foreach (XmlNode xnode in nodelist)
                    {
                        XmlElement xe = (XmlElement)xnode;

                        string xeStr = xe.Attributes["value"].Value;
                        switch (xe.Attributes["key"].Value) //修改值
                        {
                            case "province":
                                if (string.IsNullOrEmpty(ProvinceList.Text as string))
                                {
                                    xeStr = "0";
                                }
                                else
                                {
                                    xeStr = ProvinceList.Text;
                                }
                                break;
                            case "city":
                                if (string.IsNullOrEmpty(CityList.Text as string))
                                {
                                    xeStr = "0";
                                }
                                else
                                {
                                    xeStr = CityList.Text;
                                }
                                break;
                            case "area":
                                if (string.IsNullOrEmpty(areaList.Text as string))
                                {
                                    xeStr = "0";
                                }
                                else
                                {
                                    xeStr = areaList.Text;
                                }
                                break;
                        }
                        xe.Attributes["value"].Value = xeStr;
                    }
                }
            }
        }

        xmlDoc.Save(pathFlie);
        xmlDoc = null;
        Response.Redirect("area.aspx", true);
    }

    protected void ProvinceList_SelectedIndexChanged(object sender, EventArgs e)
    {
        this.CityList.Items.Clear();
        this.CityList.Items.Add(new ListItem("== 地级市 ==", ""));
        if (!string.IsNullOrEmpty(ProvinceList.Text as string))
        {
            DataTable dt;
            dt = sql.getDataTable("select * from selectCity where cFather=" + ProvinceList.Text.Trim() + " order by id");
            for (int p = 0; p < dt.Rows.Count; p++)
            {
                this.CityList.Items.Add(new ListItem(dt.Rows[p]["cityTxt"].ToString().Trim(), dt.Rows[p]["cityID"].ToString().Trim()));
            }
            this.CityList.DataBind();
            dt.Dispose();
        }
        this.areaList.Items.Clear();
        this.areaList.Items.Add(new ListItem("== 县级市 ==", ""));
    }

    protected void cityList_SelectedIndexChanged(object sender, EventArgs e)
    {
        this.areaList.Items.Clear();
        if (!string.IsNullOrEmpty(CityList.Text as string))
        {
            DataTable dt;
            this.areaList.Items.Add(new ListItem("== 县级市 ==", "0"));
            dt = sql.getDataTable("select * from selectArea where aFather=" + CityList.Text.Trim() + " order by id");
            if (dt.Rows.Count > 0)
            {
                for (int p = 0; p < dt.Rows.Count; p++)
                {
                    this.areaList.Items.Add(new ListItem(dt.Rows[p]["areaTxt"].ToString().Trim(), dt.Rows[p]["areaID"].ToString().Trim()));
                }
            }
            else
            {
                this.areaList.Items.Add(new ListItem("== 暂无 ==", "0"));
            }
            this.areaList.DataBind();
            dt.Dispose();
        }
    }

    protected void cnSet_Click(object sender, EventArgs e)
    {
        string pathFlie = HttpContext.Current.Server.MapPath("/xabara.config");
        XmlDocument xmlDoc = new XmlDocument();
        xmlDoc.Load(pathFlie);

        XmlNodeList topM = xmlDoc.DocumentElement.ChildNodes; //得到顶层节点列表
        foreach (XmlElement xElement in topM)
        {
            if (xElement.Name == "appSettings") //判断读取子层
            {
                XmlNodeList nodelist = xElement.ChildNodes; //得到该节点的子节点               
                if (nodelist.Count > 0)
                {
                    foreach (XmlNode xnode in nodelist)
                    {
                        XmlElement xe = (XmlElement)xnode;

                        string xeStr = xe.Attributes["value"].Value;
                        switch (xe.Attributes["key"].Value) //修改值
                        {
                            case "province":
                                xeStr = "0";
                                break;
                            case "city":
                                xeStr = "0";
                                break;
                            case "area":
                                xeStr = "0";
                                break;
                        }
                        xe.Attributes["value"].Value = xeStr;
                    }
                }
            }
        }
        xmlDoc.Save(pathFlie);
        xmlDoc = null;
        Response.Redirect("area.aspx", true);
    }
}