﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Xml;
using System.IO;
using xabaraCOM;

public partial class webXabara_frame_interfaceSet : System.Web.UI.Page
{
    admin a = new admin();
    encryptDecrypt ed = new encryptDecrypt();
    xabara x = new xabara();
    sqlServer sql = new sqlServer();

    public string soft = "";

    protected void Page_Load(object sender, EventArgs e)
    {
        a.check("|interfaceSet|");
        if (!IsPostBack)
        {
            cache.clear();

            soft = x.softName();

            regExpression reg = new regExpression();
            telMoneyRegularExpressionValidator.ValidationExpression = reg.Double;
            telMoneyRegularExpressionValidator.ErrorMessage = reg.DoubleError;
            userMoneyRegularExpressionValidator.ValidationExpression = reg.Double;
            userMoneyRegularExpressionValidator.ErrorMessage = reg.DoubleError;
            aliPayRegularExp.ValidationExpression = reg.Double;
            aliPayRegularExp.ErrorMessage = reg.DoubleError;
            tenPayRegularExp.ValidationExpression = reg.Double;
            tenPayRegularExp.ErrorMessage = reg.DoubleError;

            string pathFlie = Server.MapPath("/xabara.config");
            XmlDocument xmlDoc = new XmlDocument();
            xmlDoc.Load(pathFlie);

            tenPayID.Text = xmlDoc.DocumentElement.SelectSingleNode("//add[@key='tenPayID']").Attributes["value"].Value;
            tenPayKey.Text = xmlDoc.DocumentElement.SelectSingleNode("//add[@key='tenPayKey']").Attributes["value"].Value;
            qqAppID.Text = xmlDoc.DocumentElement.SelectSingleNode("//add[@key='qqAppID']").Attributes["value"].Value;
            qqAppKey.Text = xmlDoc.DocumentElement.SelectSingleNode("//add[@key='qqAppKey']").Attributes["value"].Value;
            aliPayID.Text = xmlDoc.DocumentElement.SelectSingleNode("//add[@key='aliPayID']").Attributes["value"].Value;
            aliPayKey.Text = xmlDoc.DocumentElement.SelectSingleNode("//add[@key='aliPayKey']").Attributes["value"].Value;
            aliPayEmail.Text = xmlDoc.DocumentElement.SelectSingleNode("//add[@key='aliPayEmail']").Attributes["value"].Value;
            this.alipayType.Items.FindByValue(xmlDoc.DocumentElement.SelectSingleNode("//add[@key='alipayType']").Attributes["value"].Value).Selected = true;
            telViewMoney.Text = xmlDoc.DocumentElement.SelectSingleNode("//add[@key='viewTelMoney']").Attributes["value"].Value;
            this.orderList.Items.FindByValue(xabara.isNum(xmlDoc.DocumentElement.SelectSingleNode("//add[@key='orderFlag']").Attributes["value"].Value).ToString()).Selected = true;
            this.openWin.Items.FindByValue(xmlDoc.DocumentElement.SelectSingleNode("//add[@key='openWin']").Attributes["value"].Value).Selected = true;
            userMoney.Text = xmlDoc.DocumentElement.SelectSingleNode("//add[@key='regMoney']").Attributes["value"].Value;
            mailSmtp.Text = xmlDoc.DocumentElement.SelectSingleNode("//add[@key='mailSmtp']").Attributes["value"].Value;
            mailAdd.Text = xmlDoc.DocumentElement.SelectSingleNode("//add[@key='mailAdd']").Attributes["value"].Value;
            mailPass.Text = ed.decryptStr(xmlDoc.DocumentElement.SelectSingleNode("//add[@key='mailPass']").Attributes["value"].Value);
            emailRegs.Text = xmlDoc.DocumentElement.SelectSingleNode("//add[@key='emailRegs']").Attributes["value"].Value;
            emailCheck.Text = xmlDoc.DocumentElement.SelectSingleNode("//add[@key='emailCheck']").Attributes["value"].Value;
            tzMail.Text = xmlDoc.DocumentElement.SelectSingleNode("//add[@key='tzMail']").Attributes["value"].Value;
            aliPayFee.Text = xmlDoc.DocumentElement.SelectSingleNode("//add[@key='alipayFee']").Attributes["value"].Value;
            tenPayFee.Text = xmlDoc.DocumentElement.SelectSingleNode("//add[@key='tenpayFee']").Attributes["value"].Value;

            xmlDoc = null;
        }
    }

    protected void sysSet_Click(object sender, EventArgs e)
    {
        string pathFlie = Server.MapPath("/xabara.config");
        XmlDocument xmlDoc = new XmlDocument();
        xmlDoc.Load(pathFlie);

        XmlNodeList topM = xmlDoc.DocumentElement.ChildNodes; //得到顶层节点列表
        foreach (XmlElement xElement in topM)
        {
            if (xElement.Name == "appSettings") //判断读取子层
            {
                XmlNodeList nodelist = xElement.ChildNodes; //得到该节点的子节点               
                if (nodelist.Count > 0)
                {
                    foreach (XmlNode xnode in nodelist)
                    {
                        XmlElement xe = (XmlElement)xnode;

                        string xeStr = xe.Attributes["value"].Value;
                        switch (xe.Attributes["key"].Value) //修改值
                        {
                            case "tenPayID":
                                xeStr = tenPayID.Text.Trim();
                                break;
                            case "tenPayKey":
                                xeStr = tenPayKey.Text.Trim();
                                break;
                            case "qqAppID":
                                xeStr = qqAppID.Text.Trim();
                                break;
                            case "qqAppKey":
                                xeStr = qqAppKey.Text.Trim();
                                break;
                            case "aliPayID":
                                xeStr = aliPayID.Text.Trim();
                                break;
                            case "aliPayKey":
                                xeStr = aliPayKey.Text.Trim();
                                break;
                            case "aliPayEmail":
                                xeStr = aliPayEmail.Text.Trim();
                                break;
                            case "alipayType":
                                xeStr = alipayType.Text.Trim();
                                break;
                            case "viewTelMoney":
                                xeStr = telViewMoney.Text.Trim();
                                break;
                            case "tenpayFee":
                                xeStr = tenPayFee.Text.Trim();
                                break;
                            case "alipayFee":
                                xeStr = aliPayFee.Text.Trim();
                                break;
                            case "regMoney":
                                xeStr = userMoney.Text.Trim();
                                break;
                            case "orderFlag":
                                xeStr = orderList.Text.Trim();
                                break;
                            case "openWin":
                                xeStr = openWin.Text.Trim();
                                break;
                            case "mailSmtp":
                                xeStr = mailSmtp.Text.Trim();
                                break;
                            case "mailAdd":
                                xeStr = mailAdd.Text.Trim();
                                break;
                            case "mailPass":
                                xeStr = ed.encryptStr(mailPass.Text.Trim());
                                break;
                            case "emailRegs":
                                xeStr = emailRegs.Text.Trim();
                                break;
                            case "emailCheck":
                                xeStr = emailCheck.Text.Trim();
                                break;
                            case "tzMail":
                                xeStr = tzMail.Text.Trim();
                                break;
                        }
                        xe.Attributes["value"].Value = xeStr;
                    }
                }
            }
        }

        xmlDoc.Save(pathFlie);
        xmlDoc = null;

        sql.log(a.uid, "admin", "接口设置");

        Response.Redirect("interfaceSet.aspx", true);
    }
}
