﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.IO;
using System.Data;
using xabaraCOM;

public partial class webXabara_frame_sitemap : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        string id = Request.QueryString["id"];
        if (id.Equals("baidu"))
        {
            id = "";
        }

        writeMap("http://" + Request.Url.Host, Server.MapPath("/sitemap" + id + ".xml"));
    }

    public static void writeMap(string _fullFileName, string mapPath)
    {
        sqlServer sql = new sqlServer();
        classify c = new classify();
        DataTable dt;
        string strLoc = string.Empty;

        string strSql = string.Empty;
        string cidStr = string.Empty;
        string ifStr = string.Empty;

        string id = HttpContext.Current.Request.QueryString["id"];
        string fullFileName = _fullFileName;

        FileInfo XMLFile = null;
        StreamWriter writerXMLFile = null;
        XMLFile = new FileInfo(mapPath);
        writerXMLFile = XMLFile.CreateText();    //添加sitMap的头 
        writerXMLFile.WriteLine("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        if (id.Equals("google")) //google　加一句
        {
            writerXMLFile.WriteLine("<urlset xmlns=\"http://www.google.com/schemas/sitemap/0.9\">");
        }
        else
        {
            writerXMLFile.WriteLine("<urlset>");
        }

        //频道各首页，每站固定格式
        //频道各首页，每站固定格式
        addXMLSitMap(writerXMLFile, fullFileName, 1.0);
        addXMLSitMap(writerXMLFile, fullFileName + "/article/default.htm", 1.0);
        addXMLSitMap(writerXMLFile, fullFileName + "/help/default.htm", 1.0);
        addXMLSitMap(writerXMLFile, fullFileName + "/student/default.htm", 1.0);
        addXMLSitMap(writerXMLFile, fullFileName + "/teacher/default.htm", 1.0);
        addXMLSitMap(writerXMLFile, fullFileName + "/onlineOrder/", 0.5);
        addXMLSitMap(writerXMLFile, fullFileName + "/member/", 0.5);

        //新闻系统---家教资讯
        dt = sql.getDataTable("select Tid from newsTree where TreeType='news' order by listID ASC,Tid ASC");
        for (int i = 0; i < dt.Rows.Count; i++)
        {
            strLoc = fullFileName + "/article/" + dt.Rows[i]["Tid"].ToString().Trim() + ".htm";
            addXMLSitMap(writerXMLFile, strLoc, 0.5);
        }
        dt.Dispose();

        cidStr = c.ReadAllClassID("news", 0); //得到所有ID
        if (cidStr.Length > 1)
        {
            string[] ids = cidStr.Split(new char[] { ',' });
            for (int i = 0; i <= ids.GetUpperBound(0); i++)
            {
                ifStr += "treeTid=" + ids[i].ToString().Trim() + " or ";
            }
            ifStr = " and (" + ifStr.Substring(0, ifStr.Length - 3) + ")";

            strSql = "select Nid from NewsXabara where 1=1 " + ifStr + " order by Nid ASC";
            dt = sql.getDataTable(strSql);
            for (int i = 0; i < dt.Rows.Count; i++)
            {
                strLoc = fullFileName + "/article/view/" + dt.Rows[i]["Nid"].ToString().Trim() + ".htm";
                addXMLSitMap(writerXMLFile, strLoc, 0.5);
            }
            dt.Dispose();
        }

        //新闻系统---帮助中心
        ifStr = string.Empty;
        dt = sql.getDataTable("select Tid from newsTree where TreeType='help' order by listID ASC,Tid ASC");
        for (int i = 0; i < dt.Rows.Count; i++)
        {
            strLoc = fullFileName + "/help/" + dt.Rows[i]["Tid"].ToString().Trim() + ".htm";
            addXMLSitMap(writerXMLFile, strLoc, 0.5);
        }
        dt.Dispose();

        cidStr = c.ReadAllClassID("help", 0); //得到所有ID
        if (cidStr.Length > 1)
        {
            string[] ids = cidStr.Split(new char[] { ',' });
            for (int i = 0; i <= ids.GetUpperBound(0); i++)
            {
                ifStr += "treeTid=" + ids[i].ToString().Trim() + " or ";
            }
            ifStr = " and (" + ifStr.Substring(0, ifStr.Length - 3) + ")";

            strSql = "select Nid from NewsXabara where 1=1 " + ifStr + " order by Nid ASC";
            dt = sql.getDataTable(strSql);
            for (int i = 0; i < dt.Rows.Count; i++)
            {
                strLoc = fullFileName + "/help/view/" + dt.Rows[i]["Nid"].ToString().Trim() + ".htm";
                addXMLSitMap(writerXMLFile, strLoc, 0.5);
            }
            dt.Dispose();
        }

        //学员教员分类
        dt = sql.getDataTable("select Tid from newsTree where TreeType='study' order by listID ASC,Tid ASC");
        for (int i = 0; i < dt.Rows.Count; i++)
        {
            strLoc = fullFileName + "/student/" + dt.Rows[i]["Tid"].ToString().Trim() + ".htm";
            addXMLSitMap(writerXMLFile, strLoc, 0.8);

            strLoc = fullFileName + "/teacher/" + dt.Rows[i]["Tid"].ToString().Trim() + ".htm";
            addXMLSitMap(writerXMLFile, strLoc, 0.8);
        }
        dt.Dispose();

        //学员信息库
        dt = sql.getDataTable("select sID from studentInfo order by sID ASC");
        for (int i = 0; i < dt.Rows.Count; i++)
        {
            strLoc = fullFileName + "/student/view/" + dt.Rows[i]["sID"].ToString().Trim() + ".htm";
            addXMLSitMap(writerXMLFile, strLoc, 0.8);
        }
        dt.Dispose();

        //教员信息库
        dt = sql.getDataTable("select tID from teacherInfo order by tID ASC");
        for (int i = 0; i < dt.Rows.Count; i++)
        {
            strLoc = fullFileName + "/teacher/view/" + dt.Rows[i]["tID"].ToString().Trim() + ".htm";
            addXMLSitMap(writerXMLFile, strLoc, 0.8);
        }
        dt.Dispose();

        //添加sitMap的尾,千万不能忘了这句
        writerXMLFile.WriteLine("</urlset>");
        writerXMLFile.Close();
        writerXMLFile.Dispose();

        HttpContext.Current.Response.Write("<div style=\"text-align:left;padding:50px;font-size:14px;\"><strong>" + id + " sitemap 生成成功！请分别向以下免费搜索引擎提交：</strong><br /><br />Google 搜索引擎：<a href=\"http://www.google.com.hk/webmasters/\" target=\"_blank\" style=\"color:red;font-size:14px;\"><strong>点击向 google 提交</strong></a><br /><br />baidu 搜索引擎：<a href=\"http://zhanzhang.baidu.com/sitesubmit\" target=\"_blank\" style=\"color:red;font-size:14px;\"><strong>点击向 baidu 提交</strong></a><br /><br />360 搜索引擎：<a href=\"http://info.so.360.cn/site_submit.html\" target=\"_blank\" style=\"color:red;font-size:14px;\"><strong>点击向 360 提交</strong></a><br /><br />soso 搜索引擎：<a href=\"http://www.soso.com/help/usb/urlsubmit.shtml\" target=\"_blank\" style=\"color:red;font-size:14px;\"><strong>点击向 soso 提交</strong></a><br /><br />sogou 搜索引擎：<a href=\"http://help.sogou.com/addurl.html\" target=\"_blank\" style=\"color:red;font-size:14px;\"><strong>点击向 sogou 提交</strong></a><br /><br />bing 搜索引擎：<a href=\"http://www.bing.com/toolbox/webmaster/\" target=\"_blank\" style=\"color:red;font-size:14px;\"><strong>点击向 bing 提交</strong></a><br /><br /><strong>google sitemap:</strong> http://" + HttpContext.Current.Request.Url.Host + "/sitemapgoogle.xml<br /><br /><strong>other sitemap:</strong> http://" + HttpContext.Current.Request.Url.Host + "/sitemap.xml</div>");
    }
    /// <summary>
    /// 生成站点地图中间部分 
    /// </summary> 
    /// <param name="writerFile"></param>
    /// <param name="strLoc"></param>
    /// <param name="priority"></param> 
    private static void addXMLSitMap(StreamWriter writerFile, string strLoc, double priority)
    {
        writerFile.WriteLine(" <url>");
        writerFile.WriteLine("  <loc>" + strLoc + "</loc>");
        writerFile.WriteLine("  <lastmod>" + DateTime.Now.ToString("yyyy-MM-dd") + "</lastmod>");
        writerFile.WriteLine("  <changefreq>daily</changefreq>");
        writerFile.WriteLine("  <priority>" + priority.ToString("0.0") + "</priority>");
        writerFile.WriteLine(" </url>");
    }
}