﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using xabaraCOM;

public partial class webXabara_news_Default : System.Web.UI.Page
{
    admin a = new admin();
    classify c = new classify();
    sqlServer sql = new sqlServer();
    javasrcipt js = new javasrcipt();

    string cidTemp = HttpContext.Current.Request.QueryString["cid"];
    public string ifPass = HttpContext.Current.Request.QueryString["ifPass"];
    public string cTypeTemp = HttpContext.Current.Request.QueryString["cType"];

    protected void Page_Load(object sender, EventArgs e)
    {
        a.check(string.Empty);

        if (!IsPostBack)
        {
            string adminIDs = a.newsIDs;
            if (cTypeTemp.Equals("help"))
            {
                adminIDs = a.helpIDs;

                newsTitle.Text = "管理文章";
            }
            else
            {
                switch (ifPass)
                {
                    case "-1":
                        newsTitle.Text = "预审新闻";
                        break;
                    case "0":
                        newsTitle.Text = "审核新闻";
                        break;
                    case "1":
                        newsTitle.Text = "管理新闻";
                        break;
                }
            }
            c.bindingDropDownList(adminIDs, false, 0, cTypeTemp, cidDropDownList);

            string keyWordsStr = Server.UrlDecode(xabara.safeSql(Request.QueryString["keyWords"]));
            string ifStr = string.Empty;
            string unionStr = string.Empty;
            string pageStr = "&ifPass=" + ifPass + "&cType=" + cTypeTemp;

            if (xabara.isNum(cidTemp) > 0) //分类读取
            {
                string cidStr = c.ReadAllClassID(cTypeTemp, xabara.isNum(cidTemp)); //得到所有ID
                //Response.Write(cidStr);
                //Response.End();

                if (cidStr.IndexOf(",") > 0)
                {
                    string[] ids = cidStr.Split(new char[] { ',' });
                    for (int i = 0; i <= ids.GetUpperBound(0); i++)
                    {
                        ifStr += " select Nid,upNameID,treeTid,upPreImg,NewTitle,titleFontB,titleFontC,NewsAuthor,ReadNums,postDate,topDate,AdminID,userID from NewsXabara where adminPass=" + ifPass + " and treeTid=" + ids[i] + " union ";
                    }
                }
                else
                {
                    ifStr = " select Nid,upNameID,treeTid,upPreImg,NewTitle,titleFontB,titleFontC,NewsAuthor,ReadNums,postDate,topDate,AdminID,userID from NewsXabara where adminPass=" + ifPass + " and treeTid=" + cidStr + " union ";

                    unionStr = " and treeTid=" + cidTemp.ToString().Trim(); //搜索判断用途
                }
                cidDropDownList.Items.FindByValue(cidTemp.Trim()).Selected = true;
            }
            else
            {
                string idNums = adminIDs;
                if (idNums.Equals("all"))
                {
                    idNums = c.ReadAllClassID(cTypeTemp, 0); //得到所有ID
                    idNums = idNums.Replace(",", "|");
                }
                else
                {
                    idNums = idNums.Substring(1, idNums.Length - 2);
                }

                if (string.IsNullOrEmpty(idNums as string))
                {
                    ifStr += " select Nid,upNameID,treeTid,upPreImg,NewTitle,titleFontB,titleFontC,NewsAuthor,ReadNums,postDate,topDate,AdminID,userID from NewsXabara where adminPass=" + ifPass + " union ";
                }
                else
                {
                    string[] ids = idNums.Split(new char[] { '|' });
                    for (int i = 0; i <= ids.GetUpperBound(0); i++)
                    {
                        ifStr += " select Nid,upNameID,treeTid,upPreImg,NewTitle,titleFontB,titleFontC,NewsAuthor,ReadNums,postDate,topDate,AdminID,userID from NewsXabara where adminPass=" + ifPass + " and treeTid=" + ids[i] + " union ";
                    }
                }
            }
            pageStr += "&cid=" + cidTemp;

            if (!String.IsNullOrEmpty(keyWordsStr as string))
            {
                ifStr = " select Nid,upNameID,treeTid,upPreImg,NewTitle,titleFontB,titleFontC,NewsAuthor,ReadNums,postDate,topDate,AdminID,userID from NewsXabara where adminPass= " + ifPass + unionStr + " and  NewTitle like '%" + xabara.safeSql(keyWordsStr) + "%' union ";
                ifStr += " select Nid,upNameID,treeTid,upPreImg,NewTitle,titleFontB,titleFontC,NewsAuthor,ReadNums,postDate,topDate,AdminID,userID from NewsXabara where adminPass=" + ifPass + unionStr + " and keyWord like '%" + xabara.safeSql(keyWordsStr) + "%' union ";

                keyWord.Text = keyWordsStr;

                pageStr += "&keyWord=" + Server.UrlEncode(keyWordsStr);
            }

            ifStr = "(" + ifStr.Substring(0, ifStr.Length - 6) + ") as news";

            string strSql = "select * from " + ifStr + " Order By TopDate desc,PostDate desc";
            //Response.Write(strSql);
            //Response.End();

            lblCurrentPage.Text = sql.RepeaterDB(RepeaterListNews, strSql, pageStr, 20, "page", "center", true);
            if (this.RepeaterListNews.Items.Count < 1)
            {
                listNews.Visible = false;
                noListNews.Visible = true;
                if (string.IsNullOrEmpty(keyWordsStr as string))
                {
                    errInfo.Text = "目前暂没有任何信息！";
                }
                else
                {
                    errInfo.Text = "目前暂没有 <strong>" + keyWordsStr + "</strong> 相关搜索记录！";
                }
            }
            else
            {
                noListNews.Visible = false;
            }
        }
    }

    public string getClass(string cid)
    {
        return c.readClassName_Link(xabara.isNum(cid), string.Empty, string.Empty);
    }

    protected void search_Click(object sender, EventArgs e)
    {
        Response.Redirect("?ifPass=" + Request.QueryString["ifPass"] + "&keyWords=" + Server.UrlEncode(keyWord.Text.Trim()) + "&cid=" + cidTemp + "&cType=" + cTypeTemp, true);
    }

    protected void cid_SelectedIndexChanged(object sender, EventArgs e)
    {
        Response.Redirect("?ifPass=" + Request.QueryString["ifPass"] + "&keyWords=" + Server.UrlEncode(keyWord.Text.Trim()) + "&cid=" + cidDropDownList.Text.Trim() + "&cType=" + cTypeTemp, true);
    }

    protected void batDelete_Click(object sender, EventArgs e)
    {
        string requestID = xabara.safeSql(Request["batDel"]);
        if (string.IsNullOrEmpty(requestID as string))
        {
            js.div(false, "", "text", "请选择选项后再点击删除按钮！", 300, 0, "", "");
        }
        else
        {
            Response.Redirect("eWebDel.aspx?ID=" + requestID, true);
        }
    }
}
