﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using xabaraCOM;

public partial class webXabara_news_eWebEdit : System.Web.UI.Page
{
    admin a = new admin();
    sqlServer sql = new sqlServer();
    classify c = new classify();
    javasrcipt js = new javasrcipt();
    fileDocument f = new fileDocument();

    protected void Page_Load(object sender, EventArgs e)
    {
        a.check("|news|");

        if (!IsPostBack)
        {
            DataTable dt;
            string strSql = "select * from NewsXabara where upNameID='" + xabara.safeSql(Request.QueryString["id"].Trim()) + "'";
            dt = sql.getDataTable(strSql);

            if (dt.Rows.Count > 0)
            {
                string type = Request.QueryString["cType"];
                string adminIDs = a.newsIDs;
                if (type.Equals("help"))
                {
                    adminIDs = a.helpIDs;
                    newsName.Text = "修改文章";
                    PostTitle.Text = "修改文章";
                }

                c.bindingDropDownList(adminIDs,true, 0, type, DropDownListClass);
                try
                {
                    this.DropDownListClass.Items.FindByValue(dt.Rows[0]["treeTid"].ToString()).Selected = true;
                }
                catch { }

                newsTitle.Text = dt.Rows[0]["NewTitle"].ToString().Trim();
                colorList.Items.FindByValue(dt.Rows[0]["titleFontC"].ToString().Trim()).Selected = true;
                if (dt.Rows[0]["titleFontB"].ToString().Trim().Equals("1"))
                {
                    checkBold.Checked = true;
                }
                newsHttp.Text = dt.Rows[0]["linkHttp"].ToString().Trim();
                newsKeyWords.Text = dt.Rows[0]["keyWord"].ToString().Trim();

                Session.Add("upFileID", dt.Rows[0]["upNameID"].ToString().Trim());//上传图片文件名ID关联"                
                Session.Add("upPreFile", dt.Rows[0]["upPreImg"].ToString().Trim()); //预览图初始值

                myEditor.Text = dt.Rows[0]["NewContent"].ToString();
                newAuthor.Text = dt.Rows[0]["NewsAuthor"].ToString();
                fromWhere.Text = dt.Rows[0]["newsFrom"].ToString();
                pDate.Text = Convert.ToDateTime(dt.Rows[0]["PostDate"]).ToString("yyyy-MM-dd HH:mm:ss");
            }
            else
            {
                js.div(false, "", "text", "您的操作不正确！", 300, 0, Server.UrlDecode(url.currently), "goto");
            }

            regExpression reg = new regExpression();
            titleRegExpress.ValidationExpression = reg.CHAR(0, 100);
            titleRegExpress.ErrorMessage = reg.charError(0, 100);
            dateRegExpree.ValidationExpression = reg.dateTime;
            dateRegExpree.ErrorMessage = reg.dateTimeError;
            RegHttp.ValidationExpression = reg.urlHttp;
            RegHttp.ErrorMessage = reg.urlHttpError;

            dt.Dispose();
        }
    }

    protected void PostNews_Click(object sender, EventArgs e)
    {
        if (!string.IsNullOrEmpty(myEditor.Text as string))
        {
            string strTitle = newsTitle.Text.Trim();
            string upFileIDsession = Session["upFileID"].ToString();//上传图片文件名ID关联"
            if (string.IsNullOrEmpty(upFileIDsession as string))
            {
                upFileIDsession = xabara.rnd("name", 5);
            }

            string dimStr = "@treeTid,@upPreImg,@NewTitle,@NewContent,@PostDate,@AdminIP,@keyWord,@titleFontB,@titleFontC,@NewsAuthor,@linkHttp,@TopDate";

            string[] strValue = new string[20];
            strValue[0] = DropDownListClass.Text;
            string preImg = Session["upPreFile"].ToString();
            strValue[1] = preImg;
            strValue[2] = strTitle;
            strValue[3] = f.emotImg(upFileIDsession, myEditor.Text, false);
            strValue[4] = pDate.Text;
            strValue[5] = new ipAddress().address();
            strValue[6] = newsKeyWords.Text.Trim();
            if (checkBold.Checked)
                strValue[7] = "1";
            else
                strValue[7] = "0";
            strValue[8] = colorList.Text.Trim();
            strValue[9] = newAuthor.Text.Trim();
            strValue[10] = newsHttp.Text.Trim();
            strValue[11] = pDate.Text;

            sql.log(a.uid, "admin", "修改新闻");
            string returnStr = sql.update("NewsXabara", dimStr, strValue, "upNameID='" + upFileIDsession + "'");

            Session.Add("upFileID", string.Empty); //ID关联清空
            Session.Add("upPreFile", string.Empty); //预览图文件名清空

            js.div(false, "", "text", returnStr, 300, 0, "default.aspx?ifPass=" + Request.QueryString["ifPass"] + "&cType=" + xabara.safeSql(Request.QueryString["cType"]), "goto");
        }
        else
        {
            js.div(false, "", "text", "内容不能为空！", 300, 0, "", "");
        }
    }

    protected void preTitle_Click(object sender, EventArgs e)
    {
        string title = newsTitle.Text.Trim();
        preTitleLable.Text = title;

        if (!string.IsNullOrEmpty(title as string))
        {
            if (checkBold.Checked)
            {
                preTitleLable.Text = "<strong>" + title + "</strong>";
            }

            if (!string.IsNullOrEmpty(colorList.Text as string))
            {
                preTitleLable.Text = "<font color='" + colorList.Text.Trim() + "'>" + preTitleLable.Text + "</font>";
            }
        }
        else
        {
            preTitleLable.Text = "<font color='red'>请输入标题内容后再预览效果</font>";
        }
    }
}
