﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="edit.aspx.cs" Inherits="webXabara_study_edit" %>

<%@ Register Assembly="CheckBoxListValidator" Namespace="CheckBoxListValidator" TagPrefix="myCheckBoxList" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>修改教员信息</title>
    <link href="../InClude/StyleSheet.css" rel="stylesheet" type="text/css" />
    <style type="text/css">
    <!--
    body {
	    margin:8px 8px 0px 0px;
    }    
    -->
    </style>
    <script src="/js/jquery.min.js" type="text/javascript"></script>
    
    <script src="/js/all.js" type="text/javascript"></script>
</head>
<body>
    <form id="form1" runat="server">
    <div class="divWidth">
    </div>
    <div class="titleBg">
        修改教员信息<asp:ScriptManager ID="ScriptManager1" runat="server" AsyncPostBackTimeout="3600">
        </asp:ScriptManager>
    </div>
    <div class="height10px">
    </div>
    <div>
        <table cellpadding="0" cellspacing="0" class="tableLine" style="width: 100%;">
            <tr>
                <td class="tdTitle">
                    目前学历
                </td>
                <td class="tdContent">
                    <asp:RadioButtonList ID="eduType" runat="server" RepeatColumns="5" RepeatDirection="Horizontal"
                        CellPadding="3" CellSpacing="3" class="inputText">
                    </asp:RadioButtonList>
                    <asp:RequiredFieldValidator ID="RequiredFieldValidator23" runat="server" ControlToValidate="eduType"
                        ErrorMessage="请选择学历，以证书为准" ForeColor="#FF3300" SetFocusOnError="True" ToolTip="请选择学历，以证书为准"></asp:RequiredFieldValidator>
                </td>
            </tr>
            <tr>
                <td class="tdTitle">
                    目前身份
                </td>
                <td class="tdContent">
                    <asp:RadioButtonList ID="teacherType" runat="server" RepeatColumns="5" RepeatDirection="Horizontal"
                        CellPadding="3" CellSpacing="3" class="inputText" CssClass="inputText">
                    </asp:RadioButtonList>
                    <asp:RequiredFieldValidator ID="RequiredFieldValidator24" runat="server" ControlToValidate="teacherType"
                        ErrorMessage="请如实填写！以工作证或聘书为准" ForeColor="#FF3300" SetFocusOnError="True" ToolTip="请如实填写！以工作证或聘书为准"></asp:RequiredFieldValidator>
                </td>
            </tr>
            <tr>
                <td class="tdTitle">
                    任教区域
                </td>
                <td class="tdContent">
                    <asp:UpdatePanel ID="UpdatePanel1" runat="server" ChildrenAsTriggers="True" RenderMode="Inline"
                        UpdateMode="Conditional">
                        <ContentTemplate>
                            <asp:DropDownList ID="ProvinceList" runat="server" CssClass="inputText" OnSelectedIndexChanged="ProvinceList_SelectedIndexChanged"
                                AutoPostBack="true">
                            </asp:DropDownList>
                            <asp:DropDownList ID="CityList" runat="server" CssClass="inputText" OnSelectedIndexChanged="cityList_SelectedIndexChanged"
                                AutoPostBack="true">
                                <asp:ListItem Selected="True" Value="">== 地级市==</asp:ListItem>
                            </asp:DropDownList>
                            <asp:DropDownList ID="areaList" runat="server" CssClass="inputText">
                                <asp:ListItem Selected="True" Value="">== 县级市 ==</asp:ListItem>
                            </asp:DropDownList>
                        </ContentTemplate>
                    </asp:UpdatePanel>
                    <asp:RequiredFieldValidator SetFocusOnError="True" ID="RequiredFieldValidator7" runat="server"
                        ControlToValidate="areaList" ErrorMessage="请选择区域" ForeColor="#FF3300"></asp:RequiredFieldValidator>
                </td>
            </tr>
            <tr>
                <td class="tdTitle">
                    就读于
                </td>
                <td class="tdContent">
                    <asp:TextBox ID="school" runat="server" CssClass="inputText" Width="200px" MaxLength="50"></asp:TextBox>
                    <asp:RequiredFieldValidator ID="RequiredFieldValidator25" runat="server" ControlToValidate="school"
                        ErrorMessage="请以全称填写学校名称，以证书为准" ForeColor="#FF3300" SetFocusOnError="True" ToolTip="请以全称填写学校名称，以证书为准"></asp:RequiredFieldValidator>
                </td>
            </tr>
            <tr>
                <td class="tdTitle">
                    所学专业
                </td>
                <td class="tdContent">
                    <asp:TextBox ID="studyProfession" runat="server" CssClass="inputText" Width="200px"
                        MaxLength="50"></asp:TextBox>
                    <asp:RequiredFieldValidator ID="RequiredFieldValidator26" runat="server" ControlToValidate="school"
                        ErrorMessage="请以全称填写专业名称，以证书为准" ForeColor="#FF3300" SetFocusOnError="True" ToolTip="请以全称填写专业名称，以证书为准"></asp:RequiredFieldValidator>
                </td>
            </tr>
            <tr>
                <td class="tdTitle">
                    教龄
                </td>
                <td class="tdContent">
                    <asp:DropDownList ID="teachAge" runat="server" CssClass="inputTextIME">
                    </asp:DropDownList>
                    <asp:RequiredFieldValidator ID="RequiredFieldValidator27" runat="server" ControlToValidate="teachAge"
                        ErrorMessage="以学生证为准" ForeColor="#FF3300" SetFocusOnError="True" ToolTip="以学生证为准"></asp:RequiredFieldValidator>
                </td>
            </tr>
            <tr>
                <td class="tdTitle">
                    可授科目与目的
                </td>
                <td class="tdContent">
                    <div style="padding: 2px;">
                        <asp:ListBox ID="gradeList" runat="server" CssClass="inputText" AutoPostBack="True"
                            OnSelectedIndexChanged="gradeList_SelectedIndexChanged" Rows="11" Style="cursor: pointer;">
                        </asp:ListBox>
                        <asp:ListBox ID="gradeCheck" runat="server" AutoPostBack="True" CssClass="inputText"
                            OnSelectedIndexChanged="gradeCheck_SelectedIndexChanged" Rows="11" Style="cursor: pointer;"
                            ToolTip="请选择其中一项"></asp:ListBox>
                        <asp:ListBox ID="gradeCheckValue" runat="server" CssClass="inputText" Rows="11" AutoPostBack="True"
                            OnSelectedIndexChanged="gradeCheckValue_SelectedIndexChanged" Style="cursor: pointer;"
                            ToolTip="点击一个即删除"></asp:ListBox>
                    </div>
                </td>
            </tr>
            <tr>
                <td class="tdTitle">
                    您是否具备开小班的条件和能力
                </td>
                <td class="tdContent">
                    <asp:RadioButtonList ID="classBool" runat="server" CellPadding="2" CellSpacing="2"
                        RepeatDirection="Horizontal" RepeatLayout="Flow">
                        <asp:ListItem>是</asp:ListItem>
                        <asp:ListItem>否</asp:ListItem>
                    </asp:RadioButtonList>
                    <asp:RequiredFieldValidator ID="RequiredFieldValidator28" runat="server" ErrorMessage="请选择其中一项"
                        ControlToValidate="classBool" ForeColor="#FF3300"></asp:RequiredFieldValidator>
                </td>
            </tr>
            <tr>
                <td class="tdTitle">
                    小班规模
                </td>
                <td class="tdContent">
                    <asp:CheckBoxList ID="classSize" runat="server" class="inputText" CellPadding="3"
                        CellSpacing="3" RepeatColumns="7" RepeatDirection="Horizontal">
                        <asp:ListItem>1-5人</asp:ListItem>
                        <asp:ListItem>5-10人</asp:ListItem>
                        <asp:ListItem>10-15人</asp:ListItem>
                        <asp:ListItem>15-20人</asp:ListItem>
                        <asp:ListItem>20-30人</asp:ListItem>
                        <asp:ListItem>全托</asp:ListItem>
                    </asp:CheckBoxList>
                    <myCheckBoxList:CheckBoxListRequiredFieldValidator ID="CheckBoxListRequiredFieldValidator3"
                        ControlToValidate="classSize" runat="server" EnableClientScript="true" ErrorMessage="至少选择一项小班规模"
                        ForeColor="#ff3300" Display="Dynamic"></myCheckBoxList:CheckBoxListRequiredFieldValidator>
                </td>
            </tr>
            <tr>
                <td class="tdTitle">
                    自我描述及特长展示
                </td>
                <td class="tdContent">
                    <asp:TextBox ID="myStudy" runat="server" CssClass="inputText" Width="400px" Height="120px"
                        TextMode="MultiLine"></asp:TextBox>
                    <br />
                    展示实力，增加你的魅力！比如你竞赛中获得过什么奖项，取得过什么出色的成绩，有哪些过硬的证书之类
                    <asp:RequiredFieldValidator ID="RequiredFieldValidator29" runat="server" ErrorMessage="请填写特长等信息"
                        ControlToValidate="myStudy" ForeColor="#FF3300"></asp:RequiredFieldValidator>
                </td>
            </tr>
            <tr>
                <td class="tdTitle">
                    可授课区域及详细描述
                </td>
                <td class="tdContent">
                    <asp:TextBox ID="teachArea" runat="server" CssClass="inputText" Width="400px" Height="120px"
                        TextMode="MultiLine"></asp:TextBox><br />
                    您可以参考以下写法：(1)区域，如： 浙江大学附近、朝阳区。(2)公交沿线，如：13、102、108、52路【请不要使用空格，尽量使用逗号来代替("，")】<asp:RequiredFieldValidator
                        ID="RequiredFieldValidator30" runat="server" ErrorMessage="请填写可授课区域等信息" ControlToValidate="teachArea"
                        ForeColor="#FF3300"></asp:RequiredFieldValidator>
                </td>
            </tr>
            <tr>
                <td class="tdTitle">
                    可辅导方式
                </td>
                <td class="tdContent">
                    <asp:CheckBoxList ID="teachStudy" runat="server" RepeatDirection="Horizontal" RepeatLayout="Flow">
                    </asp:CheckBoxList>
                    <myCheckBoxList:CheckBoxListRequiredFieldValidator ID="CheckBoxListRequiredFieldValidator2"
                        ControlToValidate="teachStudy" runat="server" EnableClientScript="true" ErrorMessage="至少选择一项授课方式"
                        ForeColor="#ff3300" Display="Dynamic"></myCheckBoxList:CheckBoxListRequiredFieldValidator>
                </td>
            </tr>
            <tr>
                <td class="tdTitle">
                    可授课时间
                </td>
                <td class="tdContent">
                    <asp:CheckBoxList ID="studyTime" runat="server" class="inputText" CellPadding="3"
                        CellSpacing="3" RepeatColumns="7" RepeatDirection="Horizontal">
                    </asp:CheckBoxList>
                    <myCheckBoxList:CheckBoxListRequiredFieldValidator ID="CheckBoxListRequiredFieldValidator1"
                        ControlToValidate="studyTime" runat="server" EnableClientScript="true" ErrorMessage="至少选择一项学习时间"
                        ForeColor="#ff3300" Display="Dynamic"></myCheckBoxList:CheckBoxListRequiredFieldValidator>
                </td>
            </tr>
            <tr>
                <td class="tdTitle">
                    授课补充说明
                </td>
                <td class="tdContent">
                    <asp:TextBox ID="studyAbout" runat="server" CssClass="inputText" Width="400px" Height="60px"
                        TextMode="MultiLine"></asp:TextBox>
                </td>
            </tr>
            <tr>
                <td class="tdTitle">
                    薪水要求
                </td>
                <td class="tdContent">
                    <asp:TextBox ID="payMoney" runat="server" CssClass="inputTextIME" Width="50px" MaxLength="20"></asp:TextBox>
                    &nbsp;元人民币<asp:DropDownList ID="payBit" runat="server" CssClass="inputText">
                    </asp:DropDownList>
                    <asp:RequiredFieldValidator SetFocusOnError="True" ID="RequiredFieldValidator21"
                        runat="server" ControlToValidate="payMoney" ErrorMessage="*" ForeColor="#FF3300"></asp:RequiredFieldValidator>
                    <asp:RegularExpressionValidator ID="payRegularExpressionValidator" runat="server"
                        ControlToValidate="payMoney" ForeColor="#FF3300" SetFocusOnError="True"></asp:RegularExpressionValidator>
                </td>
            </tr>
            <tr>
                <td class="tdTitle">
                </td>
                <td class="tdContent">
                    <asp:Button ID="edit" runat="server" CssClass="inputBottom" OnClick="edit_Click"
                        Text="确认修改" />
                </td>
            </tr>
        </table>
    </div>
    </form>
</body>
</html>
