﻿/*
 * 程序名称: JumboTCMS(将博内容管理系统通用版)
 * 
 * 程序版本: 6.x
 * 
 * 程序作者: 将博开发团队 (商业合作请联系：791104444@qq.com)
 * 
 * 版权申明: http://www.jumbotcms.net/about/copyright.html
 * 
 * 技术答疑: http://forum.jumbotcms.net/
 * 
 */

using System;
using System.Data;
using System.Web;
using System.Web.UI;
using JumboTCMS.Utils;
using JumboTCMS.DBUtility;

namespace JumboTCMS.DAL
{
    public interface IModule
    {
        /// <summary>
        /// 得到内容页地址
        /// </summary>
        /// <param name="_page"></param>
        /// <param name="_ishtml"></param>
        /// <param name="_channelid"></param>
        /// <param name="_contentid"></param>
        /// <returns></returns>
        string GetContentLink(int _page, bool _ishtml, string _channelid, string _contentid, bool _truefile);
        /// <summary>
        /// 生成内容页
        /// </summary>
        /// <param name="_ChannelId"></param>
        /// <param name="_ContentId"></param>
        /// <param name="_CurrentPage"></param>
        void CreateContent(string _ChannelId, string _ContentId, int _CurrentPage);
        /// <summary>
        /// 得到内容页
        /// </summary>
        /// <param name="_ChannelId"></param>
        /// <param name="_ContentId"></param>
        /// <param name="_CurrentPage"></param>
        string GetContent(string _ChannelId, string _ContentId, int _CurrentPage);
        /// <summary>
        /// 删除内容页
        /// </summary>
        /// <param name="_ChannelId"></param>
        /// <param name="_ContentId"></param>
        void DeleteContent(string _ChannelId, string _ContentId);
    }
}
