﻿/*
 * 程序名称: JumboTCMS(将博内容管理系统通用版)
 * 
 * 程序版本: 6.x
 * 
 * 程序作者: 将博开发团队 (商业合作请联系：791104444@qq.com)
 * 
 * 版权申明: http://www.jumbotcms.net/about/copyright.html
 * 
 * 技术答疑: http://forum.jumbotcms.net/
 * 
 */

using System;
using System.Data;
using System.Web;
using JumboTCMS.Utils;
using JumboTCMS.DBUtility;

namespace JumboTCMS.DAL
{
    /// <summary>
    /// 内容评论
    /// </summary>
    public class Normal_ReviewDAL : Common
    {
        public Normal_ReviewDAL()
        {
            base.SetupSystemDate();
        }
        /// <summary>
        /// 得到评论列表
        /// </summary>
        /// <param name="_thispage">当前页码</param>
        /// <param name="_pagesize">每页记录条数</param>
        /// <param name="_channelid">频道ID</param>
        /// <param name="_contentid">内容ID</param>
        public string GetTopList(int _thispage, int _pagesize, string _channelid, string _contentid)
        {
            using (DbOperHandler _doh = new Common().Doh())
            {
                string sqlStr = "";
                int totalCount = 0;
                string whereStr = "[IsPass]=1 AND [ParentId]=0";
                if (_channelid != "0") whereStr += " AND [ChannelId]=" + _channelid;
                if (_contentid != "0") whereStr += " AND [ContentId]=" + _contentid;
                _doh.Reset();
                _doh.ConditionExpress = whereStr;
                totalCount = _doh.Count("jcms_normal_review");

                sqlStr = JumboTCMS.Utils.SqlHelp.GetSql0("Id,ChannelId,ContentId,IP,UserName,AddDate,Content", "jcms_normal_review", "id", _pagesize, _thispage, "desc", whereStr);
                _doh.Reset();
                _doh.SqlCmd = sqlStr;
                DataTable dt = _doh.GetDataTable();
                string ResponseStr = "";
                for (int j = 0; j < dt.Rows.Count; j++)
                {
                    ResponseStr += "<li><a href=\"" + site.Dir + "review/default.aspx?ccid=" + dt.Rows[j]["ChannelId"].ToString() + "&id=" + dt.Rows[j]["ContentId"].ToString() + "#c" + dt.Rows[j]["Id"].ToString() + "\" target=\"_blank\">" + dt.Rows[j]["Content"].ToString() + "</a></li>";
                }
                dt.Clear();
                dt.Dispose();
                return ResponseStr;
            }
        }
    }
}
