﻿using System;
using System.Web;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using JumboTCMS.OAuth.Renren.APIUtility;

namespace JumboTCMS.OAuth.Renren
{
    public class RenrenApiClient
    {
        private string AppKey
        {
            get
            {
                return JumboTCMS.Utils.Session.Get("OAuth_Renren.AppKey");
            }

            set
            {
                JumboTCMS.Utils.Session.Add("OAuth_Renren.AppKey", value);
            }
        }
        private string AppSecret
        {
            get
            {
                return JumboTCMS.Utils.Session.Get("OAuth_Renren.AppSecret");
            }

            set
            {
                JumboTCMS.Utils.Session.Add("OAuth_Renren.AppSecret", value);
            }
        }
        /// <summary>
        /// 获取 Authorization code
        /// 执行此方法后，将会访问callback地址，
        /// 返回需要访问的URL地址，形式如：http://www.exaple.com?code=xxxx
        /// code就为需要获得的Authorization code。
        /// </summary>
        public void GetAuthorizationCode(string AppKey, string CallBackURL)
        {
            this.AppKey = AppKey;
            string authorizationUrl = APIConfig.AuthorizationURL;
            List<APIParameter> paras = new List<APIParameter>() { 
                new APIParameter("client_id", this.AppKey),
                new APIParameter("response_type","code"),
                new APIParameter("redirect_uri", HttpUtility.UrlEncode(CallBackURL))
            };
            string requestUrl = HttpUtil.AddParametersToURL(authorizationUrl, paras);
            System.Web.HttpContext.Current.Response.Redirect(requestUrl);
        }

        /// <summary>
        /// 执行接口方法
        /// 传入参数列表，比如接口名字，format形式等
        /// 还可以上传文件
        /// </summary>
        /// <param name="paras">参数列表</param>
        /// <param name="files">文件列表</param>
        /// <returns>服务器响应数据</returns>
        public string CallMethodWithFile(string AppKey, string AppSecret, string CallBackURL, List<APIParameter> paras, List<APIParameter> files)
        {
            this.AppKey = AppKey;
            this.AppSecret = AppSecret;
            APIValidation av = new APIValidation();
            string responseData = "";
            string session_key = av.GetSessionKey(AppKey, AppSecret, CallBackURL);
            if (session_key == "" || paras == null || paras.Count == 0 || files == null || files.Count == 0)
                return "";
            paras.Add(new APIParameter("api_key", this.AppKey));
            paras.Add(new APIParameter("call_id", DateTime.Now.Millisecond.ToString()));
            paras.Add(new APIParameter("v", "1.0"));
            paras.Add(new APIParameter("session_key", session_key));
            paras.Add(new APIParameter("format", APIConfig.Format));
            string strSig = av.CalSig(this.AppSecret, paras);
            if (strSig == "")
                return "";
            paras.Add(new APIParameter("sig", strSig));
            responseData = new SyncHttp().HttpPostWithFile(APIConfig.RenRenAPIURL, paras, files);
            return responseData;
        }
        /// <summary>
        /// 执行接口方法
        /// 传入执行方法名称，传入上传文件列表
        /// </summary>
        /// <param name="methodName">要执行的接口方法</param>
        /// <param name="files">上传文件列表</param>
        /// <returns>服务器响应</returns>
        public string CallMethodWithFile(string AppKey, string AppSecret, string CallBackURL, string methodName, List<APIParameter> files)
        {
            this.AppKey = AppKey;
            this.AppSecret = AppSecret;
            if (methodName == "" || files == null || files.Count == 0)
                return "";
            List<APIParameter> paras = new List<APIParameter>() { 
                new APIParameter("method",methodName)
            };
            return CallMethodWithFile(AppKey, AppSecret, CallBackURL, paras, files);
        }
        /// <summary>
        /// 执行接口方法
        /// 传入参数列表，比如接口名字，format形式等
        /// </summary>
        /// <param name="paras">参数列表</param>
        /// <returns>服务器响应数据</returns>
        public string CallMethod(string AppKey, string AppSecret, string CallBackURL, List<APIParameter> paras)
        {
            this.AppKey = AppKey;
            this.AppSecret = AppSecret;
            APIValidation av = new APIValidation();
            string responseData = "";
            string session_key = av.GetSessionKey(AppKey, AppSecret, CallBackURL);
            if (session_key == "" || paras == null || paras.Count == 0)
                return "";
            paras.Add(new APIParameter("api_key", AppKey));
            paras.Add(new APIParameter("call_id", DateTime.Now.Millisecond.ToString()));
            paras.Add(new APIParameter("v", "1.0"));
            paras.Add(new APIParameter("session_key", session_key));
            paras.Add(new APIParameter("format", APIConfig.Format));
            string strSig = av.CalSig(this.AppSecret, paras);
            if (strSig == "")
                return "";
            paras.Add(new APIParameter("sig", strSig));
            responseData = new SyncHttp().HttpPost(APIConfig.RenRenAPIURL, HttpUtil.GetQueryFromParas(paras));
            return responseData;
        }
        /// <summary>
        /// 获取用户信息
        /// </summary>
        /// <param name="AppKey"></param>
        /// <param name="AppSecret"></param>
        /// <param name="CallBackURL"></param>
        /// <param name="fields">字段 具体参数见：http://wiki.dev.renren.com/wiki/Users.getInfo</param>
        /// <returns></returns>
        public string GetUserInfo(string AppKey, string AppSecret, string CallBackURL, string fields)
        {
            List<APIParameter> paras = new List<APIParameter>() { 
                new APIParameter("method","users.getInfo")
            };
            paras.Add(new APIParameter("fields", fields));
            string _json = CallMethod(AppKey, AppSecret, CallBackURL, paras).Trim();
            return _json.Substring(1, _json.Length - 2);
        }
        /// <summary>
        /// 发布状态
        /// </summary>
        /// <param name="AppKey"></param>
        /// <param name="AppSecret"></param>
        /// <param name="CallBackURL"></param>
        /// <param name="status"></param>
        /// <returns></returns>
        public string SetStatus(string AppKey, string AppSecret, string CallBackURL, string status)
        {
            List<APIParameter> paras = new List<APIParameter>() { 
                new APIParameter("method","status.set")
            };
            paras.Add(new APIParameter("status", status));
            return CallMethod(AppKey, AppSecret, CallBackURL, paras);
        }
    }
}
