using System;
using System.Collections.Generic;
using System.Text;
using System.Net;
using CYQ.Data.Table;
namespace JumboTCMS.OAuth2
{
    /// <summary>
    /// Ȩ
    /// </summary>
    public abstract class OAuth2Base
    {
        protected WebClient wc = new WebClient();
        public OAuth2Base()
        {
            wc = new WebClient();
            wc.Encoding = Encoding.UTF8;
            wc.Headers.Add("Pragma", "no-cache");
        }
        #region 
        /// <summary>
        /// صĿID
        /// </summary>
        public string openID = string.Empty;
        /// <summary>
        /// ʵToken
        /// </summary>
        public string token = string.Empty;
        /// <summary>
        /// ʱ
        /// </summary>
        public DateTime expiresTime;

        /// <summary>
        /// ˺ǳ
        /// </summary>
        public string nickName = string.Empty;

        /// <summary>
        /// ˺ͷַ
        /// </summary>
        public string headUrl = string.Empty;
        /// <summary>
        /// ״ʱصCode
        /// </summary>
        internal string code = string.Empty;
        internal abstract OAuthServer server
        {
            get;
        }
        #endregion

        #region ǹ·LogoͼƬַ

        internal abstract string OAuthUrl
        {
            get;
        }
        internal abstract string TokenUrl
        {
            get;
        }
        #endregion

        #region WebConfigӦáAppKeyAppSecretCallbackUrl
        internal string AppKey
        {
            get
            {
                return  JumboTCMS.Utils.XmlCOM.ReadConfig("~/_data/config/oauth2_" + server.ToString(), "AppKey");
            }
        }
        internal string AppSecret
        {
            get
            {
                return JumboTCMS.Utils.XmlCOM.ReadConfig("~/_data/config/oauth2_" + server.ToString(), "AppSecret");
            }
        }
        internal string CallbackUrl
        {
            get
            {
                return JumboTCMS.Utils.XmlCOM.ReadConfig("~/_data/config/oauth2_" + server.ToString(), "CallbackUrl");
            }
        }
        #endregion

        #region 

        /// <summary>
        /// Token
        /// </summary>
        /// <returns></returns>
        protected string GetToken(string method)
        {
            string result = string.Empty;
            try
            {
                string para = "grant_type=authorization_code&client_id=" + AppKey + "&client_secret=" + AppSecret + "&code=" + code + "&state=" + server;
                para += "&redirect_uri=" + System.Web.HttpUtility.UrlEncode(CallbackUrl) + "&rnd=" + DateTime.Now.Second;
                if (method == "POST")
                {
                    if (string.IsNullOrEmpty(wc.Headers["Content-Type"]))
                    {
                        wc.Headers.Add("Content-Type", "application/x-www-form-urlencoded");
                    }
                    result = wc.UploadString(TokenUrl, method, para);
                }
                else
                {
                    result = wc.DownloadString(TokenUrl + "?" + para);
                }
            }
            catch(Exception err)
            {
                CYQ.Data.Log.WriteLogToTxt(err);
            }
            return result;
        }
        public abstract string GetAuthorizeURL();
        /// <summary>
        /// ȡǷͨȨ
        /// </summary>
        public abstract bool Authorize();
        /// <param name="bindAccount">ذ󶨵˺ţδ󶨷ؿգ</param>
        public bool Authorize(out string bindAccount)
        {
            bindAccount = string.Empty;
            if (Authorize())
            {
                bindAccount = GetBindAccount();
                return true;
            }
            return false;
        }

        #endregion

        #region ˺

        /// <summary>
        /// ȡѾ󶨵˺
        /// </summary>
        /// <returns></returns>
        public string GetBindAccount()
        {
            string account = string.Empty;
            using (OAuth2Account oa = new OAuth2Account())
            {
                if (oa.Fill(string.Format("OAuthServer='{0}' and OpenID='{1}'", server, openID)))
                {
                    oa.Token = token;
                    oa.ExpireTime = expiresTime;
                    oa.NickName = nickName;
                    oa.HeadUrl = headUrl;
                    oa.Update();//token͹ʱ
                    account = oa.BindAccount;
                }
            }
            return account;
        }
        /// <summary>
        /// Ӱ˺
        /// </summary>
        /// <param name="bindAccount"></param>
        /// <returns></returns>
        public bool SetBindAccount(string bindAccount)
        {
            bool result = false;
            if (!string.IsNullOrEmpty(openID) && !string.IsNullOrEmpty(token) && !string.IsNullOrEmpty(bindAccount))
            {
                using (OAuth2Account oa = new OAuth2Account())
                {
                    if (!oa.Exists(string.Format("OAuthServer='{0}' and OpenID='{1}'", server, openID)))
                    {
                        oa.OAuthServer = server.ToString();
                        oa.Token = token;
                        oa.OpenID = openID;
                        oa.ExpireTime = expiresTime;
                        oa.BindAccount = bindAccount;
                        oa.NickName = nickName;
                        oa.HeadUrl = headUrl;
                        result = oa.Insert(CYQ.Data.InsertOp.None);
                    }
                }
            }
            return result;
        }
        #endregion
    }
    /// <summary>
    /// ṩȨķ
    /// </summary>
    public enum OAuthServer
    {
        /// <summary>
        /// ΢
        /// </summary>
        Sina,
        /// <summary>
        /// ѶQQ
        /// </summary>
        Tencent,
        /// <summary>
        /// Ա
        /// </summary>
        TaoBao,
    }
}
