<%@ Control Language="C#" EnableViewState="false" AutoEventWireup="false" Inherits="FredCK.FCKeditorV2.FileBrowser.Config" %>
<script runat="server">
	public readonly string[] FileExtensions = new string[] { "7z", "aiff", "asf", "avi", "bmp", "csv", "doc", "fla", "flv", "gif", "gz", "gzip", "jpeg", "jpg", "mid", "mov", "mp3", "mp4", "mpc", "mpeg", "mpg", "ods", "odt", "pdf", "png", "ppt", "pxd", "qt", "ram", "rar", "rm", "rmi", "rmvb", "rtf", "sdc", "sitd", "swf", "sxc", "sxw", "tar", "tgz", "tif", "tiff", "txt", "vsd", "wav", "wma", "wmv", "xls", "xml", "zip" };
	public readonly string[] ImageExtensions = new string[] { "bmp", "gif", "jpeg", "jpg", "png" };
	public readonly string[] FlashExtensions = new string[] { "swf", "flv" };
	public readonly string[] MediaExtensions = new string[] { "aiff", "asf", "avi", "bmp", "fla", "flv", "gif", "jpeg", "jpg", "mid", "mov", "mp3", "mp4", "mpc", "mpeg", "mpg", "png", "qt", "ram", "rm", "rmi", "rmvb", "swf", "tif", "tiff", "wav", "wma", "wmv" };

	public bool CheckAuthentication()
	{

		if (Session["UploadIsAuthorized"] != null && (bool)Session["UploadIsAuthorized"] == true)
		{
			return true;
		}
		
		HttpCookie adminCookie = Request.Cookies["Admin"];
		if (adminCookie == null)
		{
			return false;
		}
		string adminName = adminCookie["loginname"];
		string adminPwd = adminCookie["loginpwd"];
		var service = new AdminService();
		if (service.Validate(adminName, adminPwd))
		{
			Session["UploadIsAuthorized"] = true;
			return true;
		}
		return false;
	}

	public override void SetConfig()
	{
		Enabled = CheckAuthentication();
		UserFilesPath = "~/UploadFiles";
		UserFilesAbsolutePath = "";
		ForceSingleExtension = true;
		AllowedTypes = new string[] { "File", "Image", "Flash", "Media" };
		HtmlExtensions = new string[] { "html", "htm", "xml", "xsd", "txt", "js" };

		TypeConfig["File"].AllowedExtensions = FileExtensions;
		TypeConfig["File"].DeniedExtensions = new string[] { };
		TypeConfig["File"].FilesPath = "%UserFilesPath%file/";
		TypeConfig["File"].FilesAbsolutePath = (UserFilesAbsolutePath == "" ? "" : "%UserFilesAbsolutePath%file/");
		TypeConfig["File"].QuickUploadPath = "%UserFilesPath%file/";
		TypeConfig["File"].QuickUploadAbsolutePath = (UserFilesAbsolutePath == "" ? "" : "%UserFilesAbsolutePath%");

		TypeConfig["Image"].AllowedExtensions = ImageExtensions;
		TypeConfig["Image"].DeniedExtensions = new string[] { };
		TypeConfig["Image"].FilesPath = "%UserFilesPath%image/";
		TypeConfig["Image"].FilesAbsolutePath = (UserFilesAbsolutePath == "" ? "" : "%UserFilesAbsolutePath%image/");
		TypeConfig["Image"].QuickUploadPath = "%UserFilesPath%image/";
		TypeConfig["Image"].QuickUploadAbsolutePath = (UserFilesAbsolutePath == "" ? "" : "%UserFilesAbsolutePath%");

		TypeConfig["Flash"].AllowedExtensions = FlashExtensions;
		TypeConfig["Flash"].DeniedExtensions = new string[] { };
		TypeConfig["Flash"].FilesPath = "%UserFilesPath%flash/";
		TypeConfig["Flash"].FilesAbsolutePath = (UserFilesAbsolutePath == "" ? "" : "%UserFilesAbsolutePath%flash/");
		TypeConfig["Flash"].QuickUploadPath = "%UserFilesPath%flash/";
		TypeConfig["Flash"].QuickUploadAbsolutePath = (UserFilesAbsolutePath == "" ? "" : "%UserFilesAbsolutePath%");

		TypeConfig["Media"].AllowedExtensions = MediaExtensions;
		TypeConfig["Media"].DeniedExtensions = new string[] { };
		TypeConfig["Media"].FilesPath = "%UserFilesPath%media/";
		TypeConfig["Media"].FilesAbsolutePath = (UserFilesAbsolutePath == "" ? "" : "%UserFilesAbsolutePath%media/");
		TypeConfig["Media"].QuickUploadPath = "%UserFilesPath%media/";
		TypeConfig["Media"].QuickUploadAbsolutePath = (UserFilesAbsolutePath == "" ? "" : "%UserFilesAbsolutePath%");
	}
</script>
