﻿<%@ Control Language="C#" Inherits="System.Web.Mvc.ViewUserControl<IEnumerable<MvcEnterprise.Models.DataSet1+ArticleRow>>" %>
<%
    var searchText = Request.QueryString["searchText"];
	int SortID = 1;
%>
<%= Html.ActionLink("添加新闻","ArticleEdit") %>
<hr />
<div id="requestAjaxText">
    <form action="" id="searchForm" method="get" style="display:inline">
    <label>查找：</label>
    <input type="text" name="searchText" id="searchText" value="<%= searchText %>" /> <input type="submit" value="查找" />
    <% if (!string.IsNullOrEmpty(searchText))
       {%>
    <input type="submit" value="全部显示" onclick="$('#searchText').val('');" />
    <%}%>
    </form>
    <label>筛选：</label>
    <%= Html.DropDownList("SortPath", new SelectList(new CategoryService<DataSet1.ArticleSortRow, DataSet1.ValidationArticleSort>(new ArticleSortService()).CategoryList(SortID), "SortPath", "SortName"))%>
    <form method="post" id="MultiOperationForm" action="?action=MultiOperation">
    <table class="tablesorter">
		<thead>
			<tr>
				<th>
					发布
				</th>
				<th>
					显示顺序
				</th>
				<th>
					新闻标题
				</th>
				<th>
					公告
				</th>
				<th>
					推荐
				</th>
				<th>
					查看权限
				</th>
				<th>
					权限值
				</th>
				<th>
					添加时间
				</th>
				<th>
					点击次数
				</th>
				<th>
					操作
				</th>
				<th>
					<input type="checkbox" id="cb_ReverseSelection" />
				</th>
			</tr>
		</thead>
        <%
            foreach (var item in Model)
            { %>
        <tr>
            <td>
                <input type="checkbox" name="ViewFlag<%= item.ID %>" <%= item.ViewFlag ? "checked=\"checked\"" : "" %> />
            </td>
            <td>
                <input name="SortID<%= item.ID %>" style="width: 28px;" onblur="if(!(/^(-|\+)?\d+$/.test(this.value))){alert('只能输入整数。');this.focus();this.select();}"
                    type="text" maxlength="4" value="<%= item.Sequence %>" />
            </td>
            <td>
				<a href="<%= Url.Action("ArticleEdit", new { id = item.ID })%>" title="编辑内容"><%= Html.Encode(item.ArticleName, searchText)%></a>
				<a href="<%=Url.Action("ArticleView","Home",new {id=item.ID}) %>" target="_blank"><img src="../../Content/images/ie.gif" alt="浏览网页" title="浏览网页" /></a>
            </td>
            <td align="center">
                <input type="checkbox" name="NoticeFlag<%= item.ID %>" <%= item.NoticeFlag ? "checked=\"checked\"" : "" %> />
            </td>
            <td align="center">
                <input type="checkbox" name="CommendFlag<%= item.ID %>" <%= item.CommendFlag ? "checked=\"checked\"" : "" %> />
            </td>
            <td>
                <%= Html.Encode(new MemGroupService().GetModel(item.GroupID).GroupName)%>
            </td>
            <td>
                <%= item.Exclusive == "=" ? "<span style='color:red'>专属</span>" :  item.Exclusive == ">=" ? "<span style='color:green'>隶属</span>" : "未知"%>
            </td>
            <td>
                <%= Html.Encode(item.AddTime)%>
            </td>
            <td>
                <%= Html.Encode(item.ClickNumber)%>
            </td>
            <td>
                <%= Html.ActionLink("编辑", "ArticleEdit", new { id=item.ID }) %>
				<%= Html.ActionLink("复制", "CopyModel", new { id = item.ID, name = "Article" })%>
				<a href="javascript:;" onclick="deleteModel(this,<%= item.ID %>);">删除</a>
            </td>
            <td>
                <input type="checkbox" name="cb_id" value="<%=item.ID %>" />
            </td>
        </tr>
        <% } %>
    </table>
	<div class="OpArea">
		执行
		<select name="OpType">
			<option value="1">保存</option>
			<option value="2">删除</option>
			<option value="3">改变分类</option>
		</select>
		<%= Html.DropDownList("DestSortPath", new SelectList(new CategoryService<DataSet1.ArticleSortRow, DataSet1.ValidationArticleSort>(new ArticleSortService()).CategoryList(0), "SortPath", "SortName"), new { style="display:none"})%>
		<input type="submit" value="操作" />
	</div>
    </form>
    <%= Html.Pager(3) %>
</div>
<br class="clearfloat" />
<script src="../../Scripts/jquery.ReverseSelection.js" type="text/javascript"></script>
<script type="text/javascript">
    $.initReverseSelection(); //初始反选功能
    $(function () {
		$("select[name='OpType']").change(function(){
			if (parseInt(this.value)==3) {
				$("#DestSortPath").show();
			}
			else {
				$("#DestSortPath").hide();
			}
		});
        $("#MultiOperationForm").submit(function () {
            if ($("select[name='OpType']").val() == 2) {
                if (!confirm("确认删除？")) {
                    return false;
                }
            }
        });
        $("option[value='<%= Request.QueryString["SortPath"] %>']").attr("selected", "selected");
        $("select[name='SortPath']").change(function(){
            window.location.href="?SortPath="+this.value;
        });
        $(":checkbox[name^='NoticeFlag']").bind("click", function() {
            try{
                $(this).css("background","#FF6600");
                $(":checkbox[value='" + this.name.replace("NoticeFlag", "") + "']")[0].checked = true;
            }
            catch(err) {}
        });
        $(":checkbox[name^='CommendFlag']").bind("click", function() {
            try{
                $(this).css("background","#FF6600");
                $(":checkbox[value='" + this.name.replace("CommendFlag", "") + "']")[0].checked = true;
            }
            catch(err) {}
        });
    });
</script>
<link rel="stylesheet" type="text/css" href="../../Scripts/tablesorter/style.css" />
<script type="text/javascript" src="../../Scripts/jquery.tablesorter.js"></script>
<script type="text/javascript">
	$(function () {
		$(".tablesorter").tablesorter({ debug: false });
	});
</script>
