﻿<%@ Control Language="C#" Inherits="System.Web.Mvc.ViewUserControl<IEnumerable<MvcEnterprise.Models.DataSet1+TalentsRow>>" %>
<%
var searchText = Request.QueryString["searchText"];
%>
<div id="requestAjaxText">
    <form action="" id="searchForm" method="get">
    <label>
        查找：</label>
    <input type="text" name="searchText" id="searchText" value="<%= searchText %>" />
    <input type="submit" value="查找" />
    <% if (!string.IsNullOrEmpty(searchText)) {%>
    <input type="submit" value="全部显示" onclick="$('#searchText').val('');" />
    <%}%>
    </form>
    <form method="post" id="MultiOperationForm" action="?action=MultiOperation">
    <table class="tablesorter">
		<thead>
			<tr>
				<th>
					姓名
				</th>
				<th>
					应聘职位
				</th>
				<th>
					电子邮件
				</th>
				<th>
					提交时间
				</th>
				<th>
					回复时间
				</th>
				<th>
					操作
				</th>
				<th>
					<input type="checkbox" id="cb_ReverseSelection" />
				</th>
			</tr>
		</thead>
		<%
            foreach (var item in Model)
            { %>
        <tr>
            <td>
                <%= Html.Encode(item.Linkman,searchText)%>
            </td>
            <td>
                <%= Html.Encode(item.TalentsName,searchText)%>
            </td>
            <td>
                <%= Html.Encode(item.Email,searchText)%>
            </td>
            <td>
                <%= Html.Encode(item.AddTime)%>
            </td>
			<td>
				<%= item.ReplyTime.Year<1900 ? "<span style='color:red'>待处理</span>":"<span style='color:green'>"+string.Format("{0:g}",item.ReplyTime)+"</span>"%>
			</td>
            <td>
                <%= Html.ActionLink("查看与回复", "TalentsEdit", new { id=item.ID }) %>
            </td>
            <td>
                <input type="checkbox" name="cb_id" value="<%=item.ID %>" />
            </td>
        </tr>
        <% } %>
    </table>
	<div class="OpArea">
		执行
		<select name="OpType">
			<option value="2">删除</option>
		</select>
		<input type="submit" value="操作" />
	</div>
    </form>
    <%= Html.Pager(3) %>
</div>
<br class="clearfloat" />
<script src="../../Scripts/jquery.ReverseSelection.js" type="text/javascript"></script>
<script type="text/javascript">
    $.initReverseSelection(); //初始反选功能
    $(function () {
        $("#MultiOperationForm").submit(function () {
            if ($("select[name='OpType']").val() == 2) {
                if (!confirm("确认删除？")) {
                    return false;
                }
            }
        });
    });
</script>
<link rel="stylesheet" type="text/css" href="../../Scripts/tablesorter/style.css" />
<script type="text/javascript" src="../../Scripts/jquery.tablesorter.js"></script>
<script type="text/javascript">
	$(function () {
		$(".tablesorter").tablesorter({ debug: false });
	});
</script>
