﻿<%@ Control Language="C#" Inherits="System.Web.Mvc.ViewUserControl<MvcEnterprise.Models.DataSet1+ProductRow>" %>
<%
	var viewName = Request.QueryString["viewname"];
	if (viewName == null || viewName.ToLower() == "productview") viewName = string.Empty;
%>
<div class="Location">
	<%= Html.ActionLink(Language.Context.Global.HomePage, "Index")%>
	<%= ViewData["PageLocation"] %>
</div>
<div>
	<% if (AdminService.AdminName == "admin")
	{
		Response.Write(Html.ActionLink("【编辑】", "ProductEdit", "Admin", new { ID = Model.ID }, new { style = "color:#F00;font-weight:bold", target = "_blank" }));%>
	<%} %>
</div>
<div class="WebContent">
	<h1 class="ProductName"><%= Model.ProductName %></h1>
	<% if (!MembersService.CanAccess(Model.GroupID,Model.Exclusive))
	{
		Html.RenderPartial("partial_Page_NoRight");
	} else {%>
	<%
		var BigPics = "../../Content/images/NoPicture.jpg|";
		if (!string.IsNullOrEmpty(Model.BigPic.Replace("|", string.Empty)))
		{
			BigPics = Model.BigPic;
		}
	%>
	<div style="height: 215px;">
		<script src="../../Scripts/x2.js" type="text/javascript"></script>
		<div id="imgContainer">
			<%
		var imgs = BigPics.Split('|');
		var margin = string.Empty;
		if (!string.IsNullOrEmpty(imgs.Skip(1).First().Trim()))
		{
			margin = @"style=""margin-right:90px;""";
			%>
			<div id="album">
				<input type="button" class="up" onclick="MarqueeUp();" />
				<div id="albumimgs">
					<%
			foreach (var img in imgs)
			{
				if (!string.IsNullOrEmpty(img))
				{
					string thumbimg = img;
					if (img.IndexOf("://") == -1)
					{
						int offset = img.LastIndexOf('.');
						thumbimg = img.Insert(offset, "_thumb");
					}
					%>
					<img src="<%= thumbimg %>" alt="" onload="DrawImage(this,80,66)" onclick="ShowImage('<%= img %>');" />
					<%}
					}%>
				</div>
				<input type="button" class="down" onclick="MarqueeDown();" />
			</div>
			<script type="text/javascript">$("#imgContainer").width("445px");</script>
			<% } %>
			<div <%= margin %> id="detailImgContainer">
				<table style="width: 100%; height: 100%;">
					<tr>
						<td align="center" valign="middle" width="100%">
							<img id="loadingImg" src="../../Content/images/loading_32x32.gif" width="32" height="32"
								alt="" style="display: none" />
							<img id="detailImg" src="<%= imgs[0] %>" alt="<%= Model.ProductName.StripHTML() %>"
								style="display: none" />
						</td>
					</tr>
				</table>
			</div>
			<br class="clearfloat" />
		</div>
		<div class="productproperties">
			<div>
				<span class="editor-label"><%= Language.Context.Product.LabelProductNo %></span>
				<span class="editor-field"><%= Model.ProductNo %></span>
			</div>
			<div>
				<span class="editor-label"><%= Language.Context.Product.LabelProductModel %></span>
				<span class="editor-field"><%= Model.ProductModel %></span>
			</div>
			<div>
				<span class="editor-label"><%= Language.Context.Product.LabelPrice %></span>
				<span class="editor-field price">￥<%= Model.Price %> <%= Language.Context.Product.PriceUnit%></span>
			</div>
			<div>
				<span class="editor-label"><%= Language.Context.Product.ClickNumber %></span>
				<span class="editor-field"><%= Model.ClickNumber %></span>
			</div>
			<div>
				<a href="<%= Url.Action("ProductOrder",new {ID=Model.ID}) %>">
					<img src="../../Content/images/Button_buy_01.gif" alt="<%= Language.Context.Product.BuyNow %>" /></a></div>
		</div>
		<br class="clearfloat" />
	</div>
	<%= Model.Content%>
	<%} %>
	<hr />
	<%
		var allModel=new ProductService().GetAllvisible();
		var pModel = allModel.Where(m => m.ID < Model.ID && m.SortID == Model.SortID).FirstOrDefault();
		string pID = string.Empty,pName,nID = string.Empty,nName;
		if (pModel!=null)
		{
			pID=pModel.ID.ToString();
			pName=pModel.ProductName;
		}
		else
		{
			pName = Language.Context.Global.NoneOther;
		}
		var nModel = allModel.Where(m => m.ID > Model.ID).LastOrDefault();
		if (nModel!=null)
		{
			nID=nModel.ID.ToString();
			nName = nModel.ProductName;
		}
		else
		{
			nName = Language.Context.Global.NoneOther;
		}
	%>
	<div><%= Language.Context.Product.Tags %><%= Model.Tags %></div>
	<div><% Html.RenderPartial("partial_Favorites"); %></div>
	<ul class="ListTitle">
		<li><a href="<%= string.IsNullOrEmpty(pID) ? "javascript:;" : Url.Action("ProductView",new {ID = pID, viewName = viewName}) %>"><%= Language.Context.Article.Prev %><%= pName %></a></li>
		<li><a href="<%= string.IsNullOrEmpty(nID) ? "javascript:;" : Url.Action("ProductView",new {ID = nID, viewName = viewName}) %>"><%= Language.Context.Article.Next %><%= nName %></a></li>
	</ul>
</div>