﻿$(document).ready(function () {

    //页面控件调用
    var $companyBtn = $("#compant_Btn");
    var $comprovices = $("#comProvices_select");
    var $comcity = $("#comCity_select");
    var $comdistricts = $("#comDistricts_select");
    var $comindustry = $("#comIndustry_select");
    var $comindustrysub = $("#comIndustrySub_select");
    //提示器调用
    var $companyMsg = $("#companybtn_msg");

    //点击城市
    $comprovices.change(function () {
        $comprovices.attr("rel", $(this).val());
        $comcity.attr("rel", "0");
        $comdistricts.attr("rel", "0");
        showCity($(this).val());
    });

    //点击地区
    $comcity.change(function () {
        $comcity.attr("rel", $(this).val());
        showDistricts($(this).val());
    });

    //绘出省
    function showProvices() {
        $.ajax({
            type: "get",
            url: "/XmlData/Provinces.xml",
            //data: null,
            datatype: "xml",
            beforeSend: function (xml) { $comprovices.html("loading..") },
            success: function (xml) {
                var showHtml = "<option value=\"0\">① == 选择省份 ==</option>";
                $(xml).find("Provinces > Province").each(function (i) {
                    showHtml += "<option value=\"" + $(this).attr("ID") + "\">" + $(this).attr("ProvinceName") + "</option>";
                });
                $comprovices.html(showHtml);

                //遍历选中
                $comprovices.find("option").each(function () {
                    if ($(this).val() == $comprovices.attr("rel")) {
                        $(this).attr("selected", "selected");
                    }
                });

            },
            error: function (xml) { alert('Error loading XML document' + xml); }
        });
        showCity($comprovices.attr("rel"));
    }
    showProvices();

    //绘出城市
    function showCity(id) {
        $.ajax({
            type: "get",
            url: "/XmlData/Cities.xml",
            //data: null,
            datatype: "xml",
            beforeSend: function (xml) {
                $comcity.attr("disabled", false);
                $comcity.html("loading..");
            },
            success: function (xml) {
                var showHtml = "<option value=\"0\">② == 选择城市 ==</option>";
                $(xml).find("Cities > City[PID=" + id + "]").each(function (i) {
                    showHtml += "<option value=\"" + $(this).attr("ID") + "\">" + $(this).attr("CityName") + "</option>";
                });
                $comcity.html(showHtml);

                //遍历选中
                $comcity.find("option").each(function () {
                    if ($(this).val() == $comcity.attr("rel")) {
                        $(this).attr("selected", "selected");
                    }
                });

            },
            error: function (xml) { alert('Error loading XML document' + xml); }
        });
        showDistricts($comcity.attr("rel"));
    }

    //绘出地区
    function showDistricts(id) {
        $.ajax({
            type: "get",
            url: "/XmlData/Districts.xml",
            //data: null,
            datatype: "xml",
            beforeSend: function (xml) {
                $comdistricts.attr("disabled", false);
                $comdistricts.html("loading..");
            },
            success: function (xml) {
                var showHtml = "<option value=\"0\">③ == 选择地区 ==</option>";
                $(xml).find("Districts > District[CID=" + id + "]").each(function (i) {
                    showHtml += "<option value=\"" + $(this).attr("ID") + "\">" + $(this).attr("DistrictName") + "</option>";
                });
                $comdistricts.html(showHtml);

                //遍历选中
                $comdistricts.find("option").each(function () {
                    if ($(this).val() == $comdistricts.attr("rel")) {
                        $(this).attr("selected", "selected");
                    }
                });

            },
            error: function (xml) { alert('Error loading XML document' + xml); }
        });
    }

    //绘出行业大类
    function showIndustry() {
        $.ajax({
            type: "get",
            url: "/XmlData/Industry.xml",
            //data: null,
            datatype: "xml",
            beforeSend: function (xml) { $comindustry.html("loading..") },
            success: function (xml) {
                var showHtml = "<option value=\"0\">① == 选择行业大类 ==</option>";
                $(xml).find("Industry > big").each(function (i) {
                    showHtml += "<option value=\"" + $(this).attr("id") + "\">" + $(this).attr("industryname") + "</option>";
                });
                $comindustry.html(showHtml);

                //遍历选中
                $comindustry.find("option").each(function () {
                    if ($(this).val() == $comindustry.attr("rel")) {
                        $(this).attr("selected", "selected");
                    }
                });

            },
            error: function (xml) { alert('Error loading XML document' + xml); }
        });
        showIndustrySub($comindustry.attr("rel"));
    }
    showIndustry();

    //绘出行业小类
    function showIndustrySub(id) {
        $.ajax({
            type: "get",
            url: "/XmlData/IndustrySub.xml",
            //data: null,
            datatype: "xml",
            beforeSend: function (xml) {
                $comindustrysub.attr("disabled", false);
                $comindustrysub.html("loading..");
            },
            success: function (xml) {
                var showHtml = "<option value=\"0\">② == 选择行业小类 ==</option>";
                $(xml).find("industrysub > bigsub[bid=" + id + "]").each(function (i) {
                    showHtml += "<option value=\"" + $(this).attr("id") + "\">" + $(this).attr("industrysubname") + "</option>";
                });
                $comindustrysub.html(showHtml);

                //遍历选中
                $comindustrysub.find("option").each(function () {
                    if ($(this).val() == $comindustrysub.attr("rel")) {
                        $(this).attr("selected", "selected");
                    }
                });

            },
            error: function (xml) { alert('Error loading XML document' + xml); }
        });
    }
    //点击行业小类
    $comindustry.change(function () {
        showIndustrySub($(this).val());
    });

})