﻿$(function () {

    //判断左边菜单高度
    if ($("#leftMenuBox").height() < $(window).height()) {
        $("#leftMenuBox").css("height", $(window).height() - 28 + "px");
    }

    //首次加载
    function showMenu() {
        if ($.cookie('parentMenu') == null) {
            var obj = $("#parentMenu li a").eq(0);
            obj.addClass("active");
            $("#s_" + obj.attr("href") + "").show();
        } else {
            //获取Cookie
            var obj = $("#parentMenu li a[rel='" + $.cookie('parentMenu') + "']");
            obj.addClass("active");
            $("#s_" + obj.attr("href") + "").show();
        }

    }
    showMenu();

    //固定滚动条
    $("#parentMenu>li>a").click(function () { return false; })
    $("#parentMenu>li>a").click(function () {
        var obj = $(this);
        $(".right_sonbox").css("top", obj.offset().top - 34 + "px");

        $("#parentMenu li a").removeClass("active");
        obj.addClass("active");

        //显示子级
        $("ul[rel='sonList']").hide();
        $("#s_" + obj.attr("href") + "").show();

        //写入Cookie
        $.cookie('parentMenu', null);
        $.cookie('parentMenu', $.trim(obj.attr("rel")), 7);

        return false;
    });

    //textarea限制长度
    $("textarea[maxlength]").keyup(function () {
        var area = $(this);
        var max = parseInt(area.attr("maxlength"), 10); //获取maxlength的值 
        if (max > 0) {
            if (area.val().length > max) { //textarea的文本长度大于maxlength 
                area.val(area.val().substr(0, max)); //截断textarea的文本重新赋值 
            }
        }
    });
    $("textarea[maxlength]").blur(function () {
        var area = $(this);
        var max = parseInt(area.attr("maxlength"), 10); //获取maxlength的值 
        if (max > 0) {
            if (area.val().length > max) { //textarea的文本长度大于maxlength 
                area.val(area.val().substr(0, max)); //截断textarea的文本重新赋值 
            }
        }
    });

    //动态更新key关键词
    $(".infobox a[rel='keylink']").click(function () {
        $(this).hide();
        $(this).next().show();
        $(this).next().focus();
        $(this).next().val($(this).attr("title"));
        $(this).next().select();
        $(this).attr("title", $(this).next().val());
        return false;
    })
    $(".infobox textarea[name='keyfoucs_txt']").blur(function () {
        var $objectText = $(this);
        $objectText.hide();
        $objectText.prev().show();
        if ($.trim($objectText.val()) != "") {
            $.ajax({
                type: "POST",
                url: "Ajax/Navi.ashx",
                data: { 'com': 'promotion', 'type': 'key', 'objectid': $objectText.attr("id").replace('key-', ''), 'content': $objectText.val(), 'naviname': $objectText.attr("naviname") },
                datatype: "json",
                beforeSend: function (data, textStatus) {
                    $objectText.prev().text("保存中..");
                    $objectText.prev().attr("title", $objectText.val());
                },
                success: function (data, textStatus) {
                    if (data != "0") {
                        $objectText.prev().text(cutStr($objectText.val(), 16));
                        $objectText.prev().attr("title", $objectText.val());
                    } else {
                        alert("保存失败!");
                    }
                },
                error: function (e) { }
            })
        }
    })
    //动态更新推广描述
    $(".infobox a[rel='descriptlink']").click(function () {
        $(this).hide();
        $(this).next().show();
        $(this).next().focus();
        $(this).next().val($(this).attr("title"));
        $(this).next().select();
        $(this).attr("title", $(this).next().val());
        return false;
    })
    $(".infobox textarea[name='descriptfoucs_txt']").blur(function () {
        var $objectText = $(this);
        $objectText.hide();
        $objectText.prev().show();
        if ($.trim($objectText.val()) != "") {
            $.ajax({
                type: "POST",
                url: "Ajax/Navi.ashx",
                data: { 'com': 'promotion', 'type': 'descript', 'objectid': $objectText.attr("id").replace('descript-', ''), 'content': $objectText.val(), 'naviname': $objectText.attr("naviname") },
                datatype: "json",
                beforeSend: function (data, textStatus) {
                    $objectText.prev().text("保存中..");
                },
                success: function (data, textStatus) {
                    if (data != "0") {
                        $objectText.prev().text(cutStr($objectText.val(), 16));
                        $objectText.prev().attr("title", $objectText.val());
                    } else {
                        alert("保存失败!");
                    }
                },
                error: function (e) { }
            })
        }
    })
})