﻿$(function () {
    //编辑器自定义
    $("#videoContent_txt").xheditor({
        width: 680,
        height: 180,
        skin: 'nostyle',
        tools: '|,Bold,Italic,Underline,Strikethrough,|,Separator,Blocktag,Fontface,FontSize,FontColor,BackColor,|,Align,List,Outdent,Indent,Separator,|,SelectAll,Removeformat,Print,Preview,Fullscreen,/,|,Cut,Copy,Paste,Pastetext,|,Link,Unlink,Img,Flash,Media,Flv,Table,Emot,Code,|,Quote,map,Page,Source,About',
        //图片上传
        upBtnText: '上传',
        upImgUrl: "Ajax/EditUpload.ashx?com=pic&immediate=1",
        upImgExt: "jpg,jpeg,gif,png,bmp",

        //Flash上传
        upFlashUrl: "Ajax/EditUpload.ashx?com=flash&immediate=1",
        upFlashExt: "swf",

        //视频上传
        upMediaUrl: "Ajax/EditUpload.ashx?com=media&immediate=1",
        upMediaExt: "flv"
    });

    //上传视频
    $("#uploadImgBtn").uploadify({
        swf: 'Plugin/Uploadify/uploadify.swf',
        uploader: 'Ajax/SwfUpload.ashx',
        postData: { com: 'uploadvideo', pastfile: $("#videoPath_hide").val(), 'videoid': $("#videoID_hide").val() },
        transparent: true,
        debug: false,
        buttonText: '选择视频上传',
        width: '100',
        height: '28',
        auto: true,
        cancelImage: 'Plugin/Uploadify/uploadify-cancel.png',
        fileTypeDesc: '格式支持',
        fileTypeExts: '*.flv',
        fileSizeLimit: 10000000 * 1024, // 10MB
        multi: false, //是否允许多文件上传
        queueID: 'fileQueue',
        queueSizeLimit: 999,
        removeCompleted: false,
        onSelect: function (file) { },
        onUploadStart: function (file) {

            $("#uploadMsg").attr("class", "point ico-remind F B");
            $("#uploadMsg").html("正在上传…");

            var showHtml = "";
            showHtml += "<span class=\"G\">视频文件：" + cutStr(file.name, 20) + "</span><br />";
            showHtml += "<span class=\"V NoB\">视频大小：" + Capacity(file.size) + "</span>";
            $("#uploadFileSetBox").html(showHtml);

            //更新参数
            $("#uploadImgBtn").uploadifySettings('postData', { com: 'uploadvideo', pastfile: $("#videoPath_hide").val(), 'videoid': $("#videoID_hide").val() });

        },
        onUploadProgress: function (file, fileBytesLoaded, fileTotalBytes, queueBytesLoaded, uploadSize) {
            var showHtml = "";
            showHtml += "<span class=\"G\">视频文件：" + cutStr(file.name, 20) + " </span><br />";
            showHtml += "<span class=\"V NoB\">视频大小：" + Capacity(file.size) + "</span><br />";
            showHtml += "<span class=\"F B\"><span class=\"Q\">已完成" + Math.round(fileBytesLoaded / fileTotalBytes * 100) + "% <span class=\"R NoB\">(" + Capacity(queueBytesLoaded) + ")</span></span></span>";

            $("#uploadFileSetBox").html(showHtml);

            $("#uploadMsg").html("正在上传… [" + file.name + "]");

        },
        onUploadSuccess: function (file, response, status) {
            var showHtml = "";

            showHtml += "<span class=\"G\">视频文件：" + cutStr(file.name, 22) + " </span><br />";
            showHtml += "<span class=\"V NoB\">视频大小：" + Capacity(file.size) + "</span><br />";
            showHtml += "<a class=\"Q B underline\" rel=\"playvideo\" href=\"/Upload/Video/" + response + "\">[播放视频]</a> ";
            showHtml += "<a class=\"R B underline\" rel=\"delvideo\" href=\"" + response + "\">[删除视频]</a>";
            $("#uploadFileSetBox").html(showHtml);
            $("#videoPath_hide").val(response);

            $("#uploadMsg").attr("class", "point ico-via Q B");
            $("#uploadMsg").html("视频上传成功!");

        }, //上传单个文件成功触发
        onSelectError: function (file, errorCode, errorMsg) { }, //选择文件有误触发事件
        onUploadComplete: function (file) { }, //批量上传成功触发事件
        onUploadError: function (file, errorCode, errorMsg) {
            alert(errorMsg);
        }
    });

    //上传视频缩略图
    $("#uploadPicBtn").uploadify({
        swf: 'Plugin/Uploadify/uploadify.swf',
        uploader: 'Ajax/SwfUpload.ashx',
        postData: { com: 'uploadvideopic', pastpic: $("#videoPic_hide").val(), 'vid': $("#videoID_hide").val() },
        transparent: true,
        debug: false,
        buttonText: '缩略图上传',
        width: '100',
        height: '28',
        auto: true,
        cancelImage: 'Plugin/Uploadify/uploadify-cancel.png',
        fileTypeDesc: '格式支持',
        fileTypeExts: '*.gif;*.jpg;*.jgeg;*.bmp;*.png;',
        fileSizeLimit: 10 * 1024, // 10MB
        multi: false, //是否允许多文件上传
        queueID: 'fileQueue',
        queueSizeLimit: 999,
        removeCompleted: false,
        onSelect: function (file) { },
        onUploadStart: function (file) {
            $("#uploadPicMsg").attr("class", "point ico-remind F B");
            $("#uploadPicMsg").html("正在上传…");
        },
        onUploadProgress: function (file, fileBytesLoaded, fileTotalBytes, queueBytesLoaded, uploadSize) {
            $("#uploadPicMsg").html("正在上传…<span class=\"Q\">完成" + Math.round(fileBytesLoaded / fileTotalBytes * 100) + "% <span class=\"R NoB\">(" + Capacity(queueBytesLoaded) + ")</span></span><span class=\"X NoB\"> | (大小:" + Capacity(uploadSize) + ")</span>");
        },
        onUploadSuccess: function (event, response, status) {
            $("#uploadPicMsg").attr("class", "point ico-via Q B");
            $("#uploadPicMsg").html("图片上传成功!");
            $("#videoImg_txt").attr("src", "../Upload/Video_Pic/" + response + "");
            $("#videoPic_hide").val(response);
        }, //上传单个文件成功触发
        onSelectError: function (file, errorCode, errorMsg) {
            $("#uploadPicMsg").attr("class", "point ico-error R");
            if (errorCode == -110) {
                $("#uploadPicMsg").html("上传失败!文件超出上传限制大小");
            } else {
                $("#uploadPicMsg").html("上传失败!");
            }
        }, //选择文件有误触发事件
        onUploadComplete: function (file) { }, //批量上传成功触发事件
        onUploadError: function (file, errorCode, errorMsg) {
            alert(errorMsg);
        }
    });

    //标题颜色
    $("#colorBox a").click(function () {
        if ($("#videoTitle_text").val() != "") {
            $("#videoTitle_text").css("color", $(this).attr("href"));
            $("#videoTitleColor_hide").val($(this).attr("href"));
        } else {
            alert("请先输入下载名称!");
        }
        return false;
    });
    //标题加粗
    $("#videoTitleisbold_chk").click(function () {
        if ($("#videoTitle_text").val() != "") {
            if ($(this).attr("checked") == true) {
                $("#videoTitle_text").css("font-weight", "bold");
            } else {
                $("#videoTitle_text").css("font-weight", "100");
            }
        } else {
            alert("请先输入下载名称!");
        }
    });

    showTab($("#videoAdd_Tab"));

    //删除视频
    $("a[rel='delvideo']").live("click", function () {
        var $delObject = $(this);
        if (confirm("确定要删除该视频吗？")) {
            $.ajax({
                type: "POST",
                url: "Ajax/Video.ashx",
                data: { 'com': 'delvideofile', 'pastfile': $delObject.attr("href"), 'vid': $("#videoID_hide").val() },
                datatype: "json",
                beforeSend: function (data, textStatus) { },
                success: function (data, textStatus) {
                    if (data == "1") {
                        var showHtml = "";

                        showHtml += "<span class=\"G\">请点击右边按钮上传视频</span><br />";
                        showHtml += "<span class=\"G\">文件支持：flv</span><br />";
                        showHtml += "<span class=\"V NoB\">如视频格式非flv，推荐视频转换工具 <a target=\"_blank\" class=\"Q underline\" href=\"http://www.baidu.com/s?wd=格式工厂\">下载</a></span>";

                        $("#uploadFileSetBox").html(showHtml);
                        $("#videoPath_hide").val("");
                    } else {
                        alert("删除失败");
                    }
                },
                error: function (e) { alert("连接失败,请向Eoyoo官方技术人员反馈!"); }
            });

        }
        return false;
    });

    //播放器层
    $("a[rel='playvideo']").live("click", function () {
        $object = $(this);


        var showHtml = "";
        showHtml += "<div class=\"title\">视频播放</div>";
        showHtml += "<p>";
        showHtml += "<div style=\"height:280px;\" id=\"videoPlayBox\"></div>";
        showHtml += "</p>";
        $("#ouBox .video").html(showHtml);

        //播放器赋值
        $f("videoPlayBox", "/Plugin/flowplayer/flowplayer-3.2.14.swf", {
            clip: {
                url: $object.attr("href"),
                autoPlay: true,
                autoBuffering: true
            }
        });

        if ($("#ouBox").is(":hidden")) $("#ouBox").slideToggle(60);
        return false;
    });

    //关闭层停止播放
    $("#ouBox a[class='close']").click(function () {
        $f("videoPlayBox").stop();
    })

    //提交判断
    $("form").submit(function () {
        $("input[type='text'],input[type='password'],textarea").trigger("blur");
        $("select").trigger("change");

        ///新增方法填写在此///

        /////

        if ($("form span").hasClass("ico-error")) {
            $("input:submit").attr("disabled", false);
            $("input:submit").next("span").attr("class", "point ico-error R");
            $("input:submit").next("span").text("请按照提示正确操作，检查各项填写");
            setInterval(delSubmitBtnMsg, 3000);
            return false;
        } else {
            $("input:submit").attr("disabled", true);
            $("input:submit").next("span").attr("class", "Q");
            $("input:submit").next("span").html("<img src=\"Images/Loading.gif\" align=\"middle\" /> 正在保存…");
        }
    });

});
