﻿$(function () {

    //点击切换tab信息
    $("#tabInteract li a").click(function () {
        $("#tabInteract li a").removeClass("active");
        $(this).addClass("active");
        getTabInteract($(this).attr("href"));
        return false;
    })

    //首次加载
    getTabInteract("1");

    //获取tab信息
    function getTabInteract(getType) {
        $.ajax({
            type: "POST",
            url: "Ajax/Interact.ashx",
            data: { com: 'gethometab', typeid: getType },
            datatype: "json",
            beforeSend: function (data, textStatus) {
                $("#Interact_list").html("<span class=\"V\">数据正在远程加载中…</span>");
            },
            success: function (data, textStatus) {
                var JosnData = eval(data);
                $("#Interact_list").html("");
                var ShowHtml = "";
                if (JosnData != null) {
                    if (JosnData.length > 0) {
                        for (var i = 0; i < JosnData.length; i++) {
                            ShowHtml += "<li>";
                            ShowHtml += "<span class=\"time Size9 V\">" + JosnData[i].addtime + "</span>";
                            ShowHtml += "<span class=\"G\"><a target=\"_blank\" href=\"" + JosnData[i].url + "\">" + JosnData[i].title + "</a></span> ";
                            ShowHtml += "<span class=\"Q Size9\">new!</span>";
                            ShowHtml += "<span class=\"content K\">" + cutStr(JosnData[i].content, 38) + "</span>";
                            ShowHtml += "</li>";
                        }
                    } else {
                        ShowHtml += "<li>暂无记录</li>";
                    }
                }
                $("#Interact_list").html(ShowHtml);

            },
            error: function (XMLHttpRequest, textStatus, errorThrown) { alert(errorThrown); }
        });
    }

    //获取最后填写的备忘录
    function getLatelyMemorandum() {
        $.ajax({
            type: "POST",
            url: "Ajax/Memorandum.ashx",
            data: { com: 'getlatelymemorandum' },
            datatype: "json",
            beforeSend: function (data, textStatus) {
                $("#text_memorandum").val("载入中...");
                $("#btn_memorandum").attr("disabled", true);
            },
            success: function (data, textStatus) {
                if (data != "") {
                    $("#text_memorandum").val(data);
                    $("#NewMemorandum", top.document).html(data);
                } else {
                    $("#text_memorandum").val("输入个试试!");
                    $("#btn_memorandum").val("开始备注");
                    $("#NewMemorandum", top.document).html("没填写有备注哦!");
                }
                $("#btn_memorandum").attr("disabled", false);
            },
            error: function (XMLHttpRequest, textStatus, errorThrown) { alert(errorThrown); }
        })
    }
    getLatelyMemorandum();


    $("#text_memorandum").focus(function () {
        $("#text_memorandum").val("");
        $("#btn_memorandum").attr("disabled", false);
        $("#text_memorandum").toggleClass("K");
    }).blur(function () {
        if ($("#text_memorandum").val() == "") {
            getLatelyMemorandum();
            $("#btn_memorandum").attr("disabled", true);
            $("#text_memorandum").toggleClass("K");
        }
    })

    //提交新备注

    $("#btn_memorandum").click(function () {
        var setContent = $("#text_memorandum").val();
        if (setContent != "") {
            $.ajax({
                type: "POST",
                url: "Ajax/Memorandum.ashx",
                data: { com: 'setmemorandum', setcontent: setContent },
                datatype: "json",
                beforeSend: function (data, textStatus) {

                },
                success: function (data, textStatus) {
                    if (data != "") {
                        $("#text_memorandum").val(setContent);
                        $("#btn_memorandum").val("提交备注");
                        alert("备注成功!");
                        $("#NewMemorandum", top.document).html(setContent);
                    } else {
                        $("#btn_memorandum").val("重写提交");
                    }
                    $("#btn_memorandum").attr("disabled", false);
                },
                error: function (XMLHttpRequest, textStatus, errorThrown) { alert(errorThrown); }
            })
        } else {
            $("#btn_memorandum").attr("disabled", true);
        }
    })

    //重启应用程序
    $("#resetApplications").click(function () {
        $("#resetApplications").text("正在重启应用程序...");
        location.href = "Home.aspx?reset=yes";
    })

    //进度条动画
    function showSata() {
        var obj = $(".satalist_list,.sataitem_list").find("li p");
        var number = 0;
        function requst() {
            $(obj[number]).animate({
                height: $(obj[number]).attr("rel")
            }, {
                duration: 30,
                specialEasing: {},
                step: function (obj) {
                    $(this).find("span").css("text-indent", "0em");
                },
                queue: true,
                complete: function () {
                    number++;
                    requst();
                }
            });
        }
        requst();
    }


    //点击切换统计信息
    $("#tabSata li a").click(function () {
        $("#tabSata li a").removeClass("active");
        $(this).addClass("active");
        getTabSata($(this).attr("href"));
        return false;
    })

    //获取数组最大值
    Array.prototype.max = function () {
        var max = this[0];
        var len = this.length;
        for (var i = 1; i < len; i++) {
            if (this[i] > max) {
                max = this[i];
            }
        }
        return max;
    }
    //获取数组最小值
    Array.prototype.min = function () {
        var min = this[0];
        var len = this.length;
        for (var i = 1; i < len; i++) {
            if (this[i] < min) {
                min = this[i];
            }
        }
        return min;
    }

    //获取统计信息
    function getTabSata(getType) {
        $("#sataDivBox").html("");
        var jsonDate = null;
        $.ajax({
            type: "POST",
            url: "Ajax/Home.ashx",
            data: { com: getType },
            datatype: "json",
            async: false,
            beforeSend: function (data, textStatus) {
                $("#sataDivBox").html("<img src=\"Images/Loading.gif\" align=\"middle\" /> 报表生成中…")
            },
            success: function (data, textStatus) {
                jsonDate = eval(data);
            },
            error: function (XMLHttpRequest, textStatus, errorThrown) { alert(errorThrown); }
        })

        switch (getType) {
            //访问记录报表                                                                                                                       
            case "pv":
                var showHtml = "";
                showHtml += "<ul class=\"satalist_list\">";
                var max = parseInt(jsonDate[0].pv);
                var min = parseInt(jsonDate[0].pv);
                for (var i = 0; i < 24; i++) {
                    if (parseInt(jsonDate[i].pv) > max) {
                        max = parseInt(jsonDate[i].pv);
                    }
                    if (parseInt(jsonDate[i].pv) < min) {
                        min = parseInt(jsonDate[i].pv);
                    }
                }
                var toDaySum = 0;
                for (var i = 0; i < 24; i++) {
                    if (parseInt(jsonDate[i].pv) == max) {
                        showHtml += "<li><p rel=\"100\" class=\"yellow\"><span>" + jsonDate[i].pv + "</span></p></li>";
                    }
                    else {
                        showHtml += "<li><p rel=\"" + (parseInt(jsonDate[i].pv / max * 100) < 15 ? 15 : jsonDate[i].pv / max * 100) + "\" class=\"" + (parseInt(jsonDate[i].pv) == min ? "green" : parseInt(jsonDate[i].pv) == 0 ? "green" : "grey") + "\"><span>" + jsonDate[i].pv + "</span></p></li>";
                    }
                    toDaySum = toDaySum + parseInt(jsonDate[i].pv);
                }
                showHtml += "</ul>";
                showHtml += "<ul class=\"satalist_text\">";
                showHtml += "<li>0:00</li><li>1:00</li><li>2:00</li><li>3:00</li><li>4:00</li><li>5:00</li><li>6:00</li><li>7:00</li><li>8:00</li>";
                showHtml += "<li>9:00</li><li>10:00</li><li>11:00</li><li>12:00</li><li>13:00</li><li>14:00</li><li>15:00</li><li>16:00</li><li>17:00</li>";
                showHtml += "<li>18:00</li><li>19:00</li><li>20:00</li><li>21:00</li><li>22:00</li><li>23:00</li>";
                showHtml += "</ul>";
                showHtml += "<div class=\"sataname\">今日访问<span class=\"G NoB\">（总访问:" + toDaySum + "）</span></div>";

                showHtml += "<ul class=\"satalist_list\">";
                var yesDay = 0;
                var max = 0;
                var min = 10000;
                for (var i = 24; i < 48; i++) {
                    if (parseInt(jsonDate[i].pv) > max) {
                        max = parseInt(jsonDate[i].pv);
                    }
                    if (parseInt(jsonDate[i].pv) < min) {
                        min = parseInt(jsonDate[i].pv);
                    }
                }

                var toDaySum = 0;
                for (var i = 24; i < 48; i++) {
                    if (parseInt(jsonDate[i].pv) == max) {
                        showHtml += "<li><p rel=\"100\" class=\"yellow\"><span>" + jsonDate[i].pv + "</span></p></li>";
                    }
                    else {
                        showHtml += "<li><p rel=\"" + (parseInt(jsonDate[i].pv / max * 100) < 15 ? 15 : jsonDate[i].pv / max * 100) + "\" class=\"" + (parseInt(jsonDate[i].pv) == min ? "green" : parseInt(jsonDate[i].pv) == 0 ? "green" : "grey") + "\"><span>" + jsonDate[i].pv + "</span></p></li>";
                    }
                    yesDay = yesDay + parseInt(jsonDate[i].pv);
                }
                showHtml += "</ul>";
                showHtml += "<ul class=\"satalist_text\">";
                showHtml += "<li>0:00</li><li>1:00</li><li>2:00</li><li>3:00</li><li>4:00</li><li>5:00</li><li>6:00</li><li>7:00</li><li>8:00</li>";
                showHtml += "<li>9:00</li><li>10:00</li><li>11:00</li><li>12:00</li><li>13:00</li><li>14:00</li><li>15:00</li><li>16:00</li><li>17:00</li>";
                showHtml += "<li>18:00</li><li>19:00</li><li>20:00</li><li>21:00</li><li>22:00</li><li>23:00</li>";
                showHtml += "</ul>";
                showHtml += "<div class=\"sataname\">昨日访问<span class=\"G NoB\">（总访问:" + yesDay + "）</span></div>";

                $("#sataDivBox").html(showHtml);
                showSata();
                break;

            //访客记录报表                                                                                                                        
            case "ip":
                var showHtml = "";
                var toDay = 0; yesDay = 0;
                showHtml += "<ul class=\"satalist_list\">";

                var max = parseInt(jsonDate[0].ipcount);
                var min = parseInt(jsonDate[0].ipcount);
                for (var i = 24; i < 48; i++) {
                    if (parseInt(jsonDate[i].ipcount) > max) {
                        max = parseInt(jsonDate[i].ipcount);
                    }
                    if (parseInt(jsonDate[i].ipcount) < min) {
                        min = parseInt(jsonDate[i].ipcount);
                    }
                }

                for (var i = 24; i < 48; i++) {
                    if (jsonDate[i].ipcount == max)
                        showHtml += "<li><p rel=\"100\" class=\"yellow\"><span>" + jsonDate[i].ipcount + "</span></p></li>";
                    else
                        showHtml += "<li><p rel=\"" + (parseInt(jsonDate[i].ipcount / max * 100) < 15 ? 15 : jsonDate[i].ipcount / max * 100) + "\" class=\"" + (jsonDate[i].ipcount == min ? "green" : "grey") + "\"><span>" + jsonDate[i].ipcount + "</span></p></li>";
                    toDay = toDay + parseInt(jsonDate[i].ipcount);
                }
                showHtml += "</ul>";
                showHtml += "<ul class=\"satalist_text\">";
                showHtml += "<li>0:00</li><li>1:00</li><li>2:00</li><li>3:00</li><li>4:00</li><li>5:00</li><li>6:00</li><li>7:00</li><li>8:00</li>";
                showHtml += "<li>9:00</li><li>10:00</li><li>11:00</li><li>12:00</li><li>13:00</li><li>14:00</li><li>15:00</li><li>16:00</li><li>17:00</li>";
                showHtml += "<li>18:00</li><li>19:00</li><li>20:00</li><li>21:00</li><li>22:00</li><li>23:00</li>";
                showHtml += "</ul>";
                showHtml += "<div class=\"sataname\">今日访客<span class=\"G NoB\">（总:" + toDay + "）</span></div>";

                showHtml += "<ul class=\"satalist_list\">";
                max = 0;
                min = 10000;
                for (var i = 0; i < 24; i++) {
                    if (parseInt(jsonDate[i].ipcount) > max) {
                        max = parseInt(jsonDate[i].ipcount);
                    }
                    if (parseInt(jsonDate[i].ipcount) < min) {
                        min = parseInt(jsonDate[i].ipcount);
                    }
                }

                for (var i = 0; i < 24; i++) {
                    if (jsonDate[i].ipcount == max)
                        showHtml += "<li><p rel=\"100\" class=\"yellow\"><span>" + jsonDate[i].ipcount + "</span></p></li>";
                    else
                        showHtml += "<li><p rel=\"" + (parseInt(jsonDate[i].ipcount / max * 100) < 15 ? 15 : jsonDate[i].ipcount / max * 100) + "\" class=\"" + (jsonDate[i].ipcount == min ? "green" : "grey") + "\"><span>" + jsonDate[i].ipcount + "</span></p></li>";
                    toDay = toDay + parseInt(jsonDate[i].ipcount);
                }
                showHtml += "</ul>";
                showHtml += "<ul class=\"satalist_text\">";
                showHtml += "<li>0:00</li><li>1:00</li><li>2:00</li><li>3:00</li><li>4:00</li><li>5:00</li><li>6:00</li><li>7:00</li><li>8:00</li>";
                showHtml += "<li>9:00</li><li>10:00</li><li>11:00</li><li>12:00</li><li>13:00</li><li>14:00</li><li>15:00</li><li>16:00</li><li>17:00</li>";
                showHtml += "<li>18:00</li><li>19:00</li><li>20:00</li><li>21:00</li><li>22:00</li><li>23:00</li>";
                showHtml += "</ul>";
                showHtml += "<div class=\"sataname\">昨日访客<span class=\"G NoB\">（总:" + yesDay + "）</span></div>";

                $("#sataDivBox").html(showHtml);
                showSata();
                break;

            //导航记录报表                                                                                                                         
            case "navi":
                var showHtml = "";

                showHtml += "<div class=\"demo-ico\">";
                showHtml += "<span class=\"stat-bule-ico\"></span>今天";
                showHtml += "<span class=\"stat-yellow-ico\"></span>昨天";
                showHtml += "<span class=\"stat-green-ico\"></span>前天";
                showHtml += "</div>";

                for (var i = 0; i < jsonDate.length; i++) {
                    var pvs = [parseInt(jsonDate[i].todaypv), parseInt(jsonDate[i].yespv), parseInt(jsonDate[i].pv)];
                    var maxpv = parseInt(Math.max.apply(Math, pvs));
                    showHtml += "<div class=\"sataitem\">";
                    showHtml += "<ul class=\"sataitem_list\">";
                    showHtml += "<li><p rel=\"" + (jsonDate[i].todaypv == 0 ? 14 : 100 * (jsonDate[i].todaypv / maxpv)) + "\" class=\"blue\"><span>" + jsonDate[i].todaypv + "</span></p></li>";
                    showHtml += "<li><p rel=\"" + (jsonDate[i].yespv == 0 ? 14 : 100 * (jsonDate[i].yespv / maxpv)) + "\" class=\"green\"><span>" + jsonDate[i].yespv + "</span></p></li>";
                    showHtml += "<li><p rel=\"" + (jsonDate[i].pv == 0 ? 14 : 100 * (jsonDate[i].pv / maxpv)) + "\" class=\"yellow\"><span>" + jsonDate[i].pv + "</span></p></li>";
                    showHtml += "<div class=\"clear-0\"></div>";
                    showHtml += "</ul>";
                    showHtml += "<div class=\"clear-8\"></div>";
                    showHtml += "<div title=\"" + jsonDate[i].name + "\" class=\"sataname\">" + cutStr(jsonDate[i].name, 4) + "<span class=\"G NoB Size9\">（总:" + (parseInt(jsonDate[i].todaypv) + parseInt(jsonDate[i].yespv) + parseInt(jsonDate[i].pv)) + "）</span></div>";
                    showHtml += "</div>";
                }
                $("#sataDivBox").html(showHtml);
                showSata();
                break;
            //受访页面记录报表                                                                                                                          
            case "page":
                var showHtml = "";
                showHtml += "<ul class=\"satapage_list\">";
                for (var i = 0; i < jsonDate.length; i++) {
                    showHtml += "<li><a title=\"" + jsonDate[i].pageurl + "\" href=\"http://" + window.location.host + jsonDate[i].pageurl + "\" target=\"_blank\">" + cutStr(jsonDate[i].pageurl, 14) + "</a> <span class=\"Size9 E NoB\">pv:" + jsonDate[i].pv + " / ip:" + jsonDate[i].ipnum + "</span></li>";
                }
                showHtml += "</ul>";
                $("#sataDivBox").html(showHtml);
                showSata();
                break;
            //模型记录报表                                                                                                                          
            case "module":
                var showHtml = "";
                showHtml += "<div class=\"demo-ico\">";
                showHtml += "<span class=\"stat-bule-ico\"></span>今天";
                showHtml += "<span class=\"stat-yellow-ico\"></span>昨天";
                showHtml += "<span class=\"stat-green-ico\"></span>前天";
                showHtml += "</div>";

                for (var i = 0; i < jsonDate.length; i++) {
                    var pvs = [parseInt(jsonDate[i].todaypv), parseInt(jsonDate[i].yespv), parseInt(jsonDate[i].pv)];
                    var maxpv = parseInt(Math.max.apply(Math, pvs));
                    showHtml += "<div class=\"sataitem\">";
                    showHtml += "<ul class=\"sataitem_list\">";
                    showHtml += "<li><p rel=\"" + (jsonDate[i].todaypv == 0 ? 14 : 100 * (jsonDate[i].todaypv / maxpv)) + "\" class=\"blue\"><span>" + jsonDate[i].todaypv + "</span></p></li>";
                    showHtml += "<li><p rel=\"" + (jsonDate[i].yespv == 0 ? 14 : 100 * (jsonDate[i].yespv / maxpv)) + "\" class=\"green\"><span>" + jsonDate[i].yespv + "</span></p></li>";
                    showHtml += "<li><p rel=\"" + (jsonDate[i].pv == 0 ? 14 : 100 * (jsonDate[i].pv / maxpv)) + "\" class=\"yellow\"><span>" + jsonDate[i].pv + "</span></p></li>";
                    showHtml += "<div class=\"clear-0\"></div>";
                    showHtml += "</ul>";
                    showHtml += "<div class=\"clear-8\"></div>";
                    showHtml += "<div class=\"sataname\">" + jsonDate[i].name + "<span class=\"G NoB\">（总:" + (parseInt(jsonDate[i].todaypv) + parseInt(jsonDate[i].yespv) + parseInt(jsonDate[i].pv)) + "）</span></div>";
                    showHtml += "</div>";
                }
                $("#sataDivBox").html(showHtml);
                showSata();
                break;
        }
    }
    getTabSata("pv");

    //是否授权
    function isAuthorized() {
        $.ajax({
            type: "POST",
            url: "Ajax/Interact.ashx",
            data: { com: 'isauthorized' },
            datatype: "json",
            beforeSend: function (data, textStatus) {
                $("#isAuthorized").html("验证中…");
            },
            success: function (data, textStatus) {
                if (data != "") {
                    $("#isAuthorized").html(data);
                }

            },
            error: function (XMLHttpRequest, textStatus, errorThrown) { alert(errorThrown); }
        });
    }
    isAuthorized();
})