﻿$(function () {

    ESONCalendar.bind("addtime1_text");
    ESONCalendar.bind("addtime2_text");

    //查询订单
    $("#order_Btn").click(function () {
        var para = "";
        if ($("#barcode_text").val() != "") para += "&barcode=" + $("#barcode_text").val();
        if ($("#addtime1_text").val() != "" && $("#addtime2_text").val() != "") para += "&time1=" + $("#addtime1_text").val() + "&time2=" + $("#addtime2_text").val();
        location.href = $(this).attr("rel") + para;
        return false;
    });

    //订单号焦点
    $("#barcode_text").focus(function () {
        if ($(this).val() == "输入订单号") $(this).val("");
    }).blur(function () {
        if ($(this).val() == "") $(this).val("输入订单号");
    });

    //处理订单
    $("a[rel='state']").click(function () {
        var $object = $(this);
        $.ajax({
            type: "POST",
            url: "Ajax/Product.ashx",
            data: { 'com': 'productorderstate', 'oid': $object.attr("rev"), 'now': $object.attr("href"), 'rname': $object.attr("title"), 'barcode': $object.attr("barcode") },
            datatype: "json",
            beforeSend: function (data, textStatus) {
                showMsg("订单正在处理中", true);
            },
            success: function (data, textStatus) {
                if (data == "1") {
                    if ($object.attr("href") == "0") {
                        $object.text("[处理订单]");
                        $object.attr("href", "1");
                        $object.attr("class", "F underline");
                    } else {
                        $object.attr("href", "0");
                        $object.text("[恢复未处理]");
                        $object.attr("class", "Q underline");
                    }
                } else {
                    alert("处理失败!");
                }
                showMsg("", false);
            },
            error: function (e) { alert("连接失败,请向Eoyoo官方技术人员反馈!"); }
        })

        return false;
    });

    //删除订单
    $("a[rel='del']").click(function () {
        var $delObject = $(this);
        if (confirm("确定要删除订单 [ " + $delObject.attr("title") + " ] 吗？")) {
            $.ajax({
                type: "POST",
                url: "Ajax/Product.ashx",
                data: { 'com': 'delorder', 'oid': $delObject.attr("href"), 'barcode': $delObject.attr("title") },
                datatype: "json",
                beforeSend: function (data, textStatus) {
                    showMsg("[ " + $delObject.attr("title") + " ] 正在删除中 ", true);
                },
                success: function (data, textStatus) {
                    if (data == "1") {
                        $delObject.parent().parent("tr").remove();
                    } else {
                        alert("删除失败!");
                    }
                    showMsg("", false);
                },
                error: function (e) { alert("连接失败,请向Eoyoo官方技术人员反馈!"); }
            })
        }
        return false;
    });

    //订单明细
    $("a[rel='intro']").click(function () {
        $object = $(this);
        if ($("#ouBox").is(":hidden")) $("#ouBox").slideToggle(60);
        $.ajax({
            type: "POST",
            url: "Ajax/Product.ashx",
            data: { 'com': 'getorder', 'oid': $object.attr("href") },
            datatype: "json",
            beforeSend: function (data, textStatus) {
                var showHtml = "";
                showHtml += "<div class=\"title\">订单号：" + $object.attr("rev") + "</div>";
                showHtml += "<p>加载中...</p>";
                $("#ouBox .content").html(showHtml);
            },
            success: function (data, textStatus) {
                var showHtml = "";
                //拆分Josn数据
                var JosnData = eval(data);
                if (JosnData != null) {
                    showHtml += "<div class=\"title\">订单号：" + $object.attr("rev") + "</div>";
                    showHtml += "<p>";
                    showHtml += "<span class=\"C B\">订单信息：</span><br />";
                    showHtml += "订购产品:" + JosnData[0].productname + "<br />";
                    showHtml += "订购数量:" + JosnData[0].number + "<br />";
                    showHtml += "订购备注:" + JosnData[0].explain + "<br />";
                    showHtml += "下单时间:" + JosnData[0].addtime + "<br />";
                    showHtml += "<span class=\"C B\">下单人信息：</span><br />";
                    showHtml += "昵称:" + JosnData[0].nickname + "<br />";
                    showHtml += "真实姓名:" + JosnData[0].realname + "<br />";
                    showHtml += "所在地:" + JosnData[0].seat + "<br />";
                    showHtml += "会员:" + JosnData[0].membername + "<br />";
                    showHtml += "金币:" + JosnData[0].gold + "<br />";
                    if (JosnData[0].sex == "True") {
                        showHtml += "性别:男<br />";
                    } else {
                        showHtml += "性别:女<br />";
                    }
                    showHtml += "Email:" + JosnData[0].email + "<br />";
                    showHtml += "电话:" + JosnData[0].phone + "<br />";
                    showHtml += "在线通讯:" + JosnData[0].online + "<br />";
                    showHtml += "<span class=\"C B\">下单人客户端信息追踪：</span><br />";
                    showHtml += "客户端IP:" + JosnData[0].ip + "<br />";
                    showHtml += "ip所在地:" + JosnData[0].ipcity + "<br />";
                    showHtml += "浏览器:" + JosnData[0].browser + "<br />";
                    showHtml += "操作系统:" + JosnData[0].os + "";
                    showHtml += "</p>";

                }
                $("#ouBox .content").html(showHtml);
            },
            error: function (e) { alert("连接失败,请向Eoyoo官方技术人员反馈!"); }
        })

        return false;
    })

});