﻿/*
Author by Czou.com
Data:2012-11
While retaining the copyright case can be modified
*/
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data.Sql;
using System.Data;
using System.Text;

using Czou.Common;
using Czou.DataModel;
using Czou.Business.AdminUser;

namespace Czou2012.UI.Manager.AdminUser
{
    public partial class authorizationSet : System.Web.UI.Page
    {
        string strUserID = "0";
        string strPassword = "";
        string strUserName = "";
        string strTrueName = "";
        string strGroupID = "";
        string strOrganName = "";
        string strOrganID = "";
        string strRemark = "";
        string strSort = "0";
        string strState = "0";
        string UserDisabled = "";

        private StringBuilder objBuilder = new StringBuilder();


        protected void Page_Load(object sender, EventArgs e)
        {
            //超时判断
            CommonClass.SessionEntity.ValidSession();

            int nUserID = ComStringHelper.IntParse(Request["UserID"]);

            //获取用户信息
            DmAdminUser nAdminUser = new DmAdminUser();
            nAdminUser.UserID = nUserID;

            DataSet myDS =BusAuthorization.GetAuthorizationUser(nAdminUser);

            if (!Object.Equals(myDS, null) && myDS.Tables[0].Rows.Count > 0)
            {
                DataRow UserRow = myDS.Tables[0].Rows[0];
                strUserID = UserRow["UserID"].ToString();
                strPassword = UserRow["Password"].ToString();
                strUserName = UserRow["UserName"].ToString();
                strTrueName = UserRow["TrueName"].ToString();
                strOrganName = UserRow["OrganName"].ToString();
                strOrganID = UserRow["OrganID"].ToString();
                strGroupID = UserRow["GroupID"].ToString();
                strRemark = UserRow["Remark"].ToString();
                strSort = UserRow["Sort"].ToString();
                strState = UserRow["State"].ToString();
                myDS.Dispose();
            }
            else
            {
                strUserID = "0";
                strPassword = "";
                strUserName = "";
                strTrueName = "";
                strGroupID = "";
                strOrganName = "";
                strOrganID = "0";
                strRemark = "";
                strSort = "0";
                strState = "0";
            }

            if (strGroupID== "0")  //如果为独立权限，读取权限表，如果为多角色权限则从角色中读取权限
            {
                DataSet myDsAuthorization = BusAuthorization.GetAuthorizationList(nAdminUser);

                if (!Object.Equals(myDsAuthorization, null))
                {
                    for (int i = 0; i < myDsAuthorization.Tables[0].Rows.Count; i++)
                    {
                        DataRow UserRowAuthorization = myDsAuthorization.Tables[0].Rows[i];
                        Session["Right" + UserRowAuthorization["ColumnID"] + "r"] = UserRowAuthorization["CanRead"].ToString();
                        Session["Right" + UserRowAuthorization["ColumnID"] + "w"] = UserRowAuthorization["CanWrite"].ToString();
                        Session["Right" + UserRowAuthorization["ColumnID"] + "m"] = UserRowAuthorization["CanModify"].ToString();
                        Session["Right" + UserRowAuthorization["ColumnID"] + "d"] = UserRowAuthorization["CanDelete"].ToString();
                        Session["Right" + UserRowAuthorization["ColumnID"] + "c"] = UserRowAuthorization["CanCheck"].ToString();
                    }

                    myDsAuthorization.Dispose();
                }
            }
            else
            {
                string nGroupID = strGroupID.Trim();
                string[] sArray = nGroupID.Split(',');
               
                if (sArray.Length >= 0)
                {
                   
                    for (int k = 0; k < sArray.Length; k++)
                    {                   
                        nAdminUser.UserID = ComStringHelper.IntParse(sArray[k]);
                        DataSet myDsAuthorization= BusAuthorization.GetAuthorizationList(nAdminUser);

                        if (!Object.Equals(myDsAuthorization, null))
                        {
                            for (int i = 0; i < myDsAuthorization.Tables[0].Rows.Count; i++)
                            {
                                DataRow UserRowAuthorization = myDsAuthorization.Tables[0].Rows[i];
                                Session["Right" + UserRowAuthorization["ColumnID"] + "r"] = UserRowAuthorization["CanRead"].ToString();
                                Session["Right" + UserRowAuthorization["ColumnID"] + "w"] = UserRowAuthorization["CanWrite"].ToString();
                                Session["Right" + UserRowAuthorization["ColumnID"] + "m"] = UserRowAuthorization["CanModify"].ToString();
                                Session["Right" + UserRowAuthorization["ColumnID"] + "d"] = UserRowAuthorization["CanDelete"].ToString();
                                Session["Right" + UserRowAuthorization["ColumnID"] + "c"] = UserRowAuthorization["CanCheck"].ToString();
                            } 
                         myDsAuthorization.Dispose();
                        }

                    }

                    UserDisabled = "disabled";
                   
                }
            
            }

            DisplayData();
        }


        #region 绑定权限数据
        /// <summary>
        /// 绑定权限数据
        /// </summary>
        private void DisplayData()
        {
            objBuilder.Append("<table id='infoTable' width='100%' class='commonTable'>\n");
            objBuilder.Append("<tr> ");
            objBuilder.Append("<th style='width:100px;height:25px;'><label style='float:left;'>栏目</label><label style='float:right;'><input type='checkbox' name='AllPowers' id='AllPowers' value='checkbox' onClick='CheckAll()' " + UserDisabled + ">(全选)</label></th><th align='center'>读</th><th align='center'>写</th><th align='center'>改</th><th align='center'>删</th><th align='center'>审</th>");
            objBuilder.Append("</tr>\n");

            ListSubPower(0, 0, "");

            objBuilder.Append("</table>\n");
            objBuilder.Append("<input type='hidden' name='UserID' id='UserID' value='" + strUserID + "'>\n");
            objBuilder.Append("<input type='hidden' name='UserName' id='UserName' value='" + strUserName + "'>\n");
            objBuilder.Append("<input type='hidden' name='TrueName' id='TrueName' value='" + strTrueName + "'>\n");
            objBuilder.Append("<input type='hidden' name='Password'  id='Password'  value='" + strPassword + "'>\n");
            objBuilder.Append("<input type='hidden' name='OrganName' id='OrganName' value='" + strOrganName + "'>\n");
            objBuilder.Append("<input type='hidden' name='OrganID' id='OrganID' value='" + strOrganID + "'>\n");
            objBuilder.Append("<input type='hidden' name='GroupID' id='GroupID' value='" + strGroupID + "'>\n");
            objBuilder.Append("<input type='hidden' name='Remark' id='Remark'  value='" + strRemark + "'>\n");
            objBuilder.Append("<input type='hidden' name='Sort' id='Sort' value='" + strSort + "'>\n");
            objBuilder.Append("<input type='hidden' name='State' id='State' value='" + strState + "'>\n");

            lblPower.Text = objBuilder.ToString();
        }
        #endregion

        #region 列出授权栏目
        ///<summary>
        /// 罗列子栏目
        /// </summary>
        /// <param name="parentId">父ID值</param>
        /// <param name="layer">所在层</param>
        /// <param name="prefix">前置参数</param>
        private void ListSubPower(int parentId, int layer, string prefix)
        {
            DmColumn nDmColumn = new DmColumn();
            nDmColumn.ColumnParentID = ComStringHelper.IntParse(parentId);

            DataSet myDS = BusAuthorization.GetSubColumnPower(nDmColumn);

            if (!Object.Equals(myDS, null) && myDS.Tables[0].Rows.Count > 0)
            {

                DataTable myDT = myDS.Tables[0];
                int nNum = myDS.Tables[0].Rows.Count;

                if (nNum > 0)
                {
                    string CanRead = "";
                    string CanWrite = "";
                    string CanModify = "";
                    string CanDelete = "";
                    string CanCheck = "";
                    string columnId = "";

                    for (int i = 0; i < nNum; i++)
                    {
                        DataRow objItem = myDT.Rows[i];

                        columnId = objItem["columnId"].ToString();


                        //检查是否已经有权限		
                        //READ
                        if (Session["Right" + objItem["ColumnID"] + "r"] != null)
                        {
                            if (Session["Right" + objItem["ColumnID"] + "r"].ToString() == "True")
                            { CanRead = "checked"; }
                            else
                            { CanRead = ""; }
                        }
                        else
                        {
                            CanRead = "";
                        }
                        //WRITE
                        if (Session["Right" + objItem["ColumnID"] + "w"] != null)
                        {
                            if (Session["Right" + objItem["ColumnID"] + "w"].ToString() == "True")
                            { CanWrite = "checked"; }
                            else
                            { CanWrite = ""; }
                        }
                        else
                        {
                            CanWrite = "";
                        }
                        //MODIFY
                        if (Session["Right" + objItem["ColumnID"] + "m"] != null)
                        {
                            if (Session["Right" + objItem["ColumnID"] + "m"].ToString() == "True")
                            { CanModify = "checked"; }
                            else
                            { CanModify = ""; }
                        }
                        else
                        {
                            CanModify = "";
                        }

                        //DELETE
                        if (Session["Right" + objItem["ColumnID"] + "m"] != null)
                        {
                            if (Session["Right" + objItem["ColumnID"] + "d"].ToString() == "True")
                            { CanDelete = "checked"; }
                            else
                            { CanDelete = ""; }
                        }
                        else
                        {
                            CanDelete = "";
                        }
                        //CHECK
                        if (Session["Right" + objItem["ColumnID"] + "m"] != null)
                        {
                            if (Session["Right" + objItem["ColumnID"] + "c"].ToString() == "True")
                            { CanCheck = "checked"; }
                            else
                            { CanCheck = ""; }
                        }
                        else
                        {
                            CanCheck = "";
                        }
                        //检查是否有权限完毕

                        objBuilder.Append("\n<tr bgcolor='#FFFFFF' >\n<td>");
                        for (int j = 1; j <= layer; j++)
                            objBuilder.Append("&nbsp;&nbsp;&nbsp;");

                        objBuilder.Append("◇" + objItem["columnname"].ToString() + "</td>\n");

                        objBuilder.Append("<input type='hidden'  name='chkAll' id='" + columnId + "' value='*" + columnId + "'>\n");
                        objBuilder.Append("<td style='text-align:center' ><input type='checkbox'  name='chkAll' id='" + "r" + prefix + columnId + "'  value='" +
                            "r" + columnId + "' " + CanRead + "  onclick=\"handle('r" + prefix + columnId + "')\" " + UserDisabled + "></td>\n");
                        objBuilder.Append("<td style='text-align:center' ><input type='checkbox'  name='chkAll' id='" + "w" + prefix + columnId + "'  value='" +
                            "w" + columnId + "' " + CanWrite + "  onclick=\"handle('w" + prefix + columnId + "')\" " + UserDisabled + "></td>\n");
                        objBuilder.Append("<td style='text-align:center' ><input type='checkbox'  name='chkAll' id='" + "m" + prefix + columnId + "'  value='" +
                            "m" + columnId + "' " + CanModify + "  onclick=\"handle('m" + prefix + columnId + "')\" " + UserDisabled + "></td>\n");
                        objBuilder.Append("<td style='text-align:center' ><input type='checkbox'  name='chkAll' id='" + "d" + prefix + columnId + "'  value='" +
                            "d" + columnId + "' " + CanDelete + "  onclick=\"handle('d" + prefix + columnId + "')\" " + UserDisabled + "></td>\n");
                        objBuilder.Append("<td style='text-align:center' ><input type='checkbox'  name='chkAll' id='" + "c" + prefix + columnId + "'  value='" +
                            "c" + columnId + "' " + CanCheck + "  onclick=\"handle('c" + prefix + columnId + "')\"  " + UserDisabled + "></td>\n");
                        objBuilder.Append("</tr>\n\n");

                        Session["Right" + objItem["ColumnID"] + "r"] = "False";
                        Session["Right" + objItem["ColumnID"] + "w"] = "False";
                        Session["Right" + objItem["ColumnID"] + "m"] = "False";
                        Session["Right" + objItem["ColumnID"] + "d"] = "False";
                        Session["Right" + objItem["ColumnID"] + "c"] = "False";

                        int sub = layer + 1;
                        ListSubPower(int.Parse(columnId), sub, prefix + columnId + "_");
                    }
                }

                myDT.Dispose();
                myDS.Dispose();
            }
        }
        #endregion


    }
}