﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="logList.aspx.cs" Inherits="Czou2012.UI.Manager.AdminUser.logList" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title>日志管理</title>
    <link type="text/css" rel="stylesheet" href="../Styles/style.css" />
    <link type="text/css" rel="stylesheet" href="../Styles/pagination.css" />
    <link type="text/css" rel="stylesheet" href="../Styles/table.css" />
    <link rel="stylesheet" type="text/css" href="../Scripts/themes/default/easyui.css" />
    <link rel="stylesheet" type="text/css" href="../Scripts/themes/icon.css" />
    <link type="text/css" rel="stylesheet" href="../Scripts/Tips/tip-yellowsimple/tip-yellowsimple.css" />
    <script type="text/javascript" src="../Scripts/jquery.min.js"></script>
    <script type="text/javascript" src="../Scripts/jquery.form.js"></script>
    <script type="text/javascript" src="../Scripts/jquery.easyui.min.js"></script>
    <script type="text/javascript" src="../Scripts/jquery.validate.field.js"></script>
    <script type="text/javascript" src="../Scripts/jquery.fixedtableheader.min.js"></script>
    <script type="text/javascript">



        //Query查询事件--------------------------------------------------------------/
        function btnQuery() {
            document.forms[0].action = "logList.aspx?type=query&RowNumPerPage=<%=nRowNumPerPage%>";
            document.forms[0].submit();
        }

        //Forbid事件--------------------------------------------------------------/
        function btnForbid(param) {
            var ifSelected = "0";
            $("tbody input:checkbox").each(function (i) {
                if ($("tbody input:checkbox").eq(i).attr("checked") == true) {
                    ifSelected = "1";
                }
            });

            if (ifSelected == "1") {
                if (param == "1") {
                    var options = {
                        target: '#lblInfo',
                        method: 'post',

                        url: 'logList.aspx?type=forbid&RowNumPerPage=<%=nRowNumPerPage%>',
                        success: function (msg) {
                            if (msg == "1") {
                                $("#lblInfo").text("操作成功！");
                                window.location.href = "<%=nCurrentRequestUrl%>";
                            }
                            else
                                $("#lblInfo").text("操作有误，请检查！");
                            return false;
                        },
                        error: function () { $.messager.alert("操作提示", "请求异常！", "warning"); }
                    };
                }
                else {
                    var options = {
                        target: '#lblInfo',
                        method: 'post',

                        url: 'logList.aspx?type=unforbid&RowNumPerPage=<%=nRowNumPerPage%>',
                        success: function (msg) {
                            if (msg == "1") {
                                $("#lblInfo").text("操作成功！");
                                window.location.href = "<%=nCurrentRequestUrl%>";
                            }
                            else
                                $("#lblInfo").text("操作有误，请检查！");
                            return false;
                        },
                        error: function () { $.messager.alert("操作提示", "请求异常！", "warning"); }
                    };
                
                
                }
                $('#formmodify').ajaxSubmit(options);
            }
            else {
                $.messager.alert("操作提示", "您没有选择信息！", "warning");
            }
        }

        //delete按钮事件--------------------------------------------------------------/
        function btnDelete() {
            var ifSelected = "0";
            $("tbody input:checkbox").each(function (i) {
                if ($("tbody input:checkbox").eq(i).attr("checked") == true) {
                    ifSelected = "1";
                }
            });

            if (ifSelected == "1") {
                var options = {
                    //参数说明：
                    //1.用此方式提交时，form不能为runat="server"；
                    //2.必须在表单form中加method="post"，此参数中加的method:'post'不能提交含大量表单域的form；
                    //3.必须在cs文件中用Request["名称"]获取表单域的值，否则RequestString获取字符串长度有限制.
                    target: '#lblInfo',
                    method: 'post',
                    url: 'logList.aspx?type=delete&RowNumPerPage=<%=nRowNumPerPage%>',
                    success: function (msg) {
                        if (msg == "1") {
                            $("#lblInfo").text("删除成功！");
                            $.messager.alert('系统提示', '删除成功', 'question', function () {
                                window.location.href = "<%=nCurrentRequestUrl%>";
                            });
                        }
                        else
                            $("#lblInfo").text("删除有误，请检查！");
                        return false;
                    },
                    error: function () { $.messager.alert("操作提示", "请求异常！", "warning"); }

                };
                $('#formmodify').ajaxSubmit(options);
            }
            else {
                $.messager.alert("操作提示", "您没有选择信息！", "warning");
            }

        }

        //日志清空事件--------------------------------------------------------------/
        function btnAllDelete() {

            var options = {
                //参数说明：
                //1.用此方式提交时，form不能为runat="server"；
                //2.必须在表单form中加method="post"，此参数中加的method:'post'不能提交含大量表单域的form；
                //3.必须在cs文件中用Request["名称"]获取表单域的值，否则RequestString获取字符串长度有限制.
                target: '#lblInfo',
                method: 'post',
                url: 'logList.aspx?type=alldelete&RowNumPerPage=<%=nRowNumPerPage%>',
                success: function (msg) {
                    if (msg == "1") {
                        $("#lblInfo").text("日志清空成功！");
                        $.messager.alert('系统提示', '日志清空成功', 'question', function () {
                            window.location.href = "<%=nCurrentRequestUrl%>";
                        });
                    }
                    else
                        $("#lblInfo").text("日志清空成功，请检查！");
                    return false;
                },
                error: function () { $.messager.alert("操作提示", "请求异常！", "warning"); }

            };
            $('#formmodify').ajaxSubmit(options);

        }

        //reset复原按钮---------------------------------------------------------------------/
        function btnReset() {
            $("form").each(function () {
                this.reset(); //有效，其他无效
            });

            $('#btnForbid').linkbutton('disable');    // disable the button  
            $('#btnDelete').linkbutton('disable');    // disable the button  
            $('#btnAdd').linkbutton('<%=Czou2012.UI.Manager.CommonClass.OperatorRight.IsRightButton("enable","w")%>');    // enable the button  
            window.location.href = "<%=nCurrentRequestUrl%>";
            checkboxClick();

        }

        //checkbox全选事件--------------------------------------------------------------/
        function selectAll(o) {
            if (o.checked) {
                $("input:checkbox").attr("checked", true);

            } else {
                $("input:checkbox").attr("checked", false);
            }
            checkboxClick();
        }

        //checkbox点击事件--------------------------------------------------------------/
        function checkboxClick() {

            $("tbody input:checkbox").each(function (i) {

                if ($("tbody input:checkbox").eq(i).attr("checked") == true) {
                    $("tbody input:checkbox").eq(i).parent().parent().addClass("trSelected");
                } else {
                    $("tbody input:checkbox").eq(i).parent().parent().removeClass("trSelected");
                }
            });

        }

        //文本框改变事件--------------------------------------------------------------/
        function inputChange(obj, i) {
            var cc = "#check" + i;
           // $(obj).addClass("inputChange"); //改变选择对象的风格
            if ($(cc).attr('checked') == false) {
                $(cc).attr('checked', true);
            }
            else {
                $(cc).attr('checked', false);
            }
            checkboxClick()
        }

        //检查是否输入数字-----------------------------------------------------------/
        function inputNumber(obj) {
            var nNumTemp = obj.value;
            var msg = $.ValidateField.ValidateNumber(nNumTemp);
            if (msg != 'ok') {
                alert(msg);
                obj.value = "0";
            }
        }

        //页面属性 Start--------------------------------------------------------------/
        $(function () {
            $("#tableContent table>tbody>tr input:text").addClass("inputText");
            $("#tableContent table>tbody>tr select").addClass("inputText");

            //linkbutton失效实例,增加权限控制       
            $('#btnForbid').linkbutton('<%=Czou2012.UI.Manager.CommonClass.OperatorRight.IsRightButton("enable","m")%>');
            $('#btnUnForbid').linkbutton('<%=Czou2012.UI.Manager.CommonClass.OperatorRight.IsRightButton("enable","m")%>');
            $('#btnDelete').linkbutton('<%=Czou2012.UI.Manager.CommonClass.OperatorRight.IsRightButton("enable","d")%>');
            $('#btnAllDelete').linkbutton('<%=Czou2012.UI.Manager.CommonClass.OperatorRight.IsRightButton("enable","c")%>');
            $('#btnQuery').linkbutton('<%=Czou2012.UI.Manager.CommonClass.OperatorRight.IsRightButton("enable","r")%>');
            //$('#btnForbid').linkbutton({ text: "可以" });
            $("#logTable").fixedtableheader({headerrowsize:1});

        })
    
    </script>
</head>
<body>
<table width="100%" border="0px"><tr><td></td></tr></table>
    <div class="tableHeader">
        <span class="navImage">&nbsp;</span><asp:Label ID="lblNavigator" class="lblNavigator" runat="server"></asp:Label>
    </div>
    <form id="formmodify" method="post" class="form" style="width: 100%;">
    <div id="tableContent" style="height: 75%; overflow: auto; border: 0px solid #ccc">
        <table class="commonTable" id="logTable">
            <thead>
                <tr>
                    <th style="width: 15px; text-align: center;">
                        <input type="checkbox" id="allCheck" style="border: 0px;" onclick="selectAll(this)" />
                    </th>                  
                    <th style="width: 150px; text-align: left; border-left: 0px; border-right: 0px;">
                        日志标题
                    </th>
                    <th style="text-align: left; border-left: 0px; border-right: 0px;">
                        操作内容
                    </th>
                      <th style="width: 100px; text-align: left; border-left: 0px; border-right: 0px;">
                        操作人
                    </th>
                    <th style="width: 120px; border-left: 0px; border-right: 0px;">
                        操作时间
                    </th>
                    <th style="width: 40px; text-align: center; border-left: 0px; border-right: 0px;">
                        状态
                    </th>
                </tr>

            </thead>
            <tbody>
                <asp:Label ID="tbodyDiv" runat="server"></asp:Label>
                <asp:Repeater runat="server" ID="columnRepeater">
                    <ItemTemplate>
                        <tr style='cursor: pointer;' id='tr_<%#Container.ItemIndex%>'>
                            <td style="text-align: center; border-left: 0px; border-right: 0px;">
                                <input type="checkbox" value="1" id="<%#"check"+Container.ItemIndex %>" name="<%#"check"+Container.ItemIndex %>" onclick="checkboxClick();">
                            </td>                           
                            <td style="border-left: 0px; border-right: 0px;" onclick="inputChange(this,<%#Container.ItemIndex%>)">
                                <%# Eval("LogTitle")%>
                            </td>
                            <td style="border-left: 0px; border-right: 0px;" onclick="inputChange(this,<%#Container.ItemIndex%>)">
                                <%# Eval("LogInfo")%>
                            </td>
                             <td style="border-left: 0px; border-right: 0px;" onclick="inputChange(this,<%#Container.ItemIndex%>)">
                                <%# Eval("LogUserName")%><input type="hidden" value="<%# Eval("LogID")%>" name="<%#"LogID"+Container.ItemIndex %>">
                            </td>
                            <td style="border-left: 0px; border-right: 0px;" onclick="inputChange(this,<%#Container.ItemIndex%>)">
                                <%# Eval("LogAddTime").ToString()%>
                            </td>
                            <td style="border-left: 0px; border-right: 0px;" onclick="inputChange(this,<%#Container.ItemIndex%>)">
                                <%# Czou.Common.ComStringHelper.IntParse(Eval("state")) == 0 ? "正常" : "<font color=green>锁定</font>"%>
                            </td>
                        </tr>
                    </ItemTemplate>
                </asp:Repeater>
            </tbody>
        </table>
    </div>
    <table style="border: 0px; width: 100%;" cellpadding="0" cellspacing="0">
        <tr>
            <td style="height: 28px; background: #eee;">
                <div style="float: left;">
                    <asp:Label ID="LblPageNavigator" runat="server"></asp:Label>
                </div>
            </td>
            <td style="height: 28px; background: #eee;">
               <a id="btnForbid" class="easyui-linkbutton" href="javascript:btnForbid('1');" tabindex="12">锁定</a>
                &nbsp;&nbsp;&nbsp; <a id="btnUnForbid" class="easyui-linkbutton" href="javascript:btnForbid('0');" tabindex="12">解锁</a>
                &nbsp;&nbsp;&nbsp; <a id="btnDelete" class="easyui-linkbutton" href="#" tabindex="14" onclick='{ $.messager.confirm("操作提示", "删除的日志将不能恢复!您确定要继续吗？\n", function (data) {if (data) {btnDelete();}else {return false;}});}'>
                    选择删除</a> &nbsp;&nbsp;&nbsp; <a id="btnAllDelete" class="easyui-linkbutton" href="#" tabindex="14"
                        onclick='{ $.messager.confirm("操作提示", "全部清空日志将不能恢复!您确定要继续吗？\n", function (data) {if (data) {btnAllDelete();}else {return false;}});}'>
                    清空日志</a>
            </td>
        </tr>
        <tr>
            <td style="height: 28px;">
                <span id="lblInfo" style="line-height: 25px; color: #ff0000;" class="lblInfo"></span>
            </td>
        </tr>
    </table>
    <table class="pureTable" style="border: 1px solid #ccc; width: 100%;">
        <tr>           
            <td class="bgGray" style="width: 100px; text-align: center;">
                关键字:
            </td>
            <td style="width: 200px">
                <input type="text" id="txtKeywords" name="txtKeywords" class="inputAdd input100" style="width: 90%;" />
            </td>
             <td class="bgGray" style="width: 100px; text-align: center;">
                用户名:
            </td>
            <td style="width: 150px">
                <input type="text" id="txtUserName" name="txtUserName" class="inputAdd input100" style="width: 90%;" />
            </td>
            <td style="text-align: left; padding-left: 15px;">
                <a id="btnQuery" class="easyui-linkbutton" href="javascript:btnQuery();" tabindex="13">
                    查询</a>&nbsp;&nbsp;&nbsp;<a id="btnReset" class="easyui-linkbutton" href="javascript:btnReset();"
                        tabindex="15">复原</a>
            </td>
        </tr>
    </table>
    </form>
</body>
</html>
