﻿/*
Author by Czou.com
Data:2012-11
While retaining the copyright case can be modified
*/
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Text;
using System.Data;
using System.Data.SqlClient;

using Czou.Common;
using Czou.DataModel;
using Czou.Business.Column;
using Czou.Business.AdminUser;
using Czou.Business.CommonRule;

namespace Czou2012.UI.Manager.AdminUser
{
    public partial class logList : System.Web.UI.Page
    {
        protected int nColumnID = 0;                  //当前获得ColumnID
        protected string nColumnCode = "";            //当前获得ColumnCode
        protected int nCurrentPage = 1;               //当前页数
        protected int nRowNumPerPage = 0;             //每页显示行数
        protected int nInitRowNumPerPage = 15;        //初始每页显示行数
        protected string nCurrentUrl = "";            //当前页面的URL
        protected int nIndex = 0;                     //当前ItemIndex
        protected string nCurrentRequestUrl = "#";    //通过Request获取到的当前页面Url值

        protected void Page_Load(object sender, EventArgs e)
        {
           //超时判断
           CommonClass.SessionEntity.ValidSession();

            //获取前置信息
            nColumnID = ComStringHelper.QueryIntParse("ColumnID");
            nColumnCode = ComStringHelper.QueryStringParse("ColumnCode");

            if (nColumnCode != "")
            {
                nColumnID = BusColumnRule.GetColumnIDByColumnCode(nColumnCode);
            }

            //生成导航信息
            string nColumnCodeLayerName = "";           //由ColumnCode转换成LayerName
            nColumnCodeLayerName = BusColumnRule.GetParentColumnNameListByCode(nColumnCode);
            lblNavigator.Text = nColumnCodeLayerName;

            //获取当页信息
            nCurrentRequestUrl = Request.ServerVariables["Url"] + "?" + Request.ServerVariables["QUERY_STRING"];
            nCurrentPage = ComStringHelper.IntParse(Request.QueryString["CurrentPage"]);
            if (nCurrentPage == 0) { nCurrentPage = 1; }
            nRowNumPerPage = ComStringHelper.IntParse(Request.QueryString["RowNumPerPage"]);
            if (nRowNumPerPage == 0) { nRowNumPerPage = nInitRowNumPerPage; }
           

            //判断访问类型             

            string nType;
            if (Request.QueryString["type"] == null)
            { nType = ""; }
            else
            { nType = ComStringHelper.GetSafeString(Request.QueryString["type"].ToString()); }

            if (nType == "show" || nType == "")
            {
                //判断用户是否有此权限
                CommonClass.OperatorRight.IsCodeRight(nColumnID,"r");
                LogDisplay();
            }
            
            else if (nType == "query")
            {
                //判断用户是否有此权限
                CommonClass.OperatorRight.IsCodeRight(nColumnID,"r");
                LogQuery();
            }
            else if (nType == "forbid")
            {
                //判断用户是否有此权限
                CommonClass.OperatorRight.IsCodeRight(nColumnID,"m");
                LogForbid(1);
            }
            else if (nType == "unforbid")
            {
                //判断用户是否有此权限
                CommonClass.OperatorRight.IsCodeRight(nColumnID,"m");
                LogForbid(0);
            }
            else if (nType == "delete")
            {
                //判断用户是否有此权限
                CommonClass.OperatorRight.IsCodeRight(nColumnID,"d");
                LogDelete();
            }
            else if (nType == "alldelete")
            {
                //判断用户是否有此权限
                CommonClass.OperatorRight.IsCodeRight(nColumnID,"d");
                LogAllDelete();
            }
        }

        private void LogDisplay()
        {
            string nQueryString = "where 1=1 "; //查询字符串   
            int nTotalRowNum = 0;               //总记录数
            int nTotalPages = 0;                //总页数

            //设定分页栏中所需导航地址
            nCurrentUrl = "logList.aspx?ColumnCode=" + nColumnCode;
           // nQueryString = nQueryString + "and GroupOrUser=0";

            DataSet nDataSet = BusLogRule.GetLogList(nQueryString, nCurrentPage, nRowNumPerPage);
            if (nDataSet != null)
            {
                columnRepeater.DataSource = nDataSet.Tables[0];
                columnRepeater.DataBind();
                nTotalRowNum = ComStringHelper.IntParse(nDataSet.Tables[0].Rows[0]["TotalNum"].ToString());
                nTotalPages = ComStringHelper.IntParse(Math.Ceiling((double.Parse(nTotalRowNum.ToString())) / nRowNumPerPage).ToString());

                nDataSet.Dispose();
            }
            else
            {
                tbodyDiv.Text = "<tr><td colspan=6>暂无信息</td></tr>";

            }
            LblPageNavigator.Text = ComPageHelper.PaginationImage(nCurrentUrl, nCurrentPage, nTotalPages, nRowNumPerPage, nTotalRowNum, 1);
        }



        private void LogQuery()
        {
            string nQueryString = "where 1=1 "; //查询字符串   
            int nTotalRowNum = 0;               //总记录数
            int nTotalPages = 0;                //总页数

          
            string nLogUserName = ComStringHelper.StringParse(Request["txtUserName"]);
            string nKeywords= ComStringHelper.StringParse(Request["txtKeywords"]);


            //设定分页栏中所需导航地址
            nCurrentUrl = "logList.aspx?type=query&ColumnCode=" + nColumnCode + "&txtUserName=" + nLogUserName + "&txtKeywords=" + nKeywords;
            nQueryString = nQueryString + " and LogUserName like '%" + nLogUserName + "%'";
            nQueryString = nQueryString + " and (LogTitle like '%" + nKeywords + "%'";
            nQueryString = nQueryString + " or LogInfo like '%" + nKeywords + "%')";
          

            DataSet nDataSet = BusLogRule.GetLogList(nQueryString, nCurrentPage, nRowNumPerPage);
            if (nDataSet != null)
            {
                columnRepeater.DataSource = nDataSet.Tables[0];
                columnRepeater.DataBind();
                nTotalRowNum = ComStringHelper.IntParse(nDataSet.Tables[0].Rows[0]["TotalNum"].ToString());
                nTotalPages = ComStringHelper.IntParse(Math.Ceiling((double.Parse(nTotalRowNum.ToString())) / nRowNumPerPage).ToString());

                nDataSet.Dispose();
            }
            else
            {
                tbodyDiv.Text = "<tr><td colspan=6>暂无信息</td></tr>";

            }
            LblPageNavigator.Text = ComPageHelper.PaginationImage(nCurrentUrl, nCurrentPage, nTotalPages, nRowNumPerPage, nTotalRowNum, 1);
        }


        private void LogForbid(int nState)
        {
            int nReturnIntTemp = 1;
            int nReturnIntBll = 0;
            int nReturnInt = 1;
            for (int i = 0; i < nRowNumPerPage; i++)
            {
                if (Request["check" + i] != null)
                {
                    DmAdminLog nDmAdminLog = new DmAdminLog();
                    nDmAdminLog.LogID = ComStringHelper.IntParse(Request["LogID" + i]);
                    nDmAdminLog.State = nState;

                    //修改角色禁止/启用信息
                    nReturnIntBll = BusLogRule.LogForbid(nDmAdminLog);
                    if (nReturnIntBll == 1 && nReturnIntTemp==1)
                        nReturnIntTemp = 1;
                    else
                        nReturnIntTemp = 0;
                }
            }

            if (nReturnIntTemp != 1)
            { nReturnInt = 0; }
            //记录日志
            if (nState == 1)
            {
                BusEventLogRule.WriteEvent("日志管理", "日志锁定成功!");
            }
            else {
                BusEventLogRule.WriteEvent("日志管理", "日志解锁成功!");
            
            }
            Response.Write(nReturnInt.ToString());
            Response.End();
        }


        private void LogDelete()
        {
            int nReturnIntTemp = 0;
            int nReturnInt = 1;

            for (int i = 0; i < nRowNumPerPage; i++)
            {
                if (Request["check" + i] != null)
                {
                    DmAdminLog nDmAdminLog = new DmAdminLog();
                    nDmAdminLog.LogID = ComStringHelper.IntParse(Request["LogID" + i]);
                    //删除角色信息

                    try
                    {
                       nReturnIntTemp=BusLogRule.LogDelete(nDmAdminLog);
                    }
                    catch
                    {
                        nReturnIntTemp = 0;
                    }
                   
                }
            }
            if (nReturnIntTemp !=1)
            { nReturnInt = 0; }
            //记录日志
            BusEventLogRule.WriteEvent("删除日志", "批量删除成功!");

            Response.Write(nReturnInt.ToString());
            Response.End();

        }

        private void LogAllDelete()
        {
            int nReturnInt = 1;

            nReturnInt = BusLogRule.LogAllDelete();

            //记录日志
            BusEventLogRule.WriteEvent("删除日志", "日志全部清空成功!");

            Response.Write(nReturnInt.ToString());
            Response.End();

        }

    }
}