﻿/*
Author by Czou.com
Data:2012-11
While retaining the copyright case can be modified
*/
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Text;
using System.Data;
using System.Data.SqlClient;

using Czou.Common;
using Czou.DataModel;
using Czou.Business.Column;
using Czou.Business.AdminUser;

namespace Czou2012.UI.Manager.AdminUser
{
    public partial class roleList : System.Web.UI.Page
    {
        protected int nColumnID = 0;                  //当前获得ColumnID
        protected string nColumnCode = "";            //当前获得ColumnCode
        protected int nCurrentPage = 1;               //当前页数
        protected int nRowNumPerPage = 0;            //每页显示行数
        protected int nInitRowNumPerPage = 10;            //每页显示行数
        protected int nIndex = 0;                     //当前ItemIndex
        protected string nCurrentInitUrl = "";        //当前页面初始URL
        protected string nCurrentUrl = "";            //当前页面的URL
        protected string nCurrentRequestUrl = "#";    //通过Request获取到的当前页面Url值

        protected void Page_Load(object sender, EventArgs e)
        {
            //超时判断
            CommonClass.SessionEntity.ValidSession();

            //获取前置信息
            nColumnID = ComStringHelper.QueryIntParse("ColumnID");
            nColumnCode = ComStringHelper.QueryStringParse("ColumnCode");

            if (nColumnCode != "")
            {
                nColumnID = BusColumnRule.GetColumnIDByColumnCode(nColumnCode);
            }

            //获取当页信息
            nCurrentRequestUrl = Request.ServerVariables["Url"] + "?" + Request.ServerVariables["QUERY_STRING"];
            nCurrentInitUrl = "roleList.aspx?ColumnCode=" + nColumnCode;

            nCurrentPage = ComStringHelper.IntParse(Request.QueryString["CurrentPage"]);
            if (nCurrentPage == 0) { nCurrentPage = 1; }
            nRowNumPerPage = ComStringHelper.IntParse(Request.QueryString["RowNumPerPage"]);
            if (nRowNumPerPage == 0) { nRowNumPerPage = nInitRowNumPerPage; }

            //判断访问类型             

            string nType;
            if (Request.QueryString["type"] == null)
            { nType = ""; }
            else
            { nType = ComStringHelper.GetSafeString(Request.QueryString["type"].ToString()); }

            if (nType == "show" || nType == "")
            {
                //判断用户是否有此权限
                CommonClass.OperatorRight.IsCodeRight(nColumnID, "r");
                RoleDisplay();
            }
            else if (nType == "add")
            {
                //判断用户是否有此权限
                CommonClass.OperatorRight.IsCodeRight(nColumnID, "w");
                RoleAdd();
            }
            else if (nType == "modify")
            {
                //判断用户是否有此权限
                CommonClass.OperatorRight.IsCodeRight(nColumnID, "m");
                RoleModify();
            }
            else if (nType == "query")
            {
                //判断用户是否有此权限
                CommonClass.OperatorRight.IsCodeRight(nColumnID, "r");
                RoleQuery();
            }
            else if (nType == "forbid")
            {
                //判断用户是否有此权限
                CommonClass.OperatorRight.IsCodeRight(nColumnID, "m");
                RoleForbid();
            }
            else if (nType == "delete")
            {
                //判断用户是否有此权限
                CommonClass.OperatorRight.IsCodeRight(nColumnID, "d");
                RoleDelete();
            }
        }


        private void RoleDisplay()
        {
            string nQueryString = "where 1=1 "; //查询字符串   
            int nTotalRowNum = 0;               //总记录数
            int nTotalPages = 0;                //总页数

            //设定分页栏中所需导航地址
            nCurrentUrl = "roleList.aspx?ColumnCode=" + nColumnCode;
            nQueryString = nQueryString + "and GroupOrUser=0";

            DataSet nDataSet = BusRoleRule.GetRoleList(nQueryString, nCurrentPage, nRowNumPerPage);
            if (nDataSet != null)
            {
                columnRepeater.DataSource = nDataSet.Tables[0];
                columnRepeater.DataBind();
                nTotalRowNum = ComStringHelper.IntParse(nDataSet.Tables[0].Rows[0]["TotalNum"].ToString());
                nTotalPages = ComStringHelper.IntParse(Math.Ceiling((double.Parse(nTotalRowNum.ToString())) / nRowNumPerPage).ToString());

                nDataSet.Dispose();
            }
            else
            {
                tbodyDiv.Text = "<tr><td colspan=6>暂无信息</td></tr>";

            }
            LblPageNavigator.Text = ComPageHelper.PaginationImage(nCurrentUrl, nCurrentPage, nTotalPages, nRowNumPerPage, nTotalRowNum, 1);
        }



        private void RoleQuery()
        {
            string nQueryString = "where 1=1 "; //查询字符串   
            int nTotalRowNum = 0;               //总记录数
            int nTotalPages = 0;                //总页数

            DmAdminUser objAdminUser = new DmAdminUser();
            objAdminUser.UserName = ComStringHelper.StringParse(Request["txtUserName"]);
            objAdminUser.TrueName = ComStringHelper.StringParse(Request["txtTrueName"]);
            objAdminUser.OrganName = ComStringHelper.StringParse(Request["txtOrganName"]);
            objAdminUser.Remark = ComStringHelper.StringParse(Request["txtRemark"]);
            objAdminUser.Sort = ComStringHelper.IntParse(Request["txtSort"]);


            //设定分页栏中所需导航地址
            nCurrentUrl = "roleList.aspx?type=query&ColumnCode=" + nColumnCode + "&txtUserName=" + objAdminUser.UserName + "&txtTrueName=" + objAdminUser.TrueName + "&txtOrganName=" + objAdminUser.OrganName;
            nQueryString = nQueryString + " and GroupOrUser=0";
            nQueryString = nQueryString + " and UserName like '%" + objAdminUser.UserName + "%'";
            nQueryString = nQueryString + " and TrueName like '%" + objAdminUser.TrueName + "%'";
            nQueryString = nQueryString + " and OrganName like '%" + objAdminUser.OrganName + "%'";


            DataSet nDataSet = BusRoleRule.GetRoleList(nQueryString, nCurrentPage, nRowNumPerPage);
            if (nDataSet != null)
            {
                columnRepeater.DataSource = nDataSet.Tables[0];
                columnRepeater.DataBind();
                nTotalRowNum = ComStringHelper.IntParse(nDataSet.Tables[0].Rows[0]["TotalNum"].ToString());
                nTotalPages = ComStringHelper.IntParse(Math.Ceiling((double.Parse(nTotalRowNum.ToString())) / nRowNumPerPage).ToString());

                nDataSet.Dispose();
            }
            else
            {
                tbodyDiv.Text = "<tr><td colspan=6>暂无信息</td></tr>";

            }
            LblPageNavigator.Text = ComPageHelper.PaginationImage(nCurrentUrl, nCurrentPage, nTotalPages, nRowNumPerPage, nTotalRowNum, 1);
        }


        private void RoleAdd()
        {

            DmAdminUser objAdminUser = new DmAdminUser();
            objAdminUser.UserName = ComStringHelper.StringParse(Request["txtUserName"]);
            objAdminUser.TrueName = ComStringHelper.StringParse(Request["txtTrueName"]);
            objAdminUser.Password = ComStringHelper.RndCharsCode(15);
            objAdminUser.OrganName = ComStringHelper.StringParse(Request["txtOrganName"]);
            objAdminUser.OrganID = ComStringHelper.IntParse(Request["txtOrganID"]);
            objAdminUser.AddUser = ComStringHelper.StringParse(Session["UserNameSession"]);
            objAdminUser.Remark = ComStringHelper.StringParse(Request["txtRemark"]);
            objAdminUser.Sort = ComStringHelper.IntParse(Request["txtSort"]);
            objAdminUser.State = 1;

            int nReturnInt = BusRoleRule.RoleAdd(objAdminUser);

            Response.Write(nReturnInt.ToString());
            Response.End();
        }


        private void RoleModify()
        {

            DmAdminUser objAdminUser = new DmAdminUser();
            objAdminUser.UserID = ComStringHelper.IntParse(Request["txtUserID"]);
            objAdminUser.UserName = ComStringHelper.StringParse(Request["txtUserName"]);
            objAdminUser.TrueName = ComStringHelper.StringParse(Request["txtTrueName"]);
            objAdminUser.Password = ComStringHelper.StringParse(Request["txtPassword"]);
            objAdminUser.OrganName = ComStringHelper.StringParse(Request["txtOrganName"]);
            objAdminUser.OrganID = ComStringHelper.IntParse(Request["txtOrganID"]);
            objAdminUser.AddUser = ComStringHelper.StringParse(Session["UserNameSession"]);
            objAdminUser.Remark = ComStringHelper.StringParse(Request["txtRemark"]);
            objAdminUser.Sort = ComStringHelper.IntParse(Request["txtSort"]);

            //修改角色信息
            int nReturnInt = BusRoleRule.RoleModify(objAdminUser);

            Response.Write(nReturnInt.ToString());
            Response.End();

        }

        private void RoleForbid()
        {
            DmAdminUser objAdminUser = new DmAdminUser();
            objAdminUser.UserID = ComStringHelper.IntParse(Request["txtUserID"]);
            objAdminUser.TrueName = ComStringHelper.StringParse(Request["txtTrueName"]);
            objAdminUser.AddUser = ComStringHelper.StringParse(Session["UserNameSession"]);
            objAdminUser.State = ComStringHelper.IntParse(Request["txtState"]);

            if (objAdminUser.State == 0)
            { objAdminUser.State = 1; }
            else
            { objAdminUser.State = 0; }

            //修改角色禁止/启用信息
            int nReturnInt = BusRoleRule.RoleForbid(objAdminUser);
            Response.Write(nReturnInt.ToString());
            Response.End();
        }


        private void RoleDelete()
        {

            int nReturnInt = 0;

            DmAdminUser objAdminUser = new DmAdminUser();
            objAdminUser.UserID = ComStringHelper.IntParse(Request["txtUserID"]);
            objAdminUser.UserName = ComStringHelper.StringParse(Request["txtUserName"]);

            //删除角色信息
            nReturnInt = BusRoleRule.RoleDelete(objAdminUser);

            Response.Write(nReturnInt.ToString());
            Response.End();

        }


    }
}