﻿/*
Author by Czou.com
Data:2012-11
While retaining the copyright case can be modified
*/
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Text;
using System.Data;
using System.Data.SqlClient;

using Czou.Common;
using Czou.DataModel;
using Czou.Business.Column;
using Czou.Business.AdminUser;
using Czou.Business.Dictionary;
using Czou.Business.Customer;

namespace Czou2012.UI.Manager.Customer
{
    public partial class customerInput : System.Web.UI.Page
    {
        protected int nColumnID = 0;                  //当前获得ColumnID
        protected string nColumnCode = "";            //当前获得ColumnCode
        protected string nCustomerType = "";          //当前获得会员类型
        protected int nCurrentPage = 1;               //当前页数
        protected int nRowNumPerPage = 0;             //每页显示行数
        protected int nInitRowNumPerPage = 15;        //初始每页显示行数
        protected string nCurrentUrl = "";            //当前页面的URL
        protected int nIndex = 0;                     //当前ItemIndex
        protected string nCurrentRequestUrl = "#";    //通过Request获取到的当前页面Url值

        protected void Page_Load(object sender, EventArgs e)
        {
            //超时判断
            CommonClass.SessionEntity.ValidSession();

            //获取前置信息
            nColumnID = ComStringHelper.QueryIntParse("ColumnID");
            nColumnCode = ComStringHelper.QueryStringParse("ColumnCode");
            nCustomerType = ComStringHelper.QueryStringParse("CustomerType");
            //生成导航信息
            lblNavigator.Text = BusColumnRule.GetParentColumnNameListByCode(nColumnCode);

            if (!IsPostBack)
            {
                txtColumnCode.Value = nColumnCode;
            }

            //会员类型下拉框绑定
            BusDicRule.GetDicSelectByCode(txtCustomerType, "D1", nCustomerType);
           // txtOrgan.Value = BusUserRule.GetAdminUserFieldByOtherField("OrganName", "UserName", ComStringHelper.StringParse(Session["UserNameSession"]));

            //取最大会员编号值
            txtCustomerNumber.Value = BusCustomerRule.GetCustomerMaxNumber().ToString();
         
            //判断访问类型             

            string nType;
            if (Request.QueryString["type"] == null)
            { nType = ""; }
            else
            { nType = ComStringHelper.GetSafeString(Request.QueryString["type"].ToString()); }

            if (nType == "add")
            {
                //判断用户是否有此权限
                CommonClass.OperatorRight.IsCodeRight(nColumnID, "w");
                CustomerAdd();
            }
        }


        /// <summary>
        /// 新增用户
        /// </summary>
        /// <returns>void</returns>
        private void CustomerAdd()
        {
            int nReturnInt = 0;
            DmCustomer model = new DmCustomer();

            //tbCustomer表模型
            model.CustomerNumber = ComStringHelper.StringParse(Request["txtCustomerNumber"]);
            model.CustomerAccount = ComStringHelper.StringParse(Request["txtCustomerAccount"]);
            if (model.CustomerAccount.Length <= 0)
            {
                model.CustomerAccount = model.CustomerNumber;
            }
            if (ComStringHelper.StringParse(Request["txtPassword"]).Trim() != "")
            {
                model.Password = ComStringHelper.StringParse(Request["txtPassword"]);
            }
            else
            { model.Password = "0000"; }
            model.CustomerName = ComStringHelper.StringParse(Request["txtCustomerName"]);
            model.CustomerPhoto = ComStringHelper.StringParse(Request["txtCustomerPhoto"]);
            model.CustomerType = ComStringHelper.StringParse(Request["txtCustomerType"]);
            model.Organ = ComStringHelper.StringParse(Request["txtOrganClass"]);
            model.ScienceClass = ComStringHelper.StringParse(Request["txtScienceClass"]);
            model.TradeClass = ComStringHelper.StringParse(Request["txtTradeClass"]);
            model.UserGroup = ComStringHelper.StringParse(Request["txtUserGroup"]);
            //model.IfOnline = ComStringHelper.IntParse(Request["txtIfOnline"]);
            model.AccessSign = ComStringHelper.StringParse(Request["txtAccessSign"]);
            //model.LoginDateTime = ComStringHelper.StringParse(Request["txtLoginDateTime"]);
            //model.LoginTimes = ComStringHelper.IntParse(Request["txtLoginTimes"]);
            //model.Sort = ComStringHelper.IntParse(Request["txtSort"]);
            //model.State = ComStringHelper.IntParse(Request["txtState"]);
            //model.SysSign = ComStringHelper.IntParse(Request["txtSysSign"]);
            model.AddUser = ComStringHelper.StringParse(Session["UserNameSession"]);
          //  model.AddTime = ComStringHelper.DateTimeParse(Request["txtAddTime"]);
            model.Remark = ComStringHelper.StringParse(Request["txtRemark"]);

            //CustomerContent表模型
            model.PerSex = ComStringHelper.StringParse(Request["txtPerSex"]);
            model.PerBirthday = ComStringHelper.StringParse(Request["txtPerBirthday"]);
            model.PerIdentifyNumber = ComStringHelper.StringParse(Request["txtPerIdentifyNumber"]);
            model.PerNation = ComStringHelper.StringParse(Request["txtPerNation"]);
            model.PerPoliticalStatus = ComStringHelper.StringParse(Request["txtPerPoliticalStatus"]);
            model.PerRegister = ComStringHelper.StringParse(Request["txtPerRegister"]);
            model.PerRegisterNow = ComStringHelper.StringParse(Request["txtPerRegisterNow"]);
            model.PerMaritalStatus = ComStringHelper.StringParse(Request["txtPerMaritalStatus"]);
            model.PerUniversity = ComStringHelper.StringParse(Request["txtPerUniversity"]);
            model.PerSpecialty = ComStringHelper.StringParse(Request["txtPerSpecialty"]);
            model.PerEducation = ComStringHelper.StringParse(Request["txtPerEducation"]);
            model.PerDuty = ComStringHelper.StringParse(Request["txtPerDuty"]);
            model.PerProfessional = ComStringHelper.StringParse(Request["txtPerProfessional"]);
            model.PerMobile = ComStringHelper.StringParse(Request["txtPerMobile"]);
            model.PerTel = ComStringHelper.StringParse(Request["txtPerTel"]);
            model.PerEmail = ComStringHelper.StringParse(Request["txtPerEmail"]);
            model.PerIm = ComStringHelper.StringParse(Request["txtPerIm"]);
            model.PerCompany = ComStringHelper.StringParse(Request["txtPerCompany"]);
            model.ComEntity = ComStringHelper.StringParse(Request["txtComEntity"]);
            model.ComEntityDuty = ComStringHelper.StringParse(Request["txtComEntityDuty"]);
            model.ComEntityTel = ComStringHelper.StringParse(Request["txtComEntityTel"]);
            model.ComEntityEmail = ComStringHelper.StringParse(Request["txtComEntityEmail"]);
            model.ComRegisterDate = ComStringHelper.StringParse(Request["txtComRegisterDate"]);
            model.ComRegisterCapital = ComStringHelper.StringParse(Request["txtComRegisterCapital"]);
            model.ComPersons = ComStringHelper.StringParse(Request["txtComPersons"]);
            model.ComContact = ComStringHelper.StringParse(Request["txtComContact"]);
            model.ComContactDuty = ComStringHelper.StringParse(Request["txtComContactDuty"]);
            model.ComContactTel = ComStringHelper.StringParse(Request["txtComContactTel"]);
            model.ComContactEmail = ComStringHelper.StringParse(Request["txtComContactEmail"]);
            model.ComTel = ComStringHelper.StringParse(Request["txtComTel"]);
            model.ComFax = ComStringHelper.StringParse(Request["txtComFax"]);
            model.ComWeb = ComStringHelper.StringParse(Request["txtComWeb"]);
            model.ComType = ComStringHelper.StringParse(Request["txtComType"]);
            model.ComBussinessScope = ComStringHelper.StringParse(Request["txtComBussinessScope"]);
            model.District = ComStringHelper.StringParse(Request["txtDistrict"]);
            model.Address = ComStringHelper.StringParse(Request["txtAddress"]);
            model.Post = ComStringHelper.StringParse(Request["txtPost"]);
            model.Brief = ComStringHelper.StringParse(Request["txtBrief"]);

            try
            {
                nReturnInt = BusCustomerRule.CustomerAdd(model);
            }
            catch
            {
                nReturnInt = 0;
            }
            Response.Write(nReturnInt.ToString());
            Response.End();

        }



    }
}