﻿/*
Author by Czou.com
Data:2012-11
While retaining the copyright case can be modified
*/
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Data.SqlClient;

using Czou.Common;
using Czou.DataModel;
using Czou.Business.Column;
using Czou.Business.Customer;
using Czou.Business.Dictionary;
using Czou.Business.Community;

namespace Czou2012.UI.Manager.Customer
{
    public partial class customerItemShow : System.Web.UI.Page
    {
        protected int nColumnID = 0;                  //当前获得ColumnID
        protected string nColumnCode = "";            //当前获得ColumnCode
        protected string nColumnName = "";            //当前获得ColumnName
        protected int nCurrentPage = 1;               //当前页数
        protected int nRowNumPerPage = 0;             //每页显示行数
        protected int nInitRowNumPerPage = 15;        //初始每页显示行数
        protected string nCurrentUrl = "";            //当前页面的URL
        protected int nIndex = 0;                     //当前ItemIndex
        protected string nCurrentRequestUrl = "#";    //通过Request获取到的当前页面Url值

        protected string nCustomerType = "";    //通过Request获取到的当前页面Url值

        protected void Page_Load(object sender, EventArgs e)
        {
            //超时判断
             CommonClass.SessionEntity.ValidSession();

            //获取前置信息
            nColumnID = ComStringHelper.QueryIntParse("ColumnID");
            nColumnCode = ComStringHelper.QueryStringParse("ColumnCode");

            int nCustomerID = ComStringHelper.QueryIntParse("CustomerID");

            if (nColumnCode != "")
            {
                nColumnID = BusColumnRule.GetColumnIDByColumnCode(nColumnCode);
            }
            //生成导航信息
            string nColumnCodeLayerName = "";           //由ColumnCode转换成LayerName
            nColumnCodeLayerName = BusColumnRule.GetParentColumnNameListByCode(nColumnCode);
            nColumnName = BusColumnRule.GetColumnFieldByOtherField("ColumnName", "ColumnCode", nColumnCode);
            lblNavigator.Text = nColumnCodeLayerName;

            DmCustomer model = new DmCustomer();
            model.CustomerID = nCustomerID;

            model = BusCustomerRule.GetCustomerItem(model);
            nCustomerType = model.CustomerType;

            txtTitle.Text = model.CustomerName + "(" + model.CustomerNumber + ")的详细信息";
            txtCustomerNumber.Text = model.CustomerNumber;
            txtCustomerAccount.Text = model.CustomerAccount;
            //txtPassword.Text = model.Password;
            txtCustomerName.Text = model.CustomerName;
            txtCustomerPhoto.Text = model.CustomerPhoto;
            txtCustomerType.Text = BusDicRule.GetNameListByCodeList(model.CustomerType, "single", "1", "");
         
            txtTradeClass.Text = BusDicRule.GetNameListByCodeList(model.TradeClass, "multi", "1", "");

            //tbCumstomerContent表信息
            txtPerSex.Text = model.PerSex;
            txtPerBirthday.Text = model.PerBirthday;
            txtPerIdentifyNumber.Text = model.PerIdentifyNumber;
            txtPerNation.Text = model.PerNation;
            txtPerPoliticalStatus.Text = model.PerPoliticalStatus;
            txtPerRegister.Text = BusDicRule.GetNameListByCodeList(model.PerRegister, "single", "2", ">");
            txtPerRegisterNow.Text = BusDicRule.GetNameListByCodeList(model.PerRegisterNow, "single", "2", ">");
            txtPerMaritalStatus.Text = model.PerMaritalStatus;
            txtPerUniversity.Text = model.PerUniversity;
            txtPerSpecialty.Text = model.PerSpecialty;
            txtPerEducation.Text = model.PerEducation;
            txtPerDuty.Text = model.PerDuty;
         //   txtPerProfessional.Text = model.PerProfessional;
            txtPerMobile.Text = model.PerMobile;
            txtPerTel.Text = model.PerTel;
            txtPerEmail.Text = model.PerEmail;
            txtPerIm.Text = model.PerIm;
            txtPerCompany.Text = model.PerCompany;
  
            txtComEntity.Text = model.ComEntity+" "+model.ComEntityDuty;
            
            txtComEntityTel.Text = model.ComEntityTel;
            txtComEntityEmail.Text = model.ComEntityEmail;
            txtComRegisterDate.Text = model.ComRegisterDate;
            txtComRegisterCapital.Text = model.ComRegisterCapital;
            txtComPersons.Text = model.ComPersons;
            txtComContact.Text = model.ComContact + " " + model.ComContactDuty;
            txtComContactTel.Text = model.ComContactTel;
            txtComContactEmail.Text = model.ComContactEmail;
            txtComTel.Text = model.ComTel;
            txtComFax.Text = model.ComFax;
            txtComWeb.Text = model.ComWeb;
            txtComType.Text = model.ComType;
            txtComBussinessScope.Text = model.ComBussinessScope;
          
            txtAddress.Text = model.Address;
            txtPost.Text = model.Post;
            txtBrief.Text = model.Brief;



        }
    }
}