﻿/*
Author by Czou.com
Data:2012-11
While retaining the copyright case can be modified
*/
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Text;
using System.Data;
using System.Data.SqlClient;

using Czou.Common;
using Czou.DataModel;
using Czou.Business.Column;
using Czou.Business.Dictionary;
using Czou.Business.AdminUser;
using Czou.Business.Customer;
using Czou.Business.Community;

namespace Czou2012.UI.Manager.Customer
{
    public partial class customerModify : System.Web.UI.Page
    {
        protected int nColumnID = 0;                  //当前获得ColumnID
        protected string nColumnCode = "";            //当前获得ColumnCode
        protected string nCustomerType = "";          //当前获得会员类型
        protected int nCurrentPage = 1;               //当前页数
        protected int nRowNumPerPage = 0;             //每页显示行数
        protected int nInitRowNumPerPage = 15;        //初始每页显示行数
        protected string nCurrentUrl = "";            //当前页面的URL
        protected int nIndex = 0;                     //当前ItemIndex
        protected string nCurrentRequestUrl = "#";    //通过Request获取到的当前页面Url值

        protected void Page_Load(object sender, EventArgs e)
        {
            //超时判断
            CommonClass.SessionEntity.ValidSession();

            //获取前置信息
            nColumnID = ComStringHelper.QueryIntParse("ColumnID");
            nColumnCode = ComStringHelper.QueryStringParse("ColumnCode");
            nCustomerType = ComStringHelper.QueryStringParse("CustomerType");

            int nCustomerID = ComStringHelper.QueryIntParse("CustomerID");

            //生成导航信息
            lblNavigator.Text = BusColumnRule.GetParentColumnNameListByCode(nColumnCode);

            if (!IsPostBack)
            {
                txtColumnCode.Value = nColumnCode;
            }

            //会员类型下拉框绑定
            BusDicRule.GetDicSelectByCode(txtCustomerType, "D1", nCustomerType);
            //txtOrganName.Value = BusUserRule.GetAdminUserFieldByOtherField("OrganName", "UserName", ComStringHelper.StringParse(Session["UserNameSession"]));

            if (!IsPostBack)
            {
                CustomerDisplay(nCustomerID);
            }
            //判断访问类型             

            string nType;
            if (Request.QueryString["type"] == null)
            { nType = ""; }
            else
            { nType = ComStringHelper.GetSafeString(Request.QueryString["type"].ToString()); }

            if (nType == "modify")
            {
                //判断用户是否有此权限
                CommonClass.OperatorRight.IsCodeRight(nColumnID, "m");
                CustomerModify();
            }
        }

        /// <summary>
        /// 显示用户
        /// </summary>
        /// <returns>void</returns>
        private void CustomerDisplay(int nCustomerID)
        {
            DmCustomer model = new DmCustomer();
            model.CustomerID = nCustomerID;
            model = BusCustomerRule.GetCustomerItem(model);
            txtCustomerID.Value = model.CustomerID.ToString();
            txtCustomerNumber.Value = model.CustomerNumber.ToString();
            txtCustomerAccount.Value = model.CustomerAccount.ToString();
           // txtPassword.Value = model.Password.ToString();
            txtCustomerName.Value = model.CustomerName.ToString();
            txtCustomerPhoto.Value = model.CustomerPhoto.ToString();
            txtState.Value = model.State.ToString();        
            txtCustomerType.Items.FindByValue(model.CustomerType.ToString()).Selected=true;
            txtOrganClass.Value = model.Organ.ToString();
         
            txtTradeClass.Value = model.TradeClass.ToString();
            txtTradeClassName.Value = BusDicRule.GetNameListByCodeList(model.TradeClass, "multi", "1", "");
         
            //tbCustomerContent表模型
            var nSex = model.PerSex.ToString();
            if (ComStringHelper.CompareString(txtPerSex1.Value, nSex)) { txtPerSex1.Checked = true; }
            if (ComStringHelper.CompareString(txtPerSex2.Value, nSex)) { txtPerSex2.Checked = true; }
            if (ComStringHelper.CompareString(txtPerSex3.Value, nSex)) { txtPerSex3.Checked = true; }
            txtPerBirthday.Value = model.PerBirthday.ToString();
            txtPerIdentifyNumber.Value = model.PerIdentifyNumber.ToString();
            txtPerNation.Value = model.PerNation.ToString();
            txtPerPoliticalStatus.Value = model.PerPoliticalStatus.ToString();
            txtPerRegister.Value = model.PerRegister.ToString();
            txtPerRegisterName.Value = BusDicRule.GetNameListByCodeList(model.PerRegister, "single", "2", ">");
            txtPerRegisterNow.Value = model.PerRegisterNow.ToString();
            txtPerRegisterNowName.Value = BusDicRule.GetNameListByCodeList(model.PerRegisterNow, "single", "2", ">");
            txtPerMaritalStatus.Value = model.PerMaritalStatus.ToString();
            txtPerUniversity.Value = model.PerUniversity.ToString();
            txtPerSpecialty.Value = model.PerSpecialty.ToString();
            txtPerEducation.Value = model.PerEducation.ToString();
            txtPerDuty.Value = model.PerDuty.ToString();
           // txtPerProfessional.Value = model.PerProfessional.ToString();
            txtPerMobile.Value = model.PerMobile.ToString();
            txtPerTel.Value = model.PerTel.ToString();
            txtPerEmail.Value = model.PerEmail.ToString();
            txtPerIm.Value = model.PerIm.ToString();
            txtPerCompany.Value = model.PerCompany.ToString();
            txtComEntity.Value = model.ComEntity.ToString();
            txtComEntityDuty.Value = model.ComEntityDuty.ToString();
            txtComEntityTel.Value = model.ComEntityTel.ToString();
            txtComEntityEmail.Value = model.ComEntityEmail.ToString();
            txtComRegisterDate.Value = model.ComRegisterDate.ToString();
            txtComRegisterCapital.Value = model.ComRegisterCapital.ToString();
            txtComPersons.Value = model.ComPersons.ToString();
            txtComContact.Value = model.ComContact.ToString();
            txtComContactDuty.Value = model.ComContactDuty.ToString();
            txtComContactTel.Value = model.ComContactTel.ToString();
            txtComContactEmail.Value = model.ComContactEmail.ToString();
            txtComTel.Value = model.ComTel.ToString();
            txtComFax.Value = model.ComFax.ToString();
            txtComWeb.Value = model.ComWeb.ToString();
            txtComType.Value = model.ComType.ToString();
            txtComBussinessScope.Value = model.ComBussinessScope.ToString();

            txtDistrict.Value = model.District.ToString();         
            txtAddress.Value = model.Address.ToString();
            txtPost.Value = model.Post.ToString();
            txtBrief.Value = model.Brief.ToString();
        }

        /// <summary>
        /// 修改用户
        /// </summary>
        /// <returns>void</returns>
        private void CustomerModify()
        {
            int nReturnInt = 0;
            DmCustomer model = new DmCustomer();

            //tbCustomer表模型
            model.CustomerID = ComStringHelper.IntParse(Request["txtCustomerID"]);
            model.CustomerNumber = ComStringHelper.StringParse(Request["txtCustomerNumber"]);
            model.CustomerAccount = ComStringHelper.StringParse(Request["txtCustomerAccount"]);
            if (model.CustomerAccount.Length <= 0)
            {
                model.CustomerAccount = model.CustomerNumber;
            }
            model.Password = ComStringHelper.StringParse(Request["txtPassword"]);
            model.CustomerName = ComStringHelper.StringParse(Request["txtCustomerName"]);
            model.CustomerPhoto = ComStringHelper.StringParse(Request["txtCustomerPhoto"]);
            model.CustomerType = ComStringHelper.StringParse(Request["txtCustomerType"]);
            model.Organ = ComStringHelper.StringParse(Request["txtOrganClass"]);
            model.ScienceClass = ComStringHelper.StringParse(Request["txtScienceClass"]);
            model.TradeClass = ComStringHelper.StringParse(Request["txtTradeClass"]);
            model.UserGroup = ComStringHelper.StringParse(Request["txtUserGroup"]);
            //model.IfOnline = ComStringHelper.IntParse(Request["txtIfOnline"]);
            model.AccessSign = ComStringHelper.StringParse(Request["txtAccessSign"]);
            //model.LoginDateTime = ComStringHelper.StringParse(Request["txtLoginDateTime"]);
            //model.LoginTimes = ComStringHelper.IntParse(Request["txtLoginTimes"]);
            //model.Sort = ComStringHelper.IntParse(Request["txtSort"]);
            model.State = ComStringHelper.IntParse(Request["txtState"]);
            //model.SysSign = ComStringHelper.IntParse(Request["txtSysSign"]);
            model.AddUser = ComStringHelper.StringParse(Session["UserNameSession"]);
            //model.AddTime = ComStringHelper.StringParse(Request["txtAddTime"]);
            model.Remark = ComStringHelper.StringParse(Request["txtRemark"]);

            //CustomerContent表模型
            model.PerSex = ComStringHelper.StringParse(Request["txtPerSex"]);
            model.PerBirthday = ComStringHelper.StringParse(Request["txtPerBirthday"]);
            model.PerIdentifyNumber = ComStringHelper.StringParse(Request["txtPerIdentifyNumber"]);
            model.PerNation = ComStringHelper.StringParse(Request["txtPerNation"]);
            model.PerPoliticalStatus = ComStringHelper.StringParse(Request["txtPerPoliticalStatus"]);
            model.PerRegister = ComStringHelper.StringParse(Request["txtPerRegister"]);
            model.PerRegisterNow = ComStringHelper.StringParse(Request["txtPerRegisterNow"]);
            model.PerMaritalStatus = ComStringHelper.StringParse(Request["txtPerMaritalStatus"]);
            model.PerUniversity = ComStringHelper.StringParse(Request["txtPerUniversity"]);
            model.PerSpecialty = ComStringHelper.StringParse(Request["txtPerSpecialty"]);
            model.PerEducation = ComStringHelper.StringParse(Request["txtPerEducation"]);
            model.PerDuty = ComStringHelper.StringParse(Request["txtPerDuty"]);
            model.PerProfessional = ComStringHelper.StringParse(Request["txtPerProfessional"]);
            model.PerMobile = ComStringHelper.StringParse(Request["txtPerMobile"]);
            model.PerTel = ComStringHelper.StringParse(Request["txtPerTel"]);
            model.PerEmail = ComStringHelper.StringParse(Request["txtPerEmail"]);
            model.PerIm = ComStringHelper.StringParse(Request["txtPerIm"]);
            model.PerCompany = ComStringHelper.StringParse(Request["txtPerCompany"]);
            model.ComEntity = ComStringHelper.StringParse(Request["txtComEntity"]);
            model.ComEntityDuty = ComStringHelper.StringParse(Request["txtComEntityDuty"]);
            model.ComEntityTel = ComStringHelper.StringParse(Request["txtComEntityTel"]);
            model.ComEntityEmail = ComStringHelper.StringParse(Request["txtComEntityEmail"]);
            model.ComRegisterDate = ComStringHelper.StringParse(Request["txtComRegisterDate"]);
            model.ComRegisterCapital = ComStringHelper.StringParse(Request["txtComRegisterCapital"]);
            model.ComPersons = ComStringHelper.StringParse(Request["txtComPersons"]);
            model.ComContact = ComStringHelper.StringParse(Request["txtComContact"]);
            model.ComContactDuty = ComStringHelper.StringParse(Request["txtComContactDuty"]);
            model.ComContactTel = ComStringHelper.StringParse(Request["txtComContactTel"]);
            model.ComContactEmail = ComStringHelper.StringParse(Request["txtComContactEmail"]);
            model.ComTel = ComStringHelper.StringParse(Request["txtComTel"]);
            model.ComFax = ComStringHelper.StringParse(Request["txtComFax"]);
            model.ComWeb = ComStringHelper.StringParse(Request["txtComWeb"]);
            model.ComType = ComStringHelper.StringParse(Request["txtComType"]);
            model.ComBussinessScope = ComStringHelper.StringParse(Request["txtComBussinessScope"]);
            model.District = ComStringHelper.StringParse(Request["txtDistrict"]);
            model.Address = ComStringHelper.StringParse(Request["txtAddress"]);
            model.Post = ComStringHelper.StringParse(Request["txtPost"]);
            model.Brief = ComStringHelper.StringParse(Request["txtBrief"]);
            try
            {
                nReturnInt = BusCustomerRule.CustomerModify(model);
            }
            catch
            {
                nReturnInt = 0;
            }
            Response.Write(nReturnInt.ToString());
            Response.End();

        }

    }
}