﻿/*
Author by Czou.com
Data:2012-11
While retaining the copyright case can be modified
*/
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

using Czou.Common;
using Czou.DataModel;
using Czou.Business.Login;


namespace Czou2012.UI.Manager
{
    public partial class Default : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {
         
                //判断访问类型
                string type = Request.Form["type"];
                if (type == "login")
                    UserLogin();
                else if (type == "reg")
                { return ; }
            }

        }
        private void UserLogin()
        {
            string userName = Request.Form["userName"].ToString();
            string password = Request.Form["password"].ToString();

            string validateCode = Request.Form["validateCode"].ToString();
            string isRemember = Request.Form["isRemember"].ToString();

            if (isRemember == null || isRemember == "")
            {
                isRemember = "0";
            }

            if (!string.IsNullOrEmpty(userName) && !string.IsNullOrEmpty(password)  && !string.IsNullOrEmpty(isRemember))
            {

                int loginTimes;
                if (Request.Cookies["LoginTimesCookie"] != null)
                { loginTimes = ComStringHelper.IntParse(Request.Cookies["LoginTimesCookie"].Value.ToString()); }
                else
                { loginTimes = 0; }

                if (loginTimes >= 3)
                {
                    if (Session["_ValidateCode"] == null)
                    {
                        Response.Write("codeExpire");
                        Response.End();
                    }
                    string sessionCode = Session["_ValidateCode"].ToString();
                    if (sessionCode.ToLower() != validateCode.ToLower())
                    {
                        Response.Write("errorCode");
                        Response.End();
                    }
                }

                DmAdminUser TbUser = new DmAdminUser();
                TbUser.UserName = ComStringHelper.GetSafeString(userName);
                TbUser.Password = password;

                //登录有效性判断--------------------------------------------------------------------
                BusLoginRule nBusLoginRule = new BusLoginRule();
                string loginInfo = nBusLoginRule.LoginValidate(TbUser);

                //登录Cookie记录,查询数据库时开始计数               
                if (Request.Cookies["LoginTimesCookie"] == null)
                {
                  Response.Cookies["LoginTimesCookie"].Value = "1";
                  Response.Cookies["LoginTimesCookie"].Expires = DateTime.Now.AddDays(1);    //设置保存时间是1天
                }
                else
                {
                    loginTimes = ComStringHelper.IntParse(Request.Cookies["LoginTimesCookie"].Value.ToString());
                    loginTimes = loginTimes + 1;
                    Response.Cookies["LoginTimesCookie"].Value = loginTimes.ToString();
                    Response.Cookies["LoginTimesCookie"].Expires = DateTime.Now.AddDays(1);   //设置保存时间是1天                  
                }

                //返回登录状态信息
                if (loginInfo != "loginSuccess")
                {
                    Response.Write("loginError");
                    Response.End();
                }
                else
                {
                    //登录成功后记录登录用户名及登录状态
                    Response.Cookies["UserNameCookie"].Value = userName;
                    Response.Cookies["IsLoginCookie"].Value = "yes";

                    //登录成功后，登录次数归0
                    Response.Cookies["LoginTimesCookie"].Value = "0";

                    //检查是否记住用户名
                    if (isRemember=="1")
                    {
                        Response.Cookies["IsRememberCheckCookie"].Value = "1";
                        Response.Cookies["UserNameCookie"].Expires = DateTime.Now.AddYears(1);
                    }
                    else
                    {
                        Response.Cookies["IsRememberCheckCookie"].Value = "0";
                    }

                    Response.Write("ok");
                    Response.End();
                }

               
            }
            else
            {

                Response.Write("loginUnknown");
                Response.End();
            }
        }


    }
}
