﻿/*
Author by Czou.com
Data:2012-11
While retaining the copyright case can be modified
*/
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Text;
using System.Data;
using System.Data.SqlClient;

using Czou.Common;
using Czou.DataModel;
using Czou.Business.Column;
using Czou.Business.Dictionary;

namespace Czou2012.UI.Manager.Dictionary
{
    public partial class dictionaryList : System.Web.UI.Page
    {
        protected int nColumnID = 0;                         //当前获得ColumnID
        protected string nColumnCode = "";                   //当前获得ColumnCode
        protected int nDicLayer = 0;                         //当前所在层级
        protected int nDicParentID = 0;                      //当前所在层级的父ID       
        protected int nDicGrandParentID = 0;                 //祖父ID，返回上一级用
        protected int nCurrentPage = 1;                      //当前页数
        protected int nRowNumPerPage = 0;                    //每页显示行数
        protected int nInitRowNumPerPage = 10;               //每页显示行数
        protected string nCurrentUrl = "";                   //当前页面的URL
        protected int nIndex = 0;                            //当前ItemIndex
        protected string nCurrentRequestUrl = "#";           //通过Request获取到的当前页面Url值

        protected void Page_Load(object sender, EventArgs e)
        {
            //超时判断
            CommonClass.SessionEntity.ValidSession();

            //获取前置信息
            nColumnID = ComStringHelper.QueryIntParse("ColumnID");
            nColumnCode = ComStringHelper.QueryStringParse("ColumnCode");

            if (nColumnCode != "")
            {
                nColumnID = BusColumnRule.GetColumnIDByColumnCode(nColumnCode);
            }

            //获取当前每页显示记录数
            nRowNumPerPage = ComStringHelper.IntParse(Request.QueryString["RowNumPerPage"]);
            if (nRowNumPerPage <= 0) { nRowNumPerPage = nInitRowNumPerPage; }

            //获取当前URL地址
            //HttpContext.Current.Response.Cookies["CurrentUrlCookie"].Value = Request.ServerVariables["Url"] + "?" + Request.ServerVariables["QUERY_STRING"];
            nCurrentRequestUrl = Request.ServerVariables["Url"] + "?" + Request.ServerVariables["QUERY_STRING"];

            //获取页数        
            nCurrentPage = ComStringHelper.IntParse(Request.QueryString["CurrentPage"]);
            if (nCurrentPage <= 0) { nCurrentPage = 1; }

            //获取当前所在层级
            nDicLayer = ComStringHelper.IntParse(Request.QueryString["DicLayer"]);
            if (nDicLayer <= 0) { nDicLayer = 0; }

            //获取当前父ID
            nDicParentID = ComStringHelper.IntParse(Request.QueryString["DicParentID"]);
            if (nDicParentID <= 0) { nDicParentID = 0; }

            //获取当前祖父ID
            nDicGrandParentID = ComStringHelper.IntParse(Request.QueryString["DicGrandParentID"]);
            if (nDicGrandParentID <= 0) { nDicGrandParentID = 0; }

            //设定分页栏中所需导航地址
            nCurrentUrl = "dictionaryList.aspx?DicLayer=" + nDicLayer + "&DicParentID=" + nDicParentID;

            if (!IsPostBack)
            {
                //判断访问类型     
                string nType;
                if (Request.QueryString["type"] == null)
                { nType = ""; }
                else
                { nType = ComStringHelper.GetSafeString(Request.QueryString["type"].ToString()); }

                if (nType == "sub" || nType == "")
                {
                    //判断用户是否有此权限
                    CommonClass.OperatorRight.IsCodeRight(nColumnID, "r");
                    DicDisplay();
                }
                else if (nType == "add")
                {
                    //判断用户是否有此权限
                    CommonClass.OperatorRight.IsCodeRight(nColumnID, "w");
                    DicAdd();
                }
                else if (nType == "modify")
                {
                    //判断用户是否有此权限
                    CommonClass.OperatorRight.IsCodeRight(nColumnID, "m");
                    DicModify();

                }
                else if (nType == "delete")
                {
                    //判断用户是否有此权限
                    CommonClass.OperatorRight.IsCodeRight(nColumnID, "d");
                    DicDelete();

                }
            }
        }

        /// <summary>
        /// 字典列表
        /// </summary>
        /// <returns>void</returns>
        private void DicDisplay()
        {
            string nQueryString = "where 1=1 "; //查询字符串   
            int nTotalRowNum = 0;               //总记录数
            int nTotalPages = 0;                //总页数    

            nQueryString = nQueryString + "and DicLayer=" + nDicLayer + " and DicParentID=" + nDicParentID;

            DataSet nDataSet = BusDicRule.GetDicList(nQueryString, nCurrentPage, nRowNumPerPage);
            if (nDataSet != null)
            {
                DicRepeater.DataSource = nDataSet.Tables[0];
                DicRepeater.DataBind();

                nTotalRowNum = ComStringHelper.IntParse(nDataSet.Tables[0].Rows[0]["TotalNum"].ToString());
                nTotalPages = ComStringHelper.IntParse(Math.Ceiling((double.Parse(nTotalRowNum.ToString())) / nRowNumPerPage).ToString());

                string tempStr = nDataSet.Tables[0].Rows[0]["DicGrandParentID"].ToString();
                if (tempStr == null || tempStr == "")
                {

                }
                else
                {
                    nDicGrandParentID = int.Parse(tempStr);
                }
                nDataSet.Dispose();
            }
            else
            {
                tbodyDiv.Text = "<tr><td colspan=11>暂无信息</td></tr>";

            }
            txtDicParentID.Value = nDicParentID.ToString();
            txtDicLayer.Value = nDicLayer.ToString();
            txtDicCode.Value = BusDicRule.GetCurrentAddCode(nDicParentID);
            lblNavigator.Text = BusDicRule.GetParentDicNameListByID(nDicParentID, 1, nDicLayer, "");
            LblPageNavigator.Text = ComPageHelper.PaginationImage(nCurrentUrl, nCurrentPage, nTotalPages, nRowNumPerPage, nTotalRowNum, 1);
        }



        //根据上一层id查出下一层内容
        protected void DicRepeater_ItemDataBound(object sender, RepeaterItemEventArgs e)
        {

            //判断里层repeater处于外层repeater的哪个位置
            if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem)
            {
                Repeater rep = e.Item.FindControl("SubRepeater") as Repeater;//找到里层的repeater对象    

                //找到分类Repeater关联的数据项 
                DataRowView rowv = (DataRowView)e.Item.DataItem;
                //提取分类ID 
                string strDicID = Convert.ToString(rowv["DicID"]);
                int nDicID = Convert.ToInt32(strDicID);
                string nQueryString = "where DicParentID=" + nDicID;

                DataSet nDataSetSub = BusDicRule.GetDicSubList(nQueryString);
                if (nDataSetSub != null)
                {
                    rep.DataSource = nDataSetSub.Tables[0];
                    rep.DataBind();
                    nDataSetSub.Dispose();
                }
            }

        }

        /// 是否选中
        /// </summary>
        /// <param name="nSourceValue">原值</param>
        /// <param name="nTargetValue">目标值</param>
        /// <returns>string</returns>
        protected string SelectedWrite(string nSourceValue, String nTargetValue)
        {
            if (nSourceValue == nTargetValue)
            {
                return "selected";
            }
            else
            { return ""; }

        }


        /// <summary>
        /// 新增字典
        /// </summary>
        /// <returns>void</returns>
        private void DicAdd()
        {

            DmDictionary model = new DmDictionary();
            model.DicParentID = ComStringHelper.IntParse(Server.UrlDecode(Request.QueryString["DicParentID"]));
            model.DicLayer = ComStringHelper.IntParse(Server.UrlDecode(Request.QueryString["DicLayer"]));
            model.DicName = ComStringHelper.GetSafeString(Server.UrlDecode(Request.QueryString["DicName"]));
            model.DicCode = ComStringHelper.GetSafeString(Server.UrlDecode(Request.QueryString["DicCode"]));
            model.AddUser = ComStringHelper.StringParse(Session["UserNameSession"]);
            string nTempStr = ComStringHelper.GetSafeString(Server.UrlDecode(Request.QueryString["DefaultValue"]));
            if (!ComStringHelper.CompareString(nTempStr, "")) { model.DefaultValue = nTempStr; }

            int nReturnInt = BusDicRule.DicAdd(model);

            Response.Write(nReturnInt.ToString());
            Response.End();

        }


        /// <summary>
        /// 修改字典
        /// </summary>
        /// <returns>void</returns>
        private void DicModify()
        {
            int nCurrentDicParentID, nLenClass;
            int nReturnInt = 1;


            for (int i = 0; i < nRowNumPerPage; i++)
            {
                if (Request["check" + i] != null)
                {
                    DmDictionary model = new DmDictionary();
                    model.DicID = ComStringHelper.IntParse(Request["DicID" + i].ToString());
                    model.DicName = ComStringHelper.StringParse(Request["DicName" + i]);
                    model.DicCode = ComStringHelper.StringParse(Request["DicCode" + i]);
                    nLenClass = model.DicCode.Length;
                    model.DicType = ComStringHelper.StringParse(Request["DicType" + i]);
                    model.DicParentID = ComStringHelper.IntParse(Request["DicParentID" + i].ToString());
                    nCurrentDicParentID = nDicParentID;
                    model.DicGroup = ComStringHelper.StringParse(Request["DicGroup" + i]);
                    model.DicParameter = ComStringHelper.StringParse(Request["DicParameter" + i]);
                    model.DefaultValue = ComStringHelper.StringParse(Request["DefaultValue" + i]);
                    model.DicSort = ComStringHelper.IntParse(Request["DicSort" + i]);

                    //修改字典信息
                    int nReturnIntTemp = BusDicRule.DicModifyBatch(model, nCurrentDicParentID);


                    if (nReturnIntTemp != 1 || nReturnInt != 1)
                    { nReturnInt = 0; }
                }

            }
            Response.Write(nReturnInt.ToString());
            Response.End();

        }


        /// <summary>
        /// 删除字典
        /// </summary>
        /// <returns>void</returns>
        private void DicDelete()
        {

            int nReturnInt = 1;

            for (int i = 0; i < nRowNumPerPage; i++)
            {
                if (Request["check" + i] != null)
                {
                    DmDictionary model = new DmDictionary();
                    model.DicID = ComStringHelper.IntParse(Request["DicID" + i].ToString());
                    //删除字典信息
                    int nReturnIntTemp = 0;

                    nReturnIntTemp = BusDicRule.DeleteSubDic(model.DicID, 0);
                    if (nReturnIntTemp != 1 || nReturnInt != 1)
                    { nReturnInt = 0; }
                }

            }
            Response.Write(nReturnInt.ToString());
            Response.End();

        }


        /// <summary>
        /// 比较字符串
        /// </summary>
        /// <param name="arg1">参数一</param>
        /// <param name="arg2">参数二</param>
        /// <returns>bool</returns>
        public bool CompareString(string arg1, string arg2)
        {
            if (arg1.ToUpper() == arg2.ToUpper())
            {
                return true;
            }
            else
            {
                return false;
            }
        }



    }
}