﻿/*
Author by Czou.com
Data:2012-11
While retaining the copyright case can be modified
*/
using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Text;
using System.Data;
using System.Data.SqlClient;

using Czou.Common;
using Czou.DataModel;
using Czou.Business.Column;
using Czou.Business.Dictionary;

namespace Czou2012.UI.Manager.Dictionary
{
    public partial class dictionarySelect : System.Web.UI.Page
    {
        protected int nDicID = 0;                         //当前获得DicID
        protected string nDicCode = "";                   //当前获得DicCode
        protected string nDicName = "";                   //当前获得DicName
        protected int nDicLayers = 0;                         //调用字典显示层级
        protected string nReturnObjID = "";                         //返回父窗口对象ID
        protected int nDicParentID = 0;                      //当前所在层级的父ID       
        protected int nDicGrandParentID = 0;                 //祖父ID，返回上一级用
        protected int nCurrentPage = 1;                      //当前页数
        protected int nRowNumPerPage = 0;                    //每页显示行数
        protected int nInitRowNumPerPage = 10;               //每页显示行数
        protected string nCurrentUrl = "";                   //当前页面的URL
        protected int nIndex = 0;                            //当前ItemIndex
        protected string nCurrentRequestUrl = "#";           //通过Request获取到的当前页面Url值

        protected void Page_Load(object sender, EventArgs e)
        {
            //超时判断
            // CommonClass.SessionEntity.ValidSession();

            //获取前置信息
            nDicID = ComStringHelper.QueryIntParse("DicID");
            nDicCode = ComStringHelper.QueryStringParse("DicCode");
            nDicLayers = ComStringHelper.QueryIntParse("DicLayers");
            nReturnObjID = ComStringHelper.QueryStringParse("ReturnObjID");

            if (nDicCode != "")
            {
                nDicID = BusDicRule.GetDicIDByDicCode(nDicCode);
            }
            nDicName = BusDicRule.GetDicFieldByOtherField("DicName", "DicCode", nDicCode);
            lblDicType.Text = nDicName;

            //判断访问类型             

            string nType;
            if (Request.QueryString["type"] == null)
            { nType = ""; }
            else
            { nType = ComStringHelper.GetSafeString(Request.QueryString["type"].ToString()); }

            if (nType == "")
            {
                DicDisplay();
            }
            else if (nType == "sublayer")
            {
                DicSubDisplay();
            }
        }


        private void DicDisplay()
        {
            string nQueryString = "where 1=1 "; //查询字符串 
            StringBuilder returnValue = new StringBuilder();  //定义返回字符串;

            nQueryString = nQueryString + " and DicParentID=" + nDicID;
            DataSet nDataSet = BusDicRule.GetDicSubList(nQueryString);

            if (!Object.Equals(nDataSet, null))
            {
                int nTotalRecord = nDataSet.Tables[0].Rows.Count;
                DataRow Row;
                if (nDicLayers == 1)
                {
                    returnValue.Append("\r\n<div class='screenList'>\r\n<dl class='screenItem'  style='border:0px' id='item1'>\r\n");
                    for (int i = 0; i < nTotalRecord; i++)
                    {
                        Row = nDataSet.Tables[0].Rows[i];
                        returnValue.Append("<dd>○<a href=\"#\" title=\"" + Row["DicName"] + "\" onclick=\"addSel(this,'" + Row["DicCode"] + "');\">" + Row["DicName"] + "</a></dd>\r\n");
                    }
                    returnValue.Append("</dl>\r\n</div>\r\n<div class='clear screenListUnderline'></div>\r\n");

                }

                if (nDicLayers == 2)
                {
                    returnValue.Append("\r\n<div class='screenList'>\r\n<dl class='screenItem screenSelect' style='border:0px' id='item0'>\r\n");
                    for (int i = 0; i < nTotalRecord; i++)
                    {
                        Row = nDataSet.Tables[0].Rows[i];
                        returnValue.Append("<dd>◇<a href=\"#\" title=\"" + Row["DicName"] + "\" onclick=\"subSel(this,'" + Row["DicCode"] + "','" + Row["DicName"] + "');\">" + Row["DicName"] + "</a></dd>\r\n");
                    }
                    returnValue.Append("</dl></div>\r\n<div class='clear screenListUnderline'></div><div class='screenList' style='clear:left;float:left'>\r\n");
                    returnValue.Append("<dl class='screenItem' id='item1'></dl>\r\n");
                    returnValue.Append("</div>\r\n<div class='clear screenListUnderline'></div>");
                }
            }
            LblContent.Text = returnValue.ToString();
            nDataSet.Dispose();
        }


        private void DicSubDisplay()
        {
            string nQueryString = "where 1=1 "; //查询字符串 
            StringBuilder returnValue = new StringBuilder();  //定义返回字符串;
            string nReturnStr = "";

            nQueryString = nQueryString + " and DicParentID=" + nDicID;
            DataSet nDataSet = BusDicRule.GetDicSubList(nQueryString);

            if (!Object.Equals(nDataSet, null))
            {
                int nTotalRecord = nDataSet.Tables[0].Rows.Count;
                DataRow Row;

                nDicName = BusDicRule.GetDicFieldByOtherField("DicName", "DicCode", nDicCode);
                for (int i = 0; i < nTotalRecord; i++)
                {
                    Row = nDataSet.Tables[0].Rows[i];
                    returnValue.Append("<dd>○<a href=\"#\" title=\"" + Row["DicName"] + "\" onclick=\"addSel(this,'" + Row["DicCode"] + "');\">" + Row["DicName"] + "</a></dd>\r\n");
                }
                nDataSet.Dispose();
            }
            returnValue.Append("<dd class='screenSubSelect'>◇<a href=\"#\" title=\"" + nDicCode + "\" onclick=\"addSel(this,'" + nDicCode + "');\">" + nDicName + "</a></dd>\r\n");
            returnValue.Append("<div class='clear'></div>\r\n");

            nReturnStr = returnValue.ToString();
            Response.Write(nReturnStr);
            Response.End();
        }


    }
}