﻿/*
Author by Czou.com
Data:2012-11
While retaining the copyright case can be modified
*/
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Data.SqlClient;

using Czou.Common;
using Czou.DataModel;
using Czou.Business.Column;
using Czou.Business.Info;

namespace Czou2012.UI.Manager.Info
{
    public partial class infoList : System.Web.UI.Page
    {

        protected int nColumnID = 0;                  //当前获得ColumnID
        protected string nColumnCode = "";            //当前获得ColumnCode
        protected int nCurrentPage = 1;               //当前页数
        protected int nRowNumPerPage = 0;             //每页显示行数
        protected int nInitRowNumPerPage = 15;        //初始每页显示行数
        protected string nCurrentUrl = "";            //当前页面的URL
        protected int nIndex = 0;                     //当前ItemIndex
        protected string nCurrentRequestUrl = "#";    //通过Request获取到的当前页面Url值

        protected void Page_Load(object sender, EventArgs e)
        {
            //超时判断
            CommonClass.SessionEntity.ValidSession();

            //获取前置信息
            nColumnID = ComStringHelper.QueryIntParse("ColumnID");
            nColumnCode = ComStringHelper.QueryStringParse("ColumnCode");

            if (nColumnCode != "")
            {
                nColumnID = BusColumnRule.GetColumnIDByColumnCode(nColumnCode);
            }
            //生成导航信息
            string nColumnCodeLayerName = "";           //由ColumnCode转换成LayerName
            nColumnCodeLayerName = BusColumnRule.GetParentColumnNameListByCode(nColumnCode);
            lblNavigator.Text = nColumnCodeLayerName;

            //获取当页信息
            nCurrentRequestUrl = Request.ServerVariables["Url"] + "?" + Request.ServerVariables["QUERY_STRING"];
            nCurrentPage = ComStringHelper.IntParse(Request.QueryString["CurrentPage"]);
            if (nCurrentPage == 0) { nCurrentPage = 1; }
            nRowNumPerPage = ComStringHelper.IntParse(Request.QueryString["RowNumPerPage"]);
            if (nRowNumPerPage == 0) { nRowNumPerPage = nInitRowNumPerPage; }
           

            //判断访问类型             

            string nType;
            if (Request.QueryString["type"] == null)
            { nType = ""; }
            else
            { nType = ComStringHelper.GetSafeString(Request.QueryString["type"].ToString()); }

            if (nType == "show" || nType == "")
            {
                //判断用户是否有此权限
                CommonClass.OperatorRight.IsCodeRight(nColumnID,"r");
                InfoDisplay();
            }
            
            else if (nType == "query")
            {
                //判断用户是否有此权限
                CommonClass.OperatorRight.IsCodeRight(nColumnID,"r");
                InfoQuery();
            }
            else if (nType == "modify")
            {
                //判断用户是否有此权限
                CommonClass.OperatorRight.IsCodeRight(nColumnID,"m");
                InfoModify();
            }
           
            else if (nType == "delete")
            {
                //判断用户是否有此权限
                CommonClass.OperatorRight.IsCodeRight(nColumnID,"d");
                InfoDelete();
            }
            
        }

        private void InfoDisplay()
        {
            string nQueryString = "where 1=1 "; //查询字符串   
            int nTotalRowNum = 0;               //总记录数
            int nTotalPages = 0;                //总页数

            //设定分页栏中所需导航地址
            nCurrentUrl = "infoList.aspx?ColumnCode=" + nColumnCode;
            nQueryString = nQueryString + " and ColumnCode='" + nColumnCode + "'";

            DataSet nDataSet = BusInfoRule.GetInfoList(nQueryString, nCurrentPage, nRowNumPerPage);
            if (nDataSet != null)
            {
                columnRepeater.DataSource = nDataSet.Tables[0];
                columnRepeater.DataBind();
                nTotalRowNum = ComStringHelper.IntParse(nDataSet.Tables[0].Rows[0]["TotalNum"].ToString());
                nTotalPages = ComStringHelper.IntParse(Math.Ceiling((double.Parse(nTotalRowNum.ToString())) / nRowNumPerPage).ToString());

                nDataSet.Dispose();
            }
            else
            {
                tbodyDiv.Text = "<tr><td colspan=10>暂无信息</td></tr>";

            }
            LblPageNavigator.Text = ComPageHelper.PaginationImage(nCurrentUrl, nCurrentPage, nTotalPages, nRowNumPerPage, nTotalRowNum, 1);
        }



        private void InfoQuery()
        {
            string nQueryString = "where 1=1 "; //查询字符串   
            int nTotalRowNum = 0;               //总记录数
            int nTotalPages = 0;                //总页数


            string nInputBy = ComStringHelper.StringParse(Request["txtInputBy"]);
            string nKeywords= ComStringHelper.StringParse(Request["txtKeywords"]);


            //设定分页栏中所需导航地址
            nCurrentUrl = "infoList.aspx?type=query&ColumnCode=" + nColumnCode + "&txtInputBy=" + nInputBy + "&txtKeywords=" + nKeywords;
            nQueryString = nQueryString + " and ColumnCode='" + nColumnCode + "'";
            nQueryString = nQueryString + " and InputBy like '%" + nInputBy + "%'";
            nQueryString = nQueryString + " and (Title like '%" + nKeywords + "%'";
            nQueryString = nQueryString + " or SubTitle like '%" + nKeywords + "%')";


            DataSet nDataSet = BusInfoRule.GetInfoList(nQueryString, nCurrentPage, nRowNumPerPage);
            if (nDataSet != null)
            {
                columnRepeater.DataSource = nDataSet.Tables[0];
                columnRepeater.DataBind();
                nTotalRowNum = ComStringHelper.IntParse(nDataSet.Tables[0].Rows[0]["TotalNum"].ToString());
                nTotalPages = ComStringHelper.IntParse(Math.Ceiling((double.Parse(nTotalRowNum.ToString())) / nRowNumPerPage).ToString());

                nDataSet.Dispose();
            }
            else
            {
                tbodyDiv.Text = "<tr><td colspan=10>暂无信息</td></tr>";

            }
            LblPageNavigator.Text = ComPageHelper.PaginationImage(nCurrentUrl, nCurrentPage, nTotalPages, nRowNumPerPage, nTotalRowNum, 1);
        }


       

        /// <summary>
        /// 修改信息
        /// </summary>
        /// <returns>void</returns>
        private void InfoModify()
        {
       
            int nReturnInt = 1;

            for (int i = 0; i < nRowNumPerPage; i++)
            {
                if (Request["check" + i] != null)
                {
                    DmInfo model = new DmInfo();
                    model.InfoID = ComStringHelper.IntParse(Request["InfoID" + i].ToString());
                    model.Title = ComStringHelper.StringParse(Request["Title" + i]);
                    model.CharacterCode = ComStringHelper.StringParse(Request["CharacterCode" + i]);
                    model.Clicks = ComStringHelper.IntParse(Request["Clicks" + i]);
                    model.InfoSort = ComStringHelper.IntParse(Request["InfoSort" + i]);
                    model.Commend = ComStringHelper.IntParse(Request["Commend" + i]);
                    model.State = ComStringHelper.IntParse(Request["State" + i]);

                    //修改栏目信息
                  int nReturnIntTemp = BusInfoRule.InfoModifyList(model);
                    if (nReturnIntTemp != 1 || nReturnInt != 1)
                    { nReturnInt = 0; }
                }

            }
            Response.Write(nReturnInt.ToString());
            Response.End();

        }

        /// <summary>
        /// 删除信息
        /// </summary>
        /// <returns>void</returns>
        private void InfoDelete()
        {
            int nReturnInt = 1;
            for (int i = 0; i < nRowNumPerPage; i++)
            {
                if (Request["check" + i] != null)
                {
                    DmInfo model = new DmInfo();
                    model.InfoID = ComStringHelper.IntParse(Request["InfoID" + i]);
                    model.Title = ComStringHelper.StringParse(Request["Title" + i]);
                    //删除栏目信息
                    int nReturnIntTemp = 0;

                    nReturnIntTemp = BusInfoRule.InfoDelete(model);

                    if (nReturnIntTemp != 1 || nReturnInt != 1)
                    { nReturnInt = 0; }
                }

            }
            Response.Write(nReturnInt.ToString());
            Response.End();

        }




    }
}