﻿/*
Author by Czou.com
Data:2012-11
While retaining the copyright case can be modified
*/
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

using Czou.Common;
using Czou.DataModel;
using Czou.Business.Column;
using Czou.Business.Info;

namespace Czou2012.UI.Manager.Info
{
    public partial class infoModify : System.Web.UI.Page
    {
        protected int nColumnID = 0;                  //当前获得ColumnID
        protected string nColumnCode = "";            //当前获得ColumnCode
        protected int nCurrentPage = 1;               //当前页数
        protected int nRowNumPerPage = 0;             //每页显示行数
        protected int nInitRowNumPerPage = 15;        //初始每页显示行数
        protected string nCurrentUrl = "";            //当前页面的URL
        protected int nIndex = 0;                     //当前ItemIndex
        protected string nCurrentRequestUrl = "#";    //通过Request获取到的当前页面Url值

        protected void Page_Load(object sender, EventArgs e)
        {
            //超时判断
            CommonClass.SessionEntity.ValidSession();

            //获取前置信息
            nColumnID = ComStringHelper.QueryIntParse("ColumnID");
            nColumnCode = ComStringHelper.QueryStringParse("ColumnCode");

            int nInfoID = ComStringHelper.QueryIntParse("InfoID");

            //生成导航信息
            string nColumnCodeLayerName = "";           //由ColumnCode转换成LayerName
            nColumnCodeLayerName = BusColumnRule.GetParentColumnNameListByCode(nColumnCode);
            lblNavigator.Text = nColumnCodeLayerName;

            if (!IsPostBack)
            {
                InfoDisplay(nInfoID);
            }

            //判断访问类型             

            string nType;
            if (Request.QueryString["type"] == null)
            { nType = ""; }
            else
            { nType = ComStringHelper.GetSafeString(Request.QueryString["type"].ToString()); }

            if (nType == "modify")
            {
                //判断用户是否有此权限
                CommonClass.OperatorRight.IsCodeRight(nColumnID, "w");
                InfoModify();
            }

        }

        /// <summary>
        /// 显示信息
        /// </summary>
        /// <returns>void</returns>
        private void InfoDisplay(int nInfoID)
        {
            DmInfo model = new DmInfo();
            model.InfoID = nInfoID;
            model =BusInfoRule.GetInfoItem(model);
            txtInfoID.Value = nInfoID.ToString();
            txtTitle.Value = model.Title.ToString();
            txtSubTitle.Value = model.SubTitle.ToString();
            txtKeywords.Value = model.Keywords.ToString();
            txtPublishTime.Value = model.PublishTime.ToString("yyyy-MM-dd HH:mm:ss");
            txtTitleColor.Value = model.TitleColor.ToString();
            txtSource.Value = model.Source.ToString();
            txtPictureSavePath.Value = model.PictureSavePath.ToString();
            txtIsPictureNews.Checked = model.IsPictureNews.ToString()=="1"?true:false;
            txtIsComment.Checked = model.IsComment.ToString().ToString() == "1" ? true : false;
            txtLanguage.Value = model.Language.ToString();
            txtInfoContent.Value = model.InfoContent.ToString();       
        
        
        }


        /// <summary>
        /// 新增信息
        /// </summary>
        /// <returns>void</returns>
        private void InfoModify()
        {
            int nReturnInt = 0;
            DmInfo model = new DmInfo();
            model.InfoID = ComStringHelper.IntParse(Request["txtInfoID"]);
            model.InfoRndCode = ComStringHelper.StringParse(Request["txtInfoRndCode"]);
            model.ColumnCode = ComStringHelper.StringParse(Request["txtColumnCode"]);
            model.Title = ComStringHelper.StringParse(Request["txtTitle"]);
            model.SubTitle = ComStringHelper.StringParse(Request["txtSubTitle"]);
            model.TitleColor = ComStringHelper.StringParse(Request["txtTitleColor"]);
            model.Keywords = ComStringHelper.StringParse(Request["txtKeywords"]);
            model.Summary = ComStringHelper.StringParse(Request["txtSummary"]);
            model.Source = ComStringHelper.StringParse(Request["txtSource"]);
            model.Author = ComStringHelper.StringParse(Request["txtAuthor"]);
            model.PictureName = ComStringHelper.StringParse(Request["txtPictureName"]);
            model.PictureSavePath = ComStringHelper.StringParse(Request["txtPictureSavePath"]);
            model.IsPictureNews = ComStringHelper.IntParse(Request["txtIsPictureNews"]);
            model.IsComment = ComStringHelper.IntParse(Request["txtIsComment"]);
            model.CharacterCode = ComStringHelper.StringParse(Request["txtCharacterCode"]);
            model.Commend = ComStringHelper.IntParse(Request["txtCommend"]);
            model.Language = ComStringHelper.StringParse(Request["txtLanguage"]);
            model.InfoSort = ComStringHelper.IntParse(Request["txtInfoSort"]);
            model.Clicks = ComStringHelper.IntParse(Request["txtClicks"]);
            model.RelationID = ComStringHelper.StringParse(Request["txtRelationID"]);
            model.RelationStr = ComStringHelper.StringParse(Request["txtRelationStr"]);
            model.InputBy = ComStringHelper.StringParse(Session["UserNameSession"]);
            //model.AddTime = ComStringHelper.StringParse(Request["txtAddTime"]);
            model.ModifyBy = ComStringHelper.StringParse(Session["UserNameSession"]);
            model.CheckBy = ComStringHelper.StringParse(Request["txtCheckBy"]);
            model.PublishTime = DateTime.Parse(ComStringHelper.StringParse(Request["txtPublishTime"]));
            model.HtmlUrl = ComStringHelper.StringParse(Request["txtHtmlUrl"]);
            model.IP = ComStringHelper.StringParse(Request["txtIP"]);
            model.State = ComStringHelper.IntParse(Request["txtState"]);
            model.SysSign = ComStringHelper.IntParse(Request["txtSysSign"]);
            model.InfoContent = ComStringHelper.StringParse(Request["txtInfoContent"]);
            try
            {
                nReturnInt = BusInfoRule.InfoModifySingle(model);
            }
            catch
            {
                nReturnInt = 0;
            }
            Response.Write(nReturnInt.ToString());
            Response.End();

        }


    }
}