/**
 * jQuery EasyUI 1.2.4
 * 
 * Licensed under the GPL terms
 * To use it on other terms please contact us
 *
 * Copyright(c) 2009-2011 stworthy [ stworthy@gmail.com ] 
 * 
 */
/**
 * draggable - jQuery EasyUI
 * 
 * Licensed under the GPL:
 *   http://www.gnu.org/licenses/gpl.txt
 * Copyright 2010 stworthy [ stworthy@gmail.com ] 
 */
(function($) {
	function drag(e) {
		var opts = $.data(e.data.target, 'draggable').options;
		var dragData = e.data;
		var left = dragData.startLeft + e.pageX - dragData.startX;
		var top = dragData.startTop + e.pageY - dragData.startY;
		if (opts.deltaX != null && opts.deltaX != undefined) {
			left = e.pageX + opts.deltaX;
		}
		if (opts.deltaY != null && opts.deltaY != undefined) {
			top = e.pageY + opts.deltaY;
		}
		if (e.data.parnet != document.body) {
			if ($.boxModel == true) {
				left += $(e.data.parent).scrollLeft();
				top += $(e.data.parent).scrollTop();
			}
		}
		if (opts.axis == 'h') {
			dragData.left = left;
		} else {
			if (opts.axis == 'v') {
				dragData.top = top;
			} else {
				dragData.left = left;
				dragData.top = top;
			}
		}
};

	function applyDrag(e) {
		var opts = $.data(e.data.target, 'draggable').options;
		var proxy = $.data(e.data.target, 'draggable').proxy;
		if (proxy) {
			proxy.css('cursor', opts.cursor);
		} else {
			proxy = $(e.data.target);
			$.data(e.data.target, 'draggable').handle.css('cursor', opts.cursor);
		}
		proxy.css({
					left : e.data.left,
					top : e.data.top
				});
	};
	function doDown(e) {
		var opts = $.data(e.data.target, 'draggable').options;
		var droppables = $('.droppable').filter(function() {
					return e.data.target != this;
				}).filter(function() {
					var accept = $.data(this, 'droppable').options.accept;
					if (accept) {
						return $(accept).filter(function() {
									return this == e.data.target;
								}).length > 0;
					} else {
						return true;
					}
				});
		$.data(e.data.target, 'draggable').droppables = droppables;
		var proxy = $.data(e.data.target, 'draggable').proxy;
		if (!proxy) {
			if (opts.proxy) {
				if (opts.proxy == 'clone') {
					proxy = $(e.data.target).clone().insertAfter(e.data.target);
				} else {
					proxy = opts.proxy.call(e.data.target, e.data.target);
				}
				$.data(e.data.target, 'draggable').proxy = proxy;
			} else {
				proxy = $(e.data.target);
			}
		}
		proxy.css('position', 'absolute');
		drag(e);
		applyDrag(e);
		opts.onStartDrag.call(e.data.target, e);
		return false;
	};
	function doMove(e) {
		drag(e);
		if ($.data(e.data.target, 'draggable').options.onDrag.call(
				e.data.target, e) != false) {
			applyDrag(e);
		}
		var source = e.data.target;
		$.data(e.data.target, 'draggable').droppables.each(function() {
			var dropObj = $(this);
			var p2 = $(this).offset();
			if (e.pageX > p2.left && e.pageX < p2.left + dropObj.outerWidth()
					&& e.pageY > p2.top && e.pageY < p2.top + dropObj.outerHeight()) {
				if (!this.entered) {
					$(this).trigger('_dragenter', [source]);
					this.entered = true;
				}
				$(this).trigger('_dragover', [source]);
			} else {
				if (this.entered) {
					$(this).trigger('_dragleave', [source]);
					this.entered = false;
				}
			}
		});
		return false;
	};
	function doUp(e) {
		drag(e);
		var proxy = $.data(e.data.target, 'draggable').proxy;
		var opts = $.data(e.data.target, 'draggable').options;
		if (opts.revert) {
			if (checkDrop() == true) {
				removeProxy();
				$(e.data.target).css({
							position : e.data.startPosition,
							left : e.data.startLeft,
							top : e.data.startTop
						});
			} else {
				if (proxy) {
					proxy.animate({
								left : e.data.startLeft,
								top : e.data.startTop
							}, function() {
								removeProxy();
							});
				} else {
					$(e.data.target).animate({
								left : e.data.startLeft,
								top : e.data.startTop
							}, function() {
								$(e.data.target).css('position',
										e.data.startPosition);
							});
				}
			}
		} else {
			$(e.data.target).css({
						position : 'absolute',
						left : e.data.left,
						top : e.data.top
					});
			removeProxy();
			checkDrop();
		}
		opts.onStopDrag.call(e.data.target, e);
		function removeProxy() {
			if (proxy) {
				proxy.remove();
			}
			$.data(e.data.target, 'draggable').proxy = null;
		};
		function checkDrop() {
			var dropped = false;
			$.data(e.data.target, 'draggable').droppables.each(function() {
						var dropObj = $(this);
						var p2 = $(this).offset();
						if (e.pageX > p2.left
								&& e.pageX < p2.left + dropObj.outerWidth()
								&& e.pageY > p2.top
								&& e.pageY < p2.top + dropObj.outerHeight()) {
							if (opts.revert) {
								$(e.data.target).css({
											position : e.data.startPosition,
											left : e.data.startLeft,
											top : e.data.startTop
										});
							}
							$(this).trigger('_drop', [e.data.target]);
							dropped = true;
							this.entered = false;
						}
					});
			return dropped;
		};
		$(document).unbind('.draggable');
		return false;
	};
	$.fn.draggable = function(options, param) {
		if (typeof options == 'string') {
			return $.fn.draggable.methods[options](this, param);
		}
		return this.each(function() {
					var opts;
					var state = $.data(this, 'draggable');
					if (state) {
						state.handle.unbind('.draggable');
						opts = $.extend(state.options, options);
					} else {
						opts = $.extend({}, $.fn.draggable.defaults, options || {});
					}
					if (opts.disabled == true) {
						$(this).css('cursor', 'default');
						return;
					}
					var handle = null;
					if (typeof opts.handle == 'undefined' || opts.handle == null) {
						handle = $(this);
					} else {
						handle = (typeof opts.handle == 'string' ? $(opts.handle,
								this) : handle);
					}
					$.data(this, 'draggable', {
								options : opts,
								handle : handle
							});
					handle.bind('mousedown.draggable', {
								target : this
							}, onMouseDown);
					handle.bind('mousemove.draggable', {
								target : this
							}, onMouseMove);
					function onMouseDown(e) {
						if (checkArea(e) == false) {
							return;
						}
						var position = $(e.data.target).position();
						var data = {
							startPosition : $(e.data.target).css('position'),
							startLeft : position.left,
							startTop : position.top,
							left : position.left,
							top : position.top,
							startX : e.pageX,
							startY : e.pageY,
							target : e.data.target,
							parent : $(e.data.target).parent()[0]
						};
						if(opts.onBeforeDrag.call(e.data.target,e)==false){
							return;
						}
						$(document).bind('mousedown.draggable', data, doDown);
						$(document).bind('mousemove.draggable', data, doMove);
						$(document).bind('mouseup.draggable', data, doUp);
					};
					function onMouseMove(e) {
						if (checkArea(e)) {
							$(this).css('cursor', opts.cursor);
						} else {
							$(this).css('cursor', 'default');
						}
					};
					function checkArea(e) {
						var offset = $(handle).offset();
						var width = $(handle).outerWidth();
						var height = $(handle).outerHeight();
						var t = e.pageY - offset.top;
						var r = offset.left + width - e.pageX;
						var b = offset.top + height - e.pageY;
						var l = e.pageX - offset.left;
						return Math.min(t, r, b, l) > opts.edge;
					};
				});
	};
	$.fn.draggable.methods = {
		options : function(jq) {
			return $.data(jq[0], 'draggable').options;
		},
		proxy : function(jq) {
			return $.data(jq[0], 'draggable').proxy;
		},
		enable : function(jq) {
			return jq.each(function() {
						$(this).draggable({
									disabled : false
								});
					});
		},
		disable : function(jq) {
			return jq.each(function() {
						$(this).draggable({
									disabled : true
								});
					});
		}
	};
	$.fn.draggable.defaults = {
		proxy : null,
		revert : false,
		cursor : 'move',
		deltaX : null,
		deltaY : null,
		handle : null,
		disabled : false,
		edge : 0,
		axis : null,
		onBeforeDrag:function(e){
		},
		onStartDrag : function(e) {
		},
		onDrag : function(e) {
		},
		onStopDrag : function(e) {
		}
	};
})(jQuery);

/**
 * droppable - jQuery EasyUI
 * 
 * Licensed under the GPL:
 *   http://www.gnu.org/licenses/gpl.txt
 *
 * Copyright 2010 stworthy [ stworthy@gmail.com ] 
 */
(function($) {
	function init(target) {
		$(target).addClass('droppable');
		$(target).bind('_dragenter', function(e, source) {
					$.data(target, 'droppable').options.onDragEnter.apply(target, [e,source]);
				});
		$(target).bind('_dragleave', function(e, source) {
					$.data(target, 'droppable').options.onDragLeave.apply(target, [e,source]);
				});
		$(target).bind('_dragover', function(e, source) {
					$.data(target, 'droppable').options.onDragOver.apply(target,[e, source]);
				});
		$(target).bind('_drop', function(e, source) {
					$.data(target, 'droppable').options.onDrop.apply(target, [e, source]);
				});
	};
	$.fn.droppable = function(options, param) {
		if (typeof options == 'string') {
			return $.fn.droppable.methods[options](this, param);
		}
		options = options || {};
		return this.each(function() {
					var state = $.data(this, 'droppable');
					if (state) {
						$.extend(state.options, options);
					} else {
						init(this);
						$.data(this, 'droppable', {
									options : $.extend({},
											$.fn.droppable.defaults, options)
								});
					}
				});
	};
	$.fn.droppable.methods = {};
	$.fn.droppable.defaults = {
		accept : null,
		onDragEnter : function(e, source) {
		},
		onDragOver : function(e, source) {
		},
		onDragLeave : function(e, source) {
		},
		onDrop : function(e, source) {
		}
	};
})(jQuery);

/**
 * resizable - jQuery EasyUI
 * 
 * Licensed under the GPL:
 *   http://www.gnu.org/licenses/gpl.txt
 *
 * Copyright 2010 stworthy [ stworthy@gmail.com ] 
 */
(function($) {
	$.fn.resizable = function(options, param) {
		if (typeof options == 'string') {
			return $.fn.resizable.methods[options](this, param);
		}
		function resize(e) {
			var resizeData = e.data;
			var options = $.data(resizeData.target, 'resizable').options;
			if (resizeData.dir.indexOf('e') != -1) {
				var width = resizeData.startWidth + e.pageX - resizeData.startX;
				width = Math.min(Math.max(width, options.minWidth), options.maxWidth);
				resizeData.width = width;
			}
			if (resizeData.dir.indexOf('s') != -1) {
				var height = resizeData.startHeight + e.pageY - resizeData.startY;
				height = Math.min(Math.max(height, options.minHeight), options.maxHeight);
				resizeData.height = height;
			}
			if (resizeData.dir.indexOf('w') != -1) {
				resizeData.width = resizeData.startWidth - e.pageX + resizeData.startX;
				if (resizeData.width >= options.minWidth && resizeData.width <= options.maxWidth) {
					resizeData.left = resizeData.startLeft + e.pageX - resizeData.startX;
				}
			}
			if (resizeData.dir.indexOf('n') != -1) {
				resizeData.height = resizeData.startHeight - e.pageY + resizeData.startY;
				if (resizeData.height >= options.minHeight && resizeData.height <= options.maxHeight) {
					resizeData.top = resizeData.startTop + e.pageY - resizeData.startY;
				}
			}
		};
		function applySize(e) {
			var resizeData = e.data;
			var target = resizeData.target;
			if ($.boxModel == true) {
				$(target).css({
							width : resizeData.width - resizeData.deltaWidth,
							height : resizeData.height - resizeData.deltaHeight,
							left : resizeData.left,
							top : resizeData.top
						});
			} else {
				$(target).css({
							width : resizeData.width,
							height : resizeData.height,
							left : resizeData.left,
							top : resizeData.top
						});
			}
		};
		function doDown(e) {
			$.data(e.data.target, 'resizable').options.onStartResize.call(
					e.data.target, e);
			return false;
		};
		function doMove(e) {
			resize(e);
			if ($.data(e.data.target, 'resizable').options.onResize.call(
					e.data.target, e) != false) {
				applySize(e);
			}
			return false;
		};
		function doUp(e) {
			resize(e, true);
			applySize(e);
			$.data(e.data.target, 'resizable').options.onStopResize.call(
					e.data.target, e);
			$(document).unbind('.resizable');
			$('body').css('cursor', 'default');
			return false;
		};
		return this.each(function() {
					var opts = null;
					var state = $.data(this, 'resizable');
					if (state) {
						$(this).unbind('.resizable');
						opts = $.extend(state.options, options || {});
					} else {
						opts = $.extend({}, $.fn.resizable.defaults, options || {});
						$.data(this, 'resizable', {
									options : opts
								});
					}
					if (opts.disabled == true) {
						return;
					}
					var target = this;
					$(this).bind('mousemove.resizable', onMouseMove).bind(
							'mousedown.resizable', onMouseDown).bind(
							'mouseleave.resizable',onMouseLeave);
					function onMouseMove(e) {
						var dir = getDirection(e);
						if (dir == '') {
							$(target).css('cursor', 'default');
						} else {
							$(target).css('cursor', dir + '-resize');
						}
					};
					function onMouseDown(e) {
						var dir = getDirection(e);
						if (dir == '') {
							return;
						}
						var data = {
							target : this,
							dir : dir,
							startLeft : getCssValue('left'),
							startTop : getCssValue('top'),
							left : getCssValue('left'),
							top : getCssValue('top'),
							startX : e.pageX,
							startY : e.pageY,
							startWidth : $(target).outerWidth(),
							startHeight : $(target).outerHeight(),
							width : $(target).outerWidth(),
							height : $(target).outerHeight(),
							deltaWidth : $(target).outerWidth() - $(target).width(),
							deltaHeight : $(target).outerHeight()
									- $(target).height()
						};
						$(document).bind('mousedown.resizable', data, doDown);
						$(document).bind('mousemove.resizable', data, doMove);
						$(document).bind('mouseup.resizable', data, doUp);
						$('body').css('cursor',dir+'-resize');
					};
					function onMouseLeave(e){
						$(target).css('cursor','default');
					}
					function getDirection(e) {
						var dir = '';
						var offset = $(target).offset();
						var width = $(target).outerWidth();
						var height = $(target).outerHeight();
						var edge = opts.edge;
						if (e.pageY > offset.top && e.pageY < offset.top + edge) {
							dir += 'n';
						} else {
							if (e.pageY < offset.top + height
									&& e.pageY > offset.top + height - edge) {
								dir += 's';
							}
						}
						if (e.pageX > offset.left && e.pageX < offset.left + edge) {
							dir += 'w';
						} else {
							if (e.pageX < offset.left + width
									&& e.pageX > offset.left + width - edge) {
								dir += 'e';
							}
						}
						var handles = opts.handles.split(',');
						for (var i = 0; i < handles.length; i++) {
							var handle = handles[i].replace(/(^\s*)|(\s*$)/g, '');
							if (handle == 'all' || handle == dir) {
								return dir;
							}
						}
						return '';
					};
					function getCssValue(css) {
						var val = parseInt($(target).css(css));
						if (isNaN(val)) {
							return 0;
						} else {
							return val;
						}
					};
				});
	};
	$.fn.resizable.methods = {};
	$.fn.resizable.defaults = {
		disabled : false,
		handles : 'n, e, s, w, ne, se, sw, nw, all',
		minWidth : 10,
		minHeight : 10,
		maxWidth : 10000,
		maxHeight : 10000,
		edge : 5,
		onStartResize : function(e) {
		},
		onResize : function(e) {
		},
		onStopResize : function(e) {
		}
	};
})(jQuery);

/**
 * linkbutton - jQuery EasyUI
 * 
 * Licensed under the GPL:
 *   http://www.gnu.org/licenses/gpl.txt
 *
 * Copyright 2010 stworthy [ stworthy@gmail.com ] 
 */
(function($) {
	function createButton(target) {
		var opts = $.data(target, 'linkbutton').options;
		$(target).empty();
		$(target).addClass('l-btn');
		if (opts.id) {
			$(target).attr('id', opts.id);
		} else {
			$.fn.removeProp ? $(target).removeProp('id') : $(target)
					.removeAttr('id');
		}
		if (opts.plain) {
			$(target).addClass('l-btn-plain');
		} else {
			$(target).removeClass('l-btn-plain');
		}
		if (opts.text) {
			$(target).html(opts.text).wrapInner('<span class="l-btn-left">'
					+ '<span class="l-btn-text">' + '</span>' + '</span>');
			if (opts.iconCls) {
				$(target).find('.l-btn-text').addClass(opts.iconCls).css(
						'padding-left', '20px');
			}
		} else {
			$(target).html('&nbsp;').wrapInner('<span class="l-btn-left">'
					+ '<span class="l-btn-text">'
					+ '<span class="l-btn-empty"></span>' + '</span>'
					+ '</span>');
			if (opts.iconCls) {
				$(target).find('.l-btn-empty').addClass(opts.iconCls);
			}
		}
		setDisabled(target, opts.disabled);
	};
	function setDisabled(target, disabled) {
		var state = $.data(target, 'linkbutton');
		if (disabled) {
			state.options.disabled = true;
			var href = $(target).attr('href');
			if (href) {
				state.href = href;
				$(target).attr('href', 'javascript:void(0)');
			}
			if(target.onclick){
				state.onclick = target.onclick;
				target.onclick = null;
			}
			$(target).addClass('l-btn-disabled');
		} else {
			state.options.disabled = false;
			if (state.href) {
				$(target).attr('href', state.href);
			}
			if (state.onclick) {
				target.onclick = state.onclick;
			}
			$(target).removeClass('l-btn-disabled');
		}
	};
	$.fn.linkbutton = function(options, param) {
		if (typeof options == 'string') {
			return $.fn.linkbutton.methods[options](this, param);
		}
		options = options || {};
		return this.each(function() {
					var state = $.data(this, 'linkbutton');
					if (state) {
						$.extend(state.options, options);
					} else {
						$.data(this, 'linkbutton', {
									options : $.extend({},
											$.fn.linkbutton.defaults,
											$.fn.linkbutton.parseOptions(this),
											options)
								});
						$(this).removeAttr('disabled');
					}
					createButton(this);
				});
	};
	$.fn.linkbutton.methods = {
		options : function(jq) {
			return $.data(jq[0], 'linkbutton').options;
		},
		enable : function(jq) {
			return jq.each(function() {
						setDisabled(this, false);
					});
		},
		disable : function(jq) {
			return jq.each(function() {
						setDisabled(this, true);
					});
		}
	};
	$.fn.linkbutton.parseOptions = function(target) {
		var t = $(target);
		return {
			id : t.attr('id'),
			disabled : (t.attr('disabled') ? true : undefined),
			plain : (t.attr('plain') ? t.attr('plain') == 'true' : undefined),
			text : $.trim(t.html()),
			iconCls : (t.attr('icon') || t.attr('iconCls'))
		};
	};
	$.fn.linkbutton.defaults = {
		id : null,
		disabled : false,
		plain : false,
		text : '',
		iconCls : null
	};
})(jQuery);

/**
 * pagination - jQuery EasyUI
 * 
 * Licensed under the GPL:
 *   http://www.gnu.org/licenses/gpl.txt
 *
 * Copyright 2010 stworthy [ stworthy@gmail.com ] 
 * 
 * Dependencies:
 * 	linkbutton
 * 
 */


/**
 * tree - jQuery EasyUI
 * 
 * Licensed under the GPL:
 *   http://www.gnu.org/licenses/gpl.txt
 *
 * Copyright 2010 stworthy [ stworthy@gmail.com ] 
 * 
 * Node is a javascript object which contains following properties:
 * 1 id: An identity value bind to the node.
 * 2 text: Text to be showed.
 * 3 checked: Indicate whether the node is checked selected.
 * 3 attributes: Custom attributes bind to the node.
 * 4 target: Target DOM object.
 */


/**
 * parser - jQuery EasyUI
 * 
 * Licensed under the GPL:
 *   http://www.gnu.org/licenses/gpl.txt
 *
 * Copyright 2010 stworthy [ stworthy@gmail.com ] 
 * 
 */
(function($){
	$.parser = {
		auto : true,
		onComplete : function(context) {
		},
		plugins : ['linkbutton', 'menu', 'menubutton', 'splitbutton',
				'progressbar', 'tree',
				'combobox', 'combotree', 'numberbox', 'validatebox', 'searchbox',
				'numberspinner', 'timespinner', 'calendar', 'datebox',
				'datetimebox', 'layout', 'panel',  'tabs',
				'accordion', 'window', 'dialog'],
		parse : function(context) {
			var aa = [];
			for (var i = 0; i < $.parser.plugins.length; i++) {
				var name = $.parser.plugins[i];
				var r = $('.easyui-' + name, context);
				if (r.length) {
					if (r[name]) {
						r[name]();
					} else {
						aa.push({
									name : name,
									jq : r
								});
					}
				}
			}
			if (aa.length && window.easyloader) {
				var names = [];
				for (var i = 0; i < aa.length; i++) {
					names.push(aa[i].name);
				}
				easyloader.load(names, function() {
							for (var i = 0; i < aa.length; i++) {
								var name = aa[i].name;
								var jq = aa[i].jq;
								jq[name]();
							}
							$.parser.onComplete.call($.parser, context);
						});
			} else {
				$.parser.onComplete.call($.parser, context);
			}
		}
	};
	$(function() {
				if (!window.easyloader && $.parser.auto) {
					$.parser.parse();
				}
			});
})(jQuery);

/**
 * progressbar - jQuery EasyUI
 * 
 * Licensed under the GPL:
 *   http://www.gnu.org/licenses/gpl.txt
 *
 * Copyright 2010 stworthy [ stworthy@gmail.com ]
 * 
 */

/**
 * panel - jQuery EasyUI
 * 
 * Licensed under the GPL:
 *   http://www.gnu.org/licenses/gpl.txt
 *
 * Copyright 2010 stworthy [ stworthy@gmail.com ] 
 * 
 */
(function($) {
	function removeNode(node) {
		node.each(function() {
					$(this).remove();
					if ($.browser.msie) {
						this.outerHTML = '';
					}
				});
	};
	function setSize(target, param) {

		var opts = $.data(target, 'panel').options;
		var panel = $.data(target, 'panel').panel;
		var pheader = panel.children('div.panel-header');
		var pbody = panel.children('div.panel-body');
		if (param) {
			if (param.width) {
				opts.width = param.width;
			}
			if (param.height) {
				opts.height = param.height;
			}
			if (param.left != null) {
				opts.left = param.left;
			}
			if (param.top != null) {
				opts.top = param.top;
			}
		}
		if (opts.fit == true) {
			var p = panel.parent();
			opts.width = p.width();
			opts.height = p.height();
		}
		panel.css({
					left : opts.left,
					top : opts.top
				});
		if (!isNaN(opts.width)) {
			if ($.boxModel == true) {
				panel.width(opts.width - (panel.outerWidth() - panel.width()));
			} else {
				panel.width(opts.width);
			}
		} else {
			panel.width('auto');
		}
		if ($.boxModel == true) {
			pheader.width(panel.width() - (pheader.outerWidth() - pheader.width()));
			pbody.width(panel.width() - (pbody.outerWidth() - pbody.width()));
		} else {
			pheader.width(panel.width());
			pbody.width(panel.width());
		}
		if (!isNaN(opts.height)) {
			if ($.boxModel == true) {
				panel.height(opts.height - (panel.outerHeight() - panel.height()));
				pbody.height(panel.height() - pheader.outerHeight()
						- (pbody.outerHeight() - pbody.height()));
			} else {
				panel.height(opts.height);
				pbody.height(panel.height() - pheader.outerHeight());
			}
		} else {
			pbody.height('auto');
		}
		panel.css('height', '');
		opts.onResize.apply(target, [opts.width, opts.height]);
		panel.find('>div.panel-body>div').triggerHandler('_resize');
	};
	function movePanel(target, param) {
		var opts = $.data(target, 'panel').options;
		var panel = $.data(target, 'panel').panel;
		if (param) {
			if (param.left != null) {
				opts.left = param.left;
			}
			if (param.top != null) {
				opts.top = param.top;
			}
		}
		panel.css({
					left : opts.left,
					top : opts.top
				});
		opts.onMove.apply(target, [opts.left, opts.top]);
	};
	function wrapPanel(target) {
		var panel = $(target).addClass('panel-body')
				.wrap('<div class="panel"></div>').parent();
		panel.bind('_resize', function() {
					var opts = $.data(target, 'panel').options;
					if (opts.fit == true) {
						setSize(target);
					}
					return false;
				});
		return panel;
	};
	function addHeader(target) {
		var opts = $.data(target, 'panel').options;
		var panel = $.data(target, 'panel').panel;
		removeNode(panel.find('>div.panel-header'));
		if (opts.title && !opts.noheader) {
			var header = $('<div class="panel-header"><div class="panel-title">'
					+ opts.title + '</div></div>').prependTo(panel);
            var tool = $('<div class="panel-tool"></div>').appendTo(header);
			if (opts.iconCls) {
				header.find('.panel-title').addClass('panel-with-icon');
				$('<div class="panel-icon"></div>').addClass(opts.iconCls)
						.appendTo(header);
			}
            else
            {
                header.addClass("panel-header-top");
                tool.eq(0).addClass("panel-tool-top");
             }
            //޸ඥ߶
		
			if (opts.closable) {
				$('<div class="panel-tool-close"></div>').appendTo(tool).bind(
						'click', onClose);
			}
			if (opts.maximizable) {
				$('<div class="panel-tool-max"></div>').appendTo(tool).bind(
						'click', onMax);
			}
			if (opts.minimizable) {
				$('<div class="panel-tool-min"></div>').appendTo(tool).bind(
						'click', onMin);
			}
			if (opts.collapsible) {
				$('<div class="panel-tool-collapse"></div>').appendTo(tool)
						.bind('click', onToggle);
			}
			if (opts.tools) {
				for (var i = opts.tools.length - 1; i >= 0; i--) {
					var t = $('<div></div>').addClass(opts.tools[i].iconCls)
							.appendTo(tool);
					if (opts.tools[i].handler) {
						t.bind('click', eval(opts.tools[i].handler));
					}
				}
			}
			tool.find('div').hover(function() {
						$(this).addClass('panel-tool-over');
					}, function() {
						$(this).removeClass('panel-tool-over');
					});
			panel.find('>div.panel-body').removeClass('panel-body-noheader');
		} else {
			panel.find('>div.panel-body').addClass('panel-body-noheader');
		}
		function onToggle() {
			if (opts.collapsed == true) {
				expandPanel(target, true);
			} else {
				collapsePanel(target, true);
			}
			return false;
		};
		function onMin() {
			minimizePanel(target);
			return false;
		};
		function onMax() {
			if (opts.maximized == true) {
				restorePanel(target);
			} else {
				maximizePanel(target);
			}
			return false;
		};
		function onClose() {
			closePanel(target);
			return false;
		};
	};
	function loadData(target) {

		var state = $.data(target, 'panel');
	    if (state.options.href && (!state.isLoaded || !state.options.cache)) {           
			state.isLoaded = false;
			var pbody = state.panel.find('>div.panel-body');
			if(state.options.loadingMessage){
     
				pbody.html($('<div class="panel-loading"></div>')
						.html(state.options.loadingMessage));
			}
			$.ajax({
						url : state.options.href,
						cache : false,
						success : function(data) {
							pbody.html(state.options.extractor.call(target,data));
							pbody.html(data);
							if ($.parser) {
								$.parser.parse(pbody);
							}
							state.options.onLoad.apply(target, arguments);
							state.isLoaded = true;
						}
					});
		}
	};
	function init(target) {
		$(target)
				.find('div.panel:visible,div.accordion:visible,div.tabs-container:visible,div.layout:visible')
				.each(function() {
							$(this).triggerHandler('_resize', [true]);
						});
	};
	function openPanel(target, forceOpen) {
		var opts = $.data(target, 'panel').options;
		var panel = $.data(target, 'panel').panel;
		if (forceOpen != true) {
			if (opts.onBeforeOpen.call(target) == false) {
				return;
			}
		}
		panel.show();
		opts.closed = false;
		opts.minimized = false;
		opts.onOpen.call(target);
		if (opts.maximized == true) {
			opts.maximized = false;
			maximizePanel(target);
		}
		if (opts.collapsed == true) {
			opts.collapsed = false;
			collapsePanel(target);
		}
		if (!opts.collapsed) {
			loadData(target);
			init(target);
		}
	};
	function closePanel(target, forceClose) {
		var opts = $.data(target, 'panel').options;
		var panel = $.data(target, 'panel').panel;
		if (forceClose != true) {
			if (opts.onBeforeClose.call(target) == false) {
				return;
			}
		}
		panel.hide();
		opts.closed = true;
		opts.onClose.call(target);
	};
	function destroyPanel(target, forceDestroy) {
		var opts = $.data(target, 'panel').options;
		var panel = $.data(target, 'panel').panel;
		if (forceDestroy != true) {
			if (opts.onBeforeDestroy.call(target) == false) {
				return;
			}
		}
		removeNode(panel);
		opts.onDestroy.call(target);
	};
	function collapsePanel(target, forceDestroy) {
		var opts = $.data(target, 'panel').options;
		var panel = $.data(target, 'panel').panel;
		var body = panel.children('div.panel-body');
		var tool = panel.children('div.panel-header')
				.find('div.panel-tool-collapse');
		if (opts.collapsed == true) {
			return;
		}
		body.stop(true, true);
		if (opts.onBeforeCollapse.call(target) == false) {
			return;
		}
		tool.addClass('panel-tool-expand');
		if (forceDestroy == true) {
			body.slideUp('normal', function() {
						opts.collapsed = true;
						opts.onCollapse.call(target);
					});
		} else {
			body.hide();
			opts.collapsed = true;
			opts.onCollapse.call(target);
		}
	};
	function expandPanel(target, animate) {
		var opts = $.data(target, 'panel').options;
		var panel = $.data(target, 'panel').panel;
		var body = panel.children('div.panel-body');
		var tool = panel.children('div.panel-header')
				.find('div.panel-tool-collapse');
		if (opts.collapsed == false) {
			return;
		}
		body.stop(true, true);
		if (opts.onBeforeExpand.call(target) == false) {
			return;
		}
		tool.removeClass('panel-tool-expand');
		if (animate == true) {
			body.slideDown('normal', function() {
						opts.collapsed = false;
						opts.onExpand.call(target);
						loadData(target);
						init(target);
					});
		} else {
			body.show();
			opts.collapsed = false;
			opts.onExpand.call(target);
			loadData(target);
			init(target);
		}
	};
	function maximizePanel(target) {
		var opts = $.data(target, 'panel').options;
		var panel = $.data(target, 'panel').panel;
		var tool = panel.children('div.panel-header').find('div.panel-tool-max');
		if (opts.maximized == true) {
			return;
		}
		tool.addClass('panel-tool-restore');
		$.data(target, 'panel').original = {
			width : opts.width,
			height : opts.height,
			left : opts.left,
			top : opts.top,
			fit : opts.fit
		};
		opts.left = 0;
		opts.top = 0;
		opts.fit = true;
		setSize(target);
		opts.minimized = false;
		opts.maximized = true;
		opts.onMaximize.call(target);
	};
	function minimizePanel(target) {
		var opts = $.data(target, 'panel').options;
		var panel = $.data(target, 'panel').panel;
		panel.hide();
		opts.minimized = true;
		opts.maximized = false;
		opts.onMinimize.call(target);
	};
	function restorePanel(target) {
		var opts = $.data(target, 'panel').options;
		var panel = $.data(target, 'panel').panel;
		var tool = panel.children('div.panel-header').find('div.panel-tool-max');
		if (opts.maximized == false) {
			return;
		}
		panel.show();
		tool.removeClass('panel-tool-restore');
		var original = $.data(target, 'panel').original;
		opts.width = original.width;
		opts.height = original.height;
		opts.left = original.left;
		opts.top = original.top;
		opts.fit = original.fit;
		setSize(target);
		opts.minimized = false;
		opts.maximized = false;
		opts.onRestore.call(target);
	};
	function setBorder(target) {
		var opts = $.data(target, 'panel').options;
		var panel = $.data(target, 'panel').panel;
		if (opts.border == true) {
			panel.children('div.panel-header')
					.removeClass('panel-header-noborder');
			panel.children('div.panel-body').removeClass('panel-body-noborder');
		} else {
			panel.children('div.panel-header').addClass('panel-header-noborder');
			panel.children('div.panel-body').addClass('panel-body-noborder');
		}
		panel.css(opts.style);
		panel.addClass(opts.cls);
		panel.children('div.panel-header').addClass(opts.headerCls);
		panel.children('div.panel-body').addClass(opts.bodyCls);
	};
	function setTitle(target, title) {
		$.data(target, 'panel').options.title = title;
		$(target).panel('header').find('div.panel-title').html(title);
	};
	var TO = false;
	var resized = true;
	$(window).unbind('.panel').bind('resize.panel', function() {
				if (!resized) {
					return;
				}
				if (TO !== false) {
					clearTimeout(TO);
				}
				TO = setTimeout(function() {
							resized = false;
							var layout = $('body.layout');
							if (layout.length) {
								layout.layout('resize');
							} else {
								$('body').children('div.panel,div.accordion,div.tabs-container,div.layout').triggerHandler('_resize');
							}
							resized = true;
							TO = false;
						}, 200);
			});
	$.fn.panel = function(options, param) {
		if (typeof options == 'string') {
			return $.fn.panel.methods[options](this, param);
		}
		options = options || {};
		return this.each(function() {
					var state = $.data(this, 'panel');
					var opts;
					if (state) {
						opts = $.extend(state.options, options);
					} else {
						opts = $.extend({}, $.fn.panel.defaults, $.fn.panel
										.parseOptions(this), options);
						$(this).attr('title', '');
						state = $.data(this, 'panel', {
									options : opts,
									panel : wrapPanel(this),
									isLoaded : false
								});
					}
					if (opts.content) {
						$(this).html(opts.content);
						if ($.parser) {
							$.parser.parse(this);
						}
					}
					addHeader(this);
					setBorder(this);
					if (opts.doSize == true) {
						state.panel.css('display', 'block');
						setSize(this);
					}
					if (opts.closed == true || opts.minimized == true) {
						state.panel.hide();
					} else {
						openPanel(this);
					}
				});
	};
	$.fn.panel.methods = {
		options : function(jq) {
			return $.data(jq[0], 'panel').options;
		},
		panel : function(jq) {
			return $.data(jq[0], 'panel').panel;
		},
		header : function(jq) {
			return $.data(jq[0], 'panel').panel.find('>div.panel-header');
		},
		body : function(jq) {
			return $.data(jq[0], 'panel').panel.find('>div.panel-body');
		},
		setTitle : function(jq, title) {
			return jq.each(function() {
						setTitle(this, title);
					});
		},
		open : function(jq, param) {
			return jq.each(function() {
						openPanel(this, param);
					});
		},
		close : function(jq, param) {
			return jq.each(function() {
						closePanel(this, param);
					});
		},
		destroy : function(jq, param) {
			return jq.each(function() {
						destroyPanel(this, param);
					});
		},
		refresh : function(jq, url) {
			return jq.each(function() {
						$.data(this, 'panel').isLoaded = false;
						if (url) {
							$.data(this, 'panel').options.href = url;
						}
						loadData(this);
					});
		},
		resize : function(jq, param) {
			return jq.each(function() {
						setSize(this, param);
					});
		},
		move : function(jq, param) {
			return jq.each(function() {
						movePanel(this, param);
					});
		},
		maximize : function(jq) {
			return jq.each(function() {
						maximizePanel(this);
					});
		},
		minimize : function(jq) {
			return jq.each(function() {
						minimizePanel(this);
					});
		},
		restore : function(jq) {
			return jq.each(function() {
						restorePanel(this);
					});
		},
		collapse : function(jq, param) {
			return jq.each(function() {
						collapsePanel(this, param);
					});
		},
		expand : function(jq, param) {
			return jq.each(function() {
						expandPanel(this, param);
					});
		}
	};
	$.fn.panel.parseOptions = function(target) {
		var t = $(target);
		return {
			width : (parseInt(target.style.width) || undefined),
			height : (parseInt(target.style.height) || undefined),
			left : (parseInt(target.style.left) || undefined),
			top : (parseInt(target.style.top) || undefined),
			title : (t.attr('title') || undefined),
			iconCls : (t.attr('iconCls') || t.attr('icon')),
			cls : t.attr('cls'),
			headerCls : t.attr('headerCls'),
			bodyCls : t.attr('bodyCls'),
			href : t.attr('href'),
			loadingMessage : (t.attr('loadingMessage') != undefined ? t
					.attr('loadingMessage') : undefined),
			cache : (t.attr('cache') ? t.attr('cache') == 'true' : undefined),
			fit : (t.attr('fit') ? t.attr('fit') == 'true' : undefined),
			border : (t.attr('border') ? t.attr('border') == 'true' : undefined),
			noheader : (t.attr('noheader')
					? t.attr('noheader') == 'true'
					: undefined),
			collapsible : (t.attr('collapsible')
					? t.attr('collapsible') == 'true'
					: undefined),
			minimizable : (t.attr('minimizable')
					? t.attr('minimizable') == 'true'
					: undefined),
			maximizable : (t.attr('maximizable')
					? t.attr('maximizable') == 'true'
					: undefined),
			closable : (t.attr('closable')
					? t.attr('closable') == 'true'
					: undefined),
			collapsed : (t.attr('collapsed')
					? t.attr('collapsed') == 'true'
					: undefined),
			minimized : (t.attr('minimized')
					? t.attr('minimized') == 'true'
					: undefined),
			maximized : (t.attr('maximized')
					? t.attr('maximized') == 'true'
					: undefined),
			closed : (t.attr('closed') ? t.attr('closed') == 'true' : undefined)
		};
	};
	$.fn.panel.defaults = {
		title : null,
		iconCls : null,
		width : 'auto',
		height : 'auto',
		left : null,
		top : null,
		cls : null,
		headerCls : null,
		bodyCls : null,
		style : {},
		href : null,
		cache : true,
		fit : false,
		border : true,
		doSize : true,
		noheader : false,
		content : null,
		collapsible : false,
		minimizable : false,
		maximizable : false,
		closable : false,
		collapsed : false,
		minimized : false,
		maximized : false,
		closed : false,
		tools : [],
		href : null,
		loadingMessage : 'Loading...',
		extractor : function(data) {
			var bodyRegEx = /<body[^>]*>((.|[\n\r])*)<\/body>/im;
			var found = bodyRegEx.exec(data);
			if (found) {
				return found[1];
			} else {
				return data;
			}
		},
		onLoad : function() {
		},
		onBeforeOpen : function() {
		},
		onOpen : function() {
		},
		onBeforeClose : function() {
		},
		onClose : function() {
		},
		onBeforeDestroy : function() {
		},
		onDestroy : function() {
		},
		onResize : function(width, height) {
		},
		onMove : function(left, top) {
		},
		onMaximize : function() {
		},
		onRestore : function() {
		},
		onMinimize : function() {
		},
		onBeforeCollapse : function() {
		},
		onBeforeExpand : function() {
		},
		onCollapse : function() {
		},
		onExpand : function() {
		}
	};
})(jQuery);

/**
 * window - jQuery EasyUI
 * 
 * Licensed under the GPL:
 *   http://www.gnu.org/licenses/gpl.txt
 *
 * Copyright 2010 stworthy [ stworthy@gmail.com ] 
 * 
 * Dependencies:
 * 	 panel
 *   draggable
 *   resizable
 * 
 */
(function($) {
	function setSize(target, param) {
		var opts = $.data(target, 'window').options;
		if (param) {
			if (param.width) {
				opts.width = param.width;
			}
			if (param.height) {
				opts.height = param.height;
			}
			if (param.left != null) {
				opts.left = param.left;
			}
			if (param.top != null) {
				opts.top = param.top;
			}
		}
		$(target).panel('resize', opts);
	};
	function move(target, param) {
		var window = $.data(target, 'window');
		if (param) {
			if (param.left != null) {
				window.options.left = param.left;
			}
			if (param.top != null) {
				window.options.top = param.top;
			}
		}
		$(target).panel('move', window.options);
		if (window.shadow) {
			window.shadow.css({
						left : window.options.left,
						top : window.options.top
					});
		}
	};
	function init(target) {
		var state = $.data(target, 'window');
		var win = $(target).panel($.extend({}, state.options, {
					border : false,
					doSize : true,
					closed : true,
					cls : 'window',
					headerCls : 'window-header',
					bodyCls : 'window-body '+(state.options.noheader?'window-body-noheader':''),
					onBeforeDestroy : function() {
						if (state.options.onBeforeDestroy.call(target) == false) {
							return false;
						}
						if (state.shadow) {
							state.shadow.remove();
						}
						if (state.mask) {
							state.mask.remove();
						}
					},
					onClose : function() {
						if (state.shadow) {
							state.shadow.hide();
						}
						if (state.mask) {
							state.mask.hide();
						}
						state.options.onClose.call(target);
					},
					onOpen : function() {
						if (state.mask) {
							state.mask.css({
										display : 'block',
										zIndex : $.fn.window.defaults.zIndex++
									});
						}
						if (state.shadow) {
							state.shadow.css({
										display : 'block',
										zIndex : $.fn.window.defaults.zIndex++,
										left : state.options.left,
										top : state.options.top,
										width : state.window.outerWidth(),
										height : state.window.outerHeight()
									});
						}
						state.window.css('z-index', $.fn.window.defaults.zIndex++);
						state.options.onOpen.call(target);
					},
					onResize : function(width, height) {
						var opts = $(target).panel('options');
						state.options.width = opts.width;
						state.options.height = opts.height;
						state.options.left = opts.left;
						state.options.top = opts.top;
						if (state.shadow) {
							state.shadow.css({
										left : state.options.left,
										top : state.options.top,
										width : state.window.outerWidth(),
										height : state.window.outerHeight()
									});
						}
						state.options.onResize.call(target, width, height);
					},
					onMinimize : function() {
						if (state.shadow) {
							state.shadow.hide();
						}
						if (state.mask) {
							state.mask.hide();
						}
						state.options.onMinimize.call(target);
					},
					onBeforeCollapse : function() {
						if (state.options.onBeforeCollapse.call(target) == false) {
							return false;
						}
						if (state.shadow) {
							state.shadow.hide();
						}
					},
					onExpand : function() {
						if (state.shadow) {
							state.shadow.show();
						}
						state.options.onExpand.call(target);
					}
				}));
		state.window = win.panel('panel');
		if (state.mask) {
			state.mask.remove();
		}
		if (state.options.modal == true) {
			state.mask = $('<div class="window-mask"></div>')
					.insertAfter(state.window);
			state.mask.css({
						display : 'none'
					});
		}
		if (state.shadow) {
			state.shadow.remove();
		}
		if (state.options.shadow == true) {
			state.shadow = $('<div class="window-shadow"></div>')
					.insertAfter(state.window);
			state.shadow.css({
						display : 'none'
					});
		}
		if (state.options.left == null) {
			var width = state.options.width;
			if (isNaN(width)) {
				width = state.window.outerWidth();
			}
			if (state.options.inline) {
				var parent = state.window.parent();
				state.options.left = (parent.width() - width) / 2 + parent.scrollLeft();
			} else {
				state.options.left = ($(window).width() - width) / 2
						+ $(document).scrollLeft();
			}
		}
		if (state.options.top == null) {
			var height = state.window.height;
			if (isNaN(height)) {
				height = state.window.outerHeight();
			}
			if (state.options.inline) {
				var parent = state.window.parent();
				state.options.top = (parent.height() - height) / 2 + parent.scrollTop();
			} else {
				state.options.top = ($(window).height() - height) / 2
						+ $(document).scrollTop();
			}
		}
		move(target);
		if (state.options.closed == false) {
			win.window('open');
		}
	};
	function setProperties(target) {
		var state = $.data(target, 'window');
		state.window.draggable({
			handle : '>div.panel-header>div.panel-title',
			disabled : state.options.draggable == false,
			onStartDrag : function(e) {
				if (state.mask) {
					state.mask.css('z-index', $.fn.window.defaults.zIndex++);
				}
				if (state.shadow) {
					state.shadow.css('z-index', $.fn.window.defaults.zIndex++);
				}
				state.window.css('z-index', $.fn.window.defaults.zIndex++);
				if (!state.proxy) {
					state.proxy = $('<div class="window-proxy"></div>')
							.insertAfter(state.window);
				}
				state.proxy.css({
							display : 'none',
							zIndex : $.fn.window.defaults.zIndex++,
							left : e.data.left,
							top : e.data.top,
							width : ($.boxModel == true
									? (state.window.outerWidth() - (state.proxy
											.outerWidth() - state.proxy.width()))
									: state.window.outerWidth()),
							height : ($.boxModel == true
									? (state.window.outerHeight() - (state.proxy
											.outerHeight() - state.proxy.height()))
									: state.window.outerHeight())
						});
				setTimeout(function() {
							if (state.proxy) {
								state.proxy.show();
							}
						}, 500);
			},
			onDrag : function(e) {
				state.proxy.css({
							display : 'block',
							left : e.data.left,
							top : e.data.top
						});
				return state.options.noproxy == true;
			},
			onStopDrag : function(e) {
				state.options.left = e.data.left;
				state.options.top = e.data.top;
				$(target).window('move');
				state.proxy.remove();
				state.proxy = null;
			}
		});
		state.window.resizable({
			disabled : state.options.resizable == false,
			onStartResize : function(e) {
				state.pmask=$('<div class="window-proxy-mask"></div>').insertAfter(state.window);
				state.pmask.css({zIndex:$.fn.window.defaults.zIndex++,left:e.data.left,top:e.data.top,width:state.window.outerWidth(),height:state.window.outerHeight()});
				if (!state.proxy) {
					state.proxy = $('<div class="window-proxy"></div>')
							.insertAfter(state.window);
				}
				state.proxy.css({
					zIndex : $.fn.window.defaults.zIndex++,
					left : e.data.left,
					top : e.data.top,
					width : ($.boxModel == true ? (e.data.width - (state.proxy
							.outerWidth() - state.proxy.width())) : e.data.width),
					height : ($.boxModel == true
							? (e.data.height - (state.proxy.outerHeight() - state.proxy
									.height()))
							: e.data.height)
				});
			},
			onResize : function(e) {
				state.proxy.css({
					left : e.data.left,
					top : e.data.top,
					width : ($.boxModel == true ? (e.data.width - (state.proxy
							.outerWidth() - state.proxy.width())) : e.data.width),
					height : ($.boxModel == true
							? (e.data.height - (state.proxy.outerHeight() - state.proxy
									.height()))
							: e.data.height)
				});
				return false;
			},
			onStopResize : function(e) {
				state.options.left = e.data.left;
				state.options.top = e.data.top;
				state.options.width = e.data.width;
				state.options.height = e.data.height;
				setSize(target);
				state.pmask.remove();
				state.pmask=null;
				state.proxy.remove();
				state.proxy = null;
			}
		});
	};
	function getPageArea() {
		if (document.compatMode == 'BackCompat') {
			return {
				width : Math.max(document.body.scrollWidth,
						document.body.clientWidth),
				height : Math.max(document.body.scrollHeight,
						document.body.clientHeight)
			};
		} else {
			return {
				width : Math.max(document.documentElement.scrollWidth,
						document.documentElement.clientWidth),
				height : Math.max(document.documentElement.scrollHeight,
						document.documentElement.clientHeight)
			};
		}
	};
	$(window).resize(function() {
				$('body>div.window-mask').css({
							width : $(window).width(),
							height : $(window).height()
						});
				setTimeout(function() {
							$('body>div.window-mask').css({
										width : getPageArea().width,
										height : getPageArea().height
									});
						}, 50);
			});
	$.fn.window = function(options, param) {
		if (typeof options == 'string') {
			var method = $.fn.window.methods[options];
			if (method) {
				return method(this, param);
			} else {
				return this.panel(options, param);
			}
		}
		options = options || {};
		return this.each(function() {
					var state = $.data(this, 'window');
					if (state) {
						$.extend(state.options, options);
					} else {
						state = $.data(this, 'window', {
									options : $.extend({},
											$.fn.window.defaults, $.fn.window
													.parseOptions(this), options)
								});
						if (!state.options.inline) {
							$(this).appendTo('body');
						}
					}
					init(this);
					setProperties(this);
				});
	};
	$.fn.window.methods = {
		options : function(jq) {
			var opts = jq.panel('options');
			var options = $.data(jq[0], 'window').options;
			return $.extend(options, {
						closed : opts.closed,
						collapsed : opts.collapsed,
						minimized : opts.minimized,
						maximized : opts.maximized
					});
		},
		window : function(jq) {
			return $.data(jq[0], 'window').window;
		},
		resize : function(jq, param) {
			return jq.each(function() {
						setSize(this, param);
					});
		},
		move : function(jq, param) {
			return jq.each(function() {
						move(this, param);
					});
		}
	};
	$.fn.window.parseOptions = function(target) {
		var t = $(target);
		return $.extend({}, $.fn.panel.parseOptions(target), {
			draggable : (t.attr('draggable')
					? t.attr('draggable') == 'true'
					: undefined),
			resizable : (t.attr('resizable')
					? t.attr('resizable') == 'true'
					: undefined),
			shadow : (t.attr('shadow') ? t.attr('shadow') == 'true' : undefined),
			noproxy : (t.attr('noproxy') ? t.attr('noproxy') == 'true' : undefined),
			modal : (t.attr('modal') ? t.attr('modal') == 'true' : undefined),
			inline : (t.attr('inline') ? t.attr('inline') == 'true' : undefined)
		});
	};
	$.fn.window.defaults = $.extend({}, $.fn.panel.defaults, {
				zIndex : 9000,
				draggable : true,
				resizable : true,
				shadow : true,
				modal : false,
				inline : false,
				title : 'New Window',
				collapsible : true,
				minimizable : true,
				maximizable : true,
				closable : true,
				closed : false
			});
})(jQuery);

/**
 * dialog - jQuery EasyUI
 * 
 * Licensed under the GPL:
 *   http://www.gnu.org/licenses/gpl.txt
 *
 * Copyright 2010 stworthy [ stworthy@gmail.com ] 
 * 
 * Dependencies:
 * 	 window
 * 
 */
(function($) {
	function wrapDialog(target) {
		var t = $(target);
		t.wrapInner('<div class="dialog-content"></div>');
		var contentPanel = t.children('div.dialog-content');
		contentPanel.attr('style', t.attr('style'));
		t.removeAttr('style').css('overflow','hidden');
		contentPanel.panel({
					border : false,
					doSize : false
				});
		return contentPanel;
	};
	function buildDialog(target) {
		var opts = $.data(target, 'dialog').options;
		var contentPanel = $.data(target, 'dialog').contentPanel;
		if (opts.toolbar) {
			if(typeof opts.toolbar=='string'){
				$(opts.toolbar).addClass('dialog-toolbar').prependTo(target);
				$(opts.toolbar).show();
			}else{
				$(target).find('div.dialog-toolbar').remove();
				var toolbar = $('<div class="dialog-toolbar"></div>').prependTo(target);
				for (var i = 0; i < opts.toolbar.length; i++) {
					var p = opts.toolbar[i];
					if (p == '-') {
						toolbar.append('<div class="dialog-tool-separator"></div>');
					} else {
						var tool = $('<a href="javascript:void(0)"></a>')
								.appendTo(toolbar);
						tool.css('float', 'left');
						tool[0].onclick = eval(p.handler || function() {
						});
						tool.linkbutton($.extend({}, p, {
									plain : true
								}));
					}
				}
				toolbar.append('<div style="clear:both"></div>');
			}
		}else{
			$(target).find('div.dialog-toolbar').remove();
		}
		if (opts.buttons) {
			if(typeof opts.buttons=='string'){
				$(opts.buttons).addClass('dialog-button').appendTo(target);
				$(opts).show();
			}else{
				$(target).find('div.dialog-button').remove();
				var buttons = $('<div class="dialog-button"></div>').appendTo(target);
				for (var i = 0; i < opts.buttons.length; i++) {
					var p = opts.buttons[i];
					var button = $('<a href="javascript:void(0)"></a>').appendTo(buttons);
					if (p.handler) {
						button[0].onclick = p.handler;
					}
					button.linkbutton(p);
				}
			}
		}else{
			$(target).find('div.dialog-button').remove();
		}
		var href = opts.href;
		var content= opts.content;
		opts.href = null;
		opts.content=null;
		$(target).window($.extend({}, opts, {
					onOpen:function(){
						contentPanel.panel('open');
						if(opts.onOpen){
							opts.onOpen.call(target);
						}
					},
					onResize : function(width, height) {
						var wbody = $(target).panel('panel').find('>div.panel-body');
						contentPanel.panel('resize', {
									width : wbody.width(),
									height : (height == 'auto') ? 'auto' : wbody
											.height()
											- wbody.find('>div.dialog-toolbar')
													.outerHeight()
											- wbody.find('>div.dialog-button')
													.outerHeight()
								});
						if (opts.onResize) {
							opts.onResize.call(target, width, height);
						}
					}
				}));
		contentPanel.panel({
					closed:opts.closed,
					href : href,
					content:content,
					onLoad : function() {
						if (opts.height == 'auto') {
							$(target).window('resize');
						}
						opts.onLoad.apply(target, arguments);
					}
				});
		opts.href = href;
	};
	function refresh(target, href) {
		var contentPanel = $.data(target, 'dialog').contentPanel;
		contentPanel.panel('refresh', href);
	};
	$.fn.dialog = function(options, param) {
		if (typeof options == 'string') {
			var method = $.fn.dialog.methods[options];
			if (method) {
				return method(this, param);
			} else {
				return this.window(options, param);
			}
		}
		options = options || {};
		return this.each(function() {
					var state = $.data(this, 'dialog');
					if (state) {
						$.extend(state.options, options);
					} else {
						$.data(this, 'dialog', {
									options : $.extend({},
											$.fn.dialog.defaults, $.fn.dialog
													.parseOptions(this), options),
									contentPanel : wrapDialog(this)
								});
					}
					buildDialog(this);
				});
	};
	$.fn.dialog.methods = {
		options : function(jq) {
			var options = $.data(jq[0], 'dialog').options;
			var opts = jq.panel('options');
			$.extend(options, {
						closed : opts.closed,
						collapsed : opts.collapsed,
						minimized : opts.minimized,
						maximized : opts.maximized
					});
			var contentPanel = $.data(jq[0], 'dialog').contentPanel;
			return options;
		},
		dialog : function(jq) {
			return jq.window('window');
		},
		refresh : function(jq, href) {
			return jq.each(function() {
						refresh(this, href);
					});
		}
	};
	$.fn.dialog.parseOptions = function(target) {
		var t = $(target);
		return $.extend({}, $.fn.window.parseOptions(target),
			{toolbar:t.attr('toolbar'),buttons:t.attr('buttons')});
	};
	$.fn.dialog.defaults = $.extend({}, $.fn.window.defaults, {
				title : 'New Dialog',
				collapsible : false,
				minimizable : false,
				maximizable : false,
				resizable : false,
				toolbar : null,
				buttons : null
			});
})(jQuery);

/**
 * messager - jQuery EasyUI
 * 
 * Licensed under the GPL:
 *   http://www.gnu.org/licenses/gpl.txt
 *
 * Copyright 2010 stworthy [ stworthy@gmail.com ] 
 * 
 * Dependencies:
 * 	draggable
 * 	resizable
 * 	linkbutton
 * 	panel
 *  window
 */
(function($) {
	function show(el, type, speed, timeout) {
		var win = $(el).window('window');
		if (!win) {
			return;
		}
		switch (type) {
			case null :
				win.show();
				break;
			case 'slide' :
				win.slideDown(speed);
				break;
			case 'fade' :
				win.fadeIn(speed);
				break;
			case 'show' :
				win.show(speed);
				break;
		}
		var timer = null;
		if (timeout > 0) {
			timer = setTimeout(function() {
						hide(el, type, speed);
					}, timeout);
		}
		win.hover(function() {
					if (timer) {
						clearTimeout(timer);
					}
				}, function() {
					if (timeout > 0) {
						timer = setTimeout(function() {
									hide(el, type, speed);
								}, timeout);
					}
				});
	};
	function hide(el, type, speed) {
		if (el.locked == true) {
			return;
		}
		el.locked = true;
		var win = $(el).window('window');
		if (!win) {
			return;
		}
		switch (type) {
			case null :
				win.hide();
				break;
			case 'slide' :
				win.slideUp(speed);
				break;
			case 'fade' :
				win.fadeOut(speed);
				break;
			case 'show' :
				win.hide(speed);
				break;
		}
		setTimeout(function() {
					$(el).window('destroy');
				}, speed);
	};
	function createDialog(title, content, buttons) {
		var win = $('<div class="messager-body"></div>').appendTo('body');
		win.append(content);
		if (buttons) {
			var tb = $('<div class="messager-button"></div>').appendTo(win);
			for (var label in buttons) {
				$('<a></a>').attr('href', 'javascript:void(0)').text(label).css(
						'margin-left', 10).bind('click', eval(buttons[label]))
						.appendTo(tb).linkbutton();
			}
		}
		win.window({
					title : title,
					noheader : (title?false:true),
					width : 300,
					height : 'auto',
					modal : true,
					collapsible : false,
					minimizable : false,
					maximizable : false,
					resizable : false,
					onClose : function() {
						setTimeout(function() {
									win.window('destroy');
								}, 100);
					}
				});
		win.window('window').addClass('messager-window');
		return win;
	};
	$.messager = {
		show : function(options) {
			var opts = $.extend({
						showType : 'slide',
						showSpeed : 600,
						width : 250,
						height : 100,
						msg : '',
						title : '',
						timeout : 4000
					}, options || {});
			var win = $('<div class="messager-body"></div>').html(opts.msg)
					.appendTo('body');
			win.window({
						title : opts.title,
						width : opts.width,
						height : opts.height,
						collapsible : false,
						minimizable : false,
						maximizable : false,
						shadow : false,
						draggable : false,
						resizable : false,
						closed : true,
						onBeforeOpen : function() {
							show(this, opts.showType, opts.showSpeed, opts.timeout);
							return false;
						},
						onBeforeClose : function() {
							hide(this, opts.showType, opts.showSpeed);
							return false;
						}
					});
			win.window('window').css({
				left : '',
				top : '',
				right : 0,
				zIndex : $.fn.window.defaults.zIndex++,
				bottom : -document.body.scrollTop
						- document.documentElement.scrollTop
			});
			win.window('open');
		},
		alert : function(title, msg, icon, fn) {
			var content = '<div>' + msg + '</div>';
			switch (icon) {
				case 'error' :
					content = '<div class="messager-icon messager-error"></div>'
							+ content;
					break;
				case 'info' :
					content = '<div class="messager-icon messager-info"></div>'
							+ content;
					break;
				case 'question' :
					content = '<div class="messager-icon messager-question"></div>'
							+ content;
					break;
				case 'warning' :
					content = '<div class="messager-icon messager-warning"></div>'
							+ content;
					break;
			}
			content += '<div style="clear:both;"/>';
			var buttons = {};
			buttons[$.messager.defaults.ok] = function() {
				win.dialog({
							closed : true
						});
				if (fn) {
					fn();
					return false;
				}
			};
			buttons[$.messager.defaults.ok] = function() {
				win.window('close');
				if (fn) {
					fn();
					return false;
				}
			};
			var win = createDialog(title, content, buttons);
		},
		confirm : function(title, msg, fn) {
			var content = '<div class="messager-icon messager-question"></div>'
					+ '<div>' + msg + '</div>' + '<div style="clear:both;"/>';
			var buttons = {};
			buttons[$.messager.defaults.ok] = function() {
				win.window('close');
				if (fn) {
					fn(true);
					return false;
				}
			};
			buttons[$.messager.defaults.cancel] = function() {
				win.window('close');
				if (fn) {
					fn(false);
					return false;
				}
			};
			var win = createDialog(title, content, buttons);
		},
		prompt : function(title, msg, fn) {
			var content = '<div class="messager-icon messager-question"></div>'
					+ '<div>' + msg + '</div>' + '<br/>'
					+ '<input class="messager-input" type="text"/>'
					+ '<div style="clear:both;"/>';
			var buttons = {};
			buttons[$.messager.defaults.ok] = function() {
				win.window('close');
				if (fn) {
					fn($('.messager-input', win).val());
					return false;
				}
			};
			buttons[$.messager.defaults.cancel] = function() {
				win.window('close');
				if (fn) {
					fn();
					return false;
				}
			};
			var win = createDialog(title, content, buttons);
		},
		progress : function(options) {
			var opts = $.extend({
						title : '',
						msg : '',
						text : undefined,
						interval : 300
					}, options || {});
			var methods = {
				bar : function() {
					return $('body>div.messager-window')
							.find('div.messager-p-bar');
				},
				close : function() {
					var win = $('body>div.messager-window>div.messager-body');
					if (win.length) {
						if (win[0].timer) {
							clearInterval(win[0].timer);
						}
						win.window('close');
					}
				}
			};
			if (typeof options == 'string') {
				var method = methods[options];
				return method();
			}
			var pbar = '<div class="messager-progress"><div class="messager-p-msg"></div><div class="messager-p-bar"></div></div>';
			var win = createDialog(opts.title, pbar, null);
			win.find('div.messager-p-msg').html(opts.msg);
			var bar = win.find('div.messager-p-bar');
			bar.progressbar({
						text : opts.text
					});
			win.window({
						closable : false
					});
			if (opts.interval) {
				win[0].timer = setInterval(function() {
							var v = bar.progressbar('getValue');
							v += 10;
							if (v > 100) {
								v = 0;
							}
							bar.progressbar('setValue', v);
						}, opts.interval);
			}
		}
	};
	$.messager.defaults = {
		ok : 'Ok',
		cancel : 'Cancel'
	};
})(jQuery);

/**
 * accordion - jQuery EasyUI
 * 
 * Licensed under the GPL:
 *   http://www.gnu.org/licenses/gpl.txt
 *
 * Copyright 2010 stworthy [ stworthy@gmail.com ] 
 * 
 * Dependencies:
 * 	 panel
 * 
 */


/**
 * tabs - jQuery EasyUI
 * 
 * Licensed under the GPL:
 *   http://www.gnu.org/licenses/gpl.txt
 *
 * Copyright 2010 stworthy [ stworthy@gmail.com ] 
 */
(function($) {
	function getMaxScrollWidth(container) {
		var header = $('>div.tabs-header', container);
		var tabsWidth = 0;
		$('ul.tabs li', header).each(function() {
					tabsWidth += $(this).outerWidth(true);
				});
		var wrapWidth = $('div.tabs-wrap', header).width();
		var padding = parseInt($('ul.tabs', header).css('padding-left'));
		return tabsWidth - wrapWidth + padding;
	};
	function setScrollers(container) {
		var opts = $.data(container, 'tabs').options;
		var header = $(container).children('div.tabs-header');
		var tool = header.children('div.tabs-tool');
		var leftScroller = header.children('div.tabs-scroller-left');
		var rightScroller = header.children('div.tabs-scroller-right');
		var wrap = header.children('div.tabs-wrap');
		var height = ($.boxModel == true
				? (header.outerHeight() - (tool.outerHeight() - tool.height()))
				: header.outerHeight());
		if (opts.plain) {
			height -= 2;
		}
		tool.height(height);
		var fullWidth = 0;
		$('ul.tabs li', header).each(function() {
					fullWidth += $(this).outerWidth(true);
				});
		var realWidth = header.width() - tool.outerWidth();
		if (fullWidth > realWidth) {
			leftScroller.show();
			rightScroller.show();
			tool.css('right', rightScroller.outerWidth());
			wrap.css({
						marginLeft : leftScroller.outerWidth(),
						marginRight : rightScroller.outerWidth() + tool.outerWidth(),
						left : 0,
						width : realWidth - leftScroller.outerWidth() - rightScroller.outerWidth()
					});
		} else {
			leftScroller.hide();
			rightScroller.hide();
			tool.css('right', 0);
			wrap.css({
						marginLeft : 0,
						marginRight : tool.outerWidth(),
						left : 0,
						width : realWidth
					});
			wrap.scrollLeft(0);
		}
	};
	function buildButton(container) {
		var opts = $.data(container, 'tabs').options;
		var header = $(container).children('div.tabs-header');
		var tool = header.children('div.tabs-tool');
		tool.remove();
		if (opts.tools) {
			tool = $('<div class="tabs-tool"></div>').appendTo(header);
			for (var i = 0; i < opts.tools.length; i++) {
				var button = $('<a href="javascript:void(0);"></a>')
						.appendTo(tool);
				button[0].onclick = eval(opts.tools[i].handler || function() {
				});
				button.linkbutton($.extend({}, opts.tools[i], {
							plain : true
						}));
			}
		}
	};
	function setSize(container) {
		var opts = $.data(container, 'tabs').options;
		var cc = $(container);
		if (opts.fit == true) {
			var p = cc.parent();
			opts.width = p.width();
			opts.height = p.height();
		}
		cc.width(opts.width).height(opts.height);
		var header = $('>div.tabs-header', container);
		if ($.boxModel == true) {
			header.width(opts.width - (header.outerWidth() - header.width()));
		} else {
			header.width(opts.width);
		}
		setScrollers(container);
		var panels = $('>div.tabs-panels', container);
		var height = opts.height;
		if (!isNaN(height)) {
			if ($.boxModel == true) {
				var borderHeight = panels.outerHeight() - panels.height();
				panels.css('height', (height - header.outerHeight() - borderHeight) || 'auto');
			} else {
				panels.css('height', height - header.outerHeight());
			}
		} else {
			panels.height('auto');
		}
		var width = opts.width;
		if (!isNaN(width)) {
			if ($.boxModel == true) {
				panels.width(width - (panels.outerWidth() - panels.width()));
			} else {
				panels.width(width);
			}
		} else {
			panels.width('auto');
		}
	};
	function fitContent(container) {
		var opts = $.data(container, 'tabs').options;
		var tab = getSelected(container);
		if (tab) {

			var panel = $(container).find('>div.tabs-panels');
			var width = opts.width == 'auto' ? 'auto' : panel.width();
			var height = opts.height == 'auto' ? 'auto' : panel.height();
			tab.panel('resize', {
						width : width,
						height : height
					});
		}
	};
	function wrapTabs(container) {
		var cc = $(container);
		cc.addClass('tabs-container');
		cc.wrapInner('<div class="tabs-panels"/>');
		$('<div class="tabs-header">'
				+ '<div class="tabs-scroller-left"></div>'
				+ '<div class="tabs-scroller-right"></div>'
				+ '<div class="tabs-wrap">' + '<ul class="tabs"></ul>'
				+ '</div>' + '</div>').prependTo(container);
		var tabs = [];
		var tp = cc.children('div.tabs-panels');
		tp.children('div[selected]').attr('closed', 'false');
		tp.children('div').not('div[selected]').attr('closed', 'true');
		tp.children('div').each(function() {
					var pp = $(this);
					tabs.push(pp);
					createTab(container, pp);
				});
		cc.children('div.tabs-header').find('.tabs-scroller-left, .tabs-scroller-right').hover(function(){
					$(this).addClass('tabs-scroller-over');
				}, function() {
					$(this).removeClass('tabs-scroller-over');
				});
		cc.bind('_resize', function(e, param) {
					var opts = $.data(container, 'tabs').options;
					if (opts.fit == true || param) {
						setSize(container);
						fitContent(container);
					}
					return false;
				});
		return tabs;
	};
	function setProperties(container) {
		var opts = $.data(container, 'tabs').options;
		var header = $('>div.tabs-header', container);
		var panels = $('>div.tabs-panels', container);
		if (opts.plain == true) {
			header.addClass('tabs-header-plain');
		} else {
			header.removeClass('tabs-header-plain');
		}
		if (opts.border == true) {
			header.removeClass('tabs-header-noborder');
			panels.removeClass('tabs-panels-noborder');
		} else {
			header.addClass('tabs-header-noborder');
			panels.addClass('tabs-panels-noborder');
		}
		$('.tabs-scroller-left', header).unbind('.tabs').bind('click.tabs',
				function() {
					var wrap = $('.tabs-wrap', header);
					var pos = wrap.scrollLeft() - opts.scrollIncrement;
					wrap.animate({
								scrollLeft : pos
							}, opts.scrollDuration);
				});
		$('.tabs-scroller-right', header).unbind('.tabs').bind('click.tabs',
				function() {
					var wrap = $('.tabs-wrap', header);
					var pos = Math.min(wrap.scrollLeft() + opts.scrollIncrement,
							getMaxScrollWidth(container));
					wrap.animate({
								scrollLeft : pos
							}, opts.scrollDuration);
				});
		var tabs = $.data(container, 'tabs').tabs;
		for (var i = 0, len = tabs.length; i < len; i++) {
			var tabPanel = tabs[i];
			var tab = tabPanel.panel('options').tab;
			var title = tabPanel.panel('options').title;
			tab.unbind('.tabs').bind('click.tabs', {
						title : title
					}, function(e) {
						selectTab(container, e.data.title);
					}).bind('contextmenu.tabs', {
						title : title
					}, function(e) {
						opts.onContextMenu.call(container, e, e.data.title);
					});
			tab.find('a.tabs-close').unbind('.tabs').bind('click.tabs', {
						title : title
					}, function(e) {
						closeTab(container, e.data.title);
						return false;
					});
		}
	};
	function createTab(container, pp, options) {
		options = options || {};
		pp.panel($.extend({}, options, {
					border : false,
					noheader : true,
					closed : true,
					doSize : false,
					iconCls : (options.icon ? options.icon : undefined),
					onLoad : function() {
						$.data(container, 'tabs').options.onLoad.call(container, pp);
					}
				}));
		var opts = pp.panel('options');
		var header = $('>div.tabs-header', container);
		var tabs = $('ul.tabs', header);
		var tab = $('<li></li>').appendTo(tabs);
		var tabInner = $('<a href="javascript:void(0)" class="tabs-inner"></a>')
				.appendTo(tab);
		var tabTitle = $('<span class="tabs-title"></span>').html(opts.title)
				.appendTo(tabInner);
		var tabIcon = $('<span class="tabs-icon"></span>').appendTo(tabInner);
		if (opts.closable) {
			tabTitle.addClass('tabs-closable');
			$('<a href="javascript:void(0)" class="tabs-close"></a>')
					.appendTo(tab);
		}
		if (opts.iconCls) {
			tabTitle.addClass('tabs-with-icon');
			tabIcon.addClass(opts.iconCls);
		}
		opts.tab = tab;
	};
	function addTab(container, options) {
		var opts = $.data(container, 'tabs').options;
		var tabs = $.data(container, 'tabs').tabs;
		var pp = $('<div></div>').appendTo($('>div.tabs-panels', container));
		tabs.push(pp);
       
		createTab(container, pp, options);
		opts.onAdd.call(container, options.title);
		setScrollers(container);
		setProperties(container);
		selectTab(container, options.title);
	};
	function update(container, param) {
		var selectHis = $.data(container, 'tabs').selectHis;
		var pp = param.tab;
		var title = pp.panel('options').title;
		pp.panel($.extend({}, param.options, {
					iconCls : (param.options.icon ? param.options.icon : undefined)
				}));
		var opts = pp.panel('options');
		var tab = opts.tab;
		tab.find('span.tabs-icon').attr('class', 'tabs-icon');
		tab.find('a.tabs-close').remove();
		tab.find('span.tabs-title').html(opts.title);
		if (opts.closable) {
			tab.find('span.tabs-title').addClass('tabs-closable');
			$('<a href="javascript:void(0)" class="tabs-close"></a>')
					.appendTo(tab);
		} else {
			tab.find('span.tabs-title').removeClass('tabs-closable');
		}
		if (opts.iconCls) {
			tab.find('span.tabs-title').addClass('tabs-with-icon');
			tab.find('span.tabs-icon').addClass(opts.iconCls);
		} else {
			tab.find('span.tabs-title').removeClass('tabs-with-icon');
		}
		if (title != opts.title) {
			for (var i = 0; i < selectHis.length; i++) {
				if (selectHis[i] == title) {
					selectHis[i] = opts.title;
				}
			}
		}
		setProperties(container);
		$.data(container, 'tabs').options.onUpdate.call(container, opts.title);
	};
	function closeTab(container, title) {
		var opts = $.data(container, 'tabs').options;
		var tabs = $.data(container, 'tabs').tabs;
		var selectHis = $.data(container, 'tabs').selectHis;
		if (!exists(container, title)) {
			return;
		}
		if (opts.onBeforeClose.call(container, title) == false) {
			return;
		}
		var tab = getTab(container, title, true);
		tab.panel('options').tab.remove();
		tab.panel('destroy');
		opts.onClose.call(container, title);
		setScrollers(container);
		for (var i = 0; i < selectHis.length; i++) {
			if (selectHis[i] == title) {
				selectHis.splice(i, 1);
				i--;
			}
		}
		var lastTab = selectHis.pop();
		if (lastTab) {
			selectTab(container, lastTab);
		} else {
			if (tabs.length) {
				selectTab(container, tabs[0].panel('options').title);
			}
		}
	};
	function getTab(container, title, close) {
		var tabs = $.data(container, 'tabs').tabs;
		for (var i = 0; i < tabs.length; i++) {
			var tab = tabs[i];
			if (tab.panel('options').title == title) {
				if (close) {
					tabs.splice(i, 1);
				}
				return tab;
			}
		}
		return null;
	};
	function getSelected(container) {
		var tabs = $.data(container, 'tabs').tabs;
		for (var i = 0; i < tabs.length; i++) {
			var tab = tabs[i];
			if (tab.panel('options').closed == false) {
				return tab;
			}
		}
		return null;
	};
	function initSelectTab(container) {
		var tabs = $.data(container, 'tabs').tabs;
		for (var i = 0; i < tabs.length; i++) {
			var tab = tabs[i];
			if (tab.panel('options').selected) {
				selectTab(container, tab.panel('options').title);
				return;
			}
		}
		if (tabs.length) {
			selectTab(container, tabs[0].panel('options').title);
		}
	};
	function selectTab(container, title) {
		var opts = $.data(container, 'tabs').options;
		var tabs = $.data(container, 'tabs').tabs;
		var selectHis = $.data(container, 'tabs').selectHis;
		if (tabs.length == 0) {
			return;
		}
		var tab = getTab(container, title);
		if (!tab) {
			return;
		}
		var selected = getSelected(container);
		if (selected) {
			selected.panel('close');
			selected.panel('options').tab.removeClass('tabs-selected');
		}
		tab.panel('open');
		var tab = tab.panel('options').tab;
		tab.addClass('tabs-selected');
		var wrap = $(container).find('>div.tabs-header div.tabs-wrap');
		var leftPos = tab.position().left + wrap.scrollLeft();
		var left = leftPos - wrap.scrollLeft();
		var right = left + tab.outerWidth();
		if (left < 0 || right > wrap.innerWidth()) {
			var pos = Math.min(leftPos - (wrap.width() - tab.width()) / 2, getMaxScrollWidth(container));
			wrap.animate({
						scrollLeft : pos
					}, opts.scrollDuration);
		} else {
			var pos = Math.min(wrap.scrollLeft(), getMaxScrollWidth(container));
			wrap.animate({
						scrollLeft : pos
					}, opts.scrollDuration);
		}
		fitContent(container);
		selectHis.push(title);
		opts.onSelect.call(container, title);
	};
	function exists(container, title) {
		return getTab(container, title) != null;
	};
	$.fn.tabs = function(options, param) {
		if (typeof options == 'string') {
			return $.fn.tabs.methods[options](this, param);
		}
		options = options || {};
		return this.each(function() {
					var state = $.data(this, 'tabs');
					var opts;
					if (state) {
						opts = $.extend(state.options, options);
						state.options = opts;
					} else {
						$.data(this, 'tabs', {
									options : $.extend({}, $.fn.tabs.defaults,
											$.fn.tabs.parseOptions(this), options),
									tabs : wrapTabs(this),
									selectHis : []
								});
					}
					buildButton(this);
					setProperties(this);
					setSize(this);
					initSelectTab(this);
				});
	};
	$.fn.tabs.methods = {
		options : function(jq) {
			return $.data(jq[0], 'tabs').options;
		},
		tabs : function(jq) {
			return $.data(jq[0], 'tabs').tabs;
		},
		resize : function(jq) {
			return jq.each(function() {
						setSize(this);
						fitContent(this);
					});
		},
		add : function(jq, options) {
			return jq.each(function() {
						addTab(this, options);
					});
		},
		close : function(jq, title) {
			return jq.each(function() {
						closeTab(this, title);
					});
		},
		getTab : function(jq, title) {
			return getTab(jq[0], title);
		},
		getSelected : function(jq) {
			return getSelected(jq[0]);
		},
		select : function(jq, title) {
			return jq.each(function() {
						selectTab(this, title);
					});
		},
		exists : function(jq, title) {
			return exists(jq[0], title);
		},
		update : function(jq, param) {
			return jq.each(function() {
						update(this, param);
					});
		}
	};
	$.fn.tabs.parseOptions = function(target) {
		var t = $(target);
		return {
			width : (parseInt(target.style.width) || undefined),
			height : (parseInt(target.style.height) || undefined),
			fit : (t.attr('fit') ? t.attr('fit') == 'true' : undefined),
			border : (t.attr('border') ? t.attr('border') == 'true' : undefined),
			plain : (t.attr('plain') ? t.attr('plain') == 'true' : undefined)
		};
	};
	$.fn.tabs.defaults = {
		width : 'auto',
		height : 'auto',
		plain : false,
		fit : false,
		border : true,
		tools : null,
		scrollIncrement : 100,
		scrollDuration : 400,
		onLoad : function(panel) {
		},
		onSelect : function(title) {
		},
		onBeforeClose : function(title) {
		},
		onClose : function(title) {
		},
		onAdd : function(title) {
		},
		onUpdate : function(title) {
		},
		onContextMenu : function(e, title) {
		}
	};
})(jQuery);

/**
 * layout - jQuery EasyUI
 * 
 * Licensed under the GPL:
 *   http://www.gnu.org/licenses/gpl.txt
 *
 * Copyright 2010 stworthy [ stworthy@gmail.com ] 
 * 
 * Dependencies:
 *   resizable
 *   panel
 */
(function($) {
	var resizing = false;
	function setSize(container) {
		var opts = $.data(container, 'layout').options;
		var panels = $.data(container, 'layout').panels;
		var cc = $(container);
		if (opts.fit == true) {
			var p = cc.parent();
			cc.width(p.width()).height(p.height());
		}
		var cpos = {
			top : 0,
			left : 0,
			width : cc.width(),
			height : cc.height()
		};
		function setNorthSize(pp) {
			if (pp.length == 0) {
				return;
			}
			pp.panel('resize', {
						width : cc.width(),
						height : pp.panel('options').height,
						left : 0,
						top : 0
					});
			cpos.top += pp.panel('options').height;
			cpos.height -= pp.panel('options').height;
		};
		if (isVisible(panels.expandNorth)) {
			setNorthSize(panels.expandNorth);
		} else {
			setNorthSize(panels.north);
		}
		function setSouthSize(pp) {
			if (pp.length == 0) {
				return;
			}
			pp.panel('resize', {
						width : cc.width(),
						height : pp.panel('options').height,
						left : 0,
						top : cc.height() - pp.panel('options').height
					});
			cpos.height -= pp.panel('options').height;
		};
		if (isVisible(panels.expandSouth)) {
			setSouthSize(panels.expandSouth);
		} else {
			setSouthSize(panels.south);
		}
		function setEastSize(pp) {
			if (pp.length == 0) {
				return;
			}
			pp.panel('resize', {
						width : pp.panel('options').width,
						height : cpos.height,
						left : cc.width() - pp.panel('options').width,
						top : cpos.top
					});
			cpos.width -= pp.panel('options').width;
		};
		if (isVisible(panels.expandEast)) {
			setEastSize(panels.expandEast);
		} else {
			setEastSize(panels.east);
		}
		function setWestSize(pp) {
			if (pp.length == 0) {
				return;
			}
			pp.panel('resize', {
						width : pp.panel('options').width,
						height : cpos.height,
						left : 0,
						top : cpos.top
					});
			cpos.left += pp.panel('options').width;
			cpos.width -= pp.panel('options').width;
		};
		if (isVisible(panels.expandWest)) {
			setWestSize(panels.expandWest);
		} else {
			setWestSize(panels.west);
		}
		panels.center.panel('resize', cpos);
	};
	function init(container) {
		var cc = $(container);
		if (cc[0].tagName == 'BODY') {
			$('html').css({
						height : '100%',
						overflow : 'hidden'
					});
			$('body').css({
						height : '100%',
						overflow : 'hidden',
						border : 'none'
					});
		}
		cc.addClass('layout');
		cc.css({
					margin : 0,
					padding : 0
				});
		function createPanel(dir) {
			var pp = $('>div[region=' + dir + ']', container).addClass('layout-body');
			var toolCls = null;
			if (dir == 'north') {
				toolCls = 'layout-button-up';
			} else {
				if (dir == 'south') {
					toolCls = 'layout-button-down';
				} else {
					if (dir == 'east') {
						toolCls = 'layout-button-right';
					} else {
						if (dir == 'west') {
							toolCls = 'layout-button-left';
						}
					}
				}
			}
			var cls = 'layout-panel layout-panel-' + dir;
			if (pp.attr('split') == 'true') {
				cls += ' layout-split-' + dir;
			}
			pp.panel({
						cls : cls,
						doSize : false,
						border : (pp.attr('border') == 'false' ? false : true),
						width : (pp.length ? parseInt(pp[0].style.width)
								|| pp.outerWidth() : 'auto'),
						height : (pp.length ? parseInt(pp[0].style.height)
								|| pp.outerHeight() : 'auto'),
						tools : [{
									iconCls : toolCls,
									handler : function() {
										collapsePanel(container, dir);
									}
								}]
					});
			if (pp.attr('split') == 'true') {
				var panel = pp.panel('panel');
				var handles = '';
				if (dir == 'north') {
					handles = 's';
				}
				if (dir == 'south') {
					handles = 'n';
				}
				if (dir == 'east') {
					handles = 'w';
				}
				if (dir == 'west') {
					handles = 'e';
				}
				panel.resizable({
					handles : handles,
					onStartResize : function(e) {
						resizing = true;
						if (dir == 'north' || dir == 'south') {
							var proxy = $('>div.layout-split-proxy-v', container);
						} else {
							var proxy = $('>div.layout-split-proxy-h', container);
						}
						var top = 0, left = 0, width = 0, height = 0;
						var pos = {
							display : 'block'
						};
						if (dir == 'north') {
							pos.top = parseInt(panel.css('top'))
									+ panel.outerHeight() - proxy.height();
							pos.left = parseInt(panel.css('left'));
							pos.width = panel.outerWidth();
							pos.height = proxy.height();
						} else {
							if (dir == 'south') {
								pos.top = parseInt(panel.css('top'));
								pos.left = parseInt(panel.css('left'));
								pos.width = panel.outerWidth();
								pos.height = proxy.height();
							} else {
								if (dir == 'east') {
									pos.top = parseInt(panel.css('top')) || 0;
									pos.left = parseInt(panel.css('left')) || 0;
									pos.width = proxy.width();
									pos.height = panel.outerHeight();
								} else {
									if (dir == 'west') {
										pos.top = parseInt(panel.css('top')) || 0;
										pos.left = panel.outerWidth()
												- proxy.width();
										pos.width = proxy.width();
										pos.height = panel.outerHeight();
									}
								}
							}
						}
						proxy.css(pos);
						$('<div class="layout-mask"></div>').css({
									left : 0,
									top : 0,
									width : cc.width(),
									height : cc.height()
								}).appendTo(cc);
					},
					onResize : function(e) {
						if (dir == 'north' || dir == 'south') {
							var proxy = $('>div.layout-split-proxy-v', container);
							proxy.css('top', e.pageY - $(container).offset().top
											- proxy.height() / 2);
						} else {
							var proxy = $('>div.layout-split-proxy-h', container);
							proxy.css('left', e.pageX - $(container).offset().left
											- proxy.width() / 2);
						}
						return false;
					},
					onStopResize : function() {
						$('>div.layout-split-proxy-v', container).css('display',
								'none');
						$('>div.layout-split-proxy-h', container).css('display',
								'none');
						var opts = pp.panel('options');
						opts.width = panel.outerWidth();
						opts.height = panel.outerHeight();
						opts.left = panel.css('left');
						opts.top = panel.css('top');
						pp.panel('resize');
						setSize(container);
						resizing = false;
						cc.find('>div.layout-mask').remove();
					}
				});
			}
			return pp;
		};
		$('<div class="layout-split-proxy-h"></div>').appendTo(cc);
		$('<div class="layout-split-proxy-v"></div>').appendTo(cc);
		var panels = {
			center : createPanel('center')
		};
		panels.north = createPanel('north');
		panels.south = createPanel('south');
		panels.east = createPanel('east');
		panels.west = createPanel('west');
		$(container).bind('_resize', function(e, param) {
					var opts = $.data(container, 'layout').options;
					if (opts.fit == true || param) {
						setSize(container);
					}
					return false;
				});
		return panels;
	};
	function collapsePanel(container, region) {
		var panels = $.data(container, 'layout').panels;
		var cc = $(container);
		function createExpandPanel(dir) {
			var icon;
			if (dir == 'east') {
				icon = 'layout-button-left';
			} else {
				if (dir == 'west') {
					icon = 'layout-button-right';
				} else {
					if (dir == 'north') {
						icon = 'layout-button-down';
					} else {
						if (dir == 'south') {
							icon = 'layout-button-up';
						}
					}
				}
			}
			var p = $('<div></div>').appendTo(cc).panel({
						cls : 'layout-expand',
						title : '&nbsp;',
						closed : true,
						doSize : false,
						tools : [{
									iconCls : icon,
									handler : function() {
										expandPanel(container, region);
									}
								}]
					});
			p.panel('panel').hover(function() {
						$(this).addClass('layout-expand-over');
					}, function() {
						$(this).removeClass('layout-expand-over');
					});
			return p;
		};
		if (region == 'east') {
			if (panels.east.panel('options').onBeforeCollapse.call(panels.east) == false) {
				return;
			}
			panels.center.panel('resize', {
						width : panels.center.panel('options').width
								+ panels.east.panel('options').width - 28
					});
			panels.east.panel('panel').animate({
						left : cc.width()
					}, function() {
						panels.east.panel('close');
						panels.expandEast.panel('open').panel('resize', {
									top : panels.east.panel('options').top,
									left : cc.width() - 28,
									width : 28,
									height : panels.east.panel('options').height
								});
						panels.east.panel('options').onCollapse.call(panels.east);
					});
			if (!panels.expandEast) {
				panels.expandEast = createExpandPanel('east');
				panels.expandEast.panel('panel').click(function() {
					panels.east.panel('open').panel('resize', {
								left : cc.width()
							});
					panels.east.panel('panel').animate({
								left : cc.width()
										- panels.east.panel('options').width
							});
					return false;
				});
			}
		} else {
			if (region == 'west') {
				if (panels.west.panel('options').onBeforeCollapse.call(panels.west) == false) {
					return;
				}
				panels.center.panel('resize', {
							width : panels.center.panel('options').width
									+ panels.west.panel('options').width - 28,
							left : 28
						});
				panels.west.panel('panel').animate({
							left : -panels.west.panel('options').width
						}, function() {
							panels.west.panel('close');
							panels.expandWest.panel('open').panel('resize', {
										top : panels.west.panel('options').top,
										left : 0,
										width : 28,
										height : panels.west.panel('options').height
									});
							panels.west.panel('options').onCollapse.call(panels.west);
						});
				if (!panels.expandWest) {
					panels.expandWest = createExpandPanel('west');
					panels.expandWest.panel('panel').click(function() {
								panels.west.panel('open').panel('resize', {
											left : -panels.west.panel('options').width
										});
								panels.west.panel('panel').animate({
											left : 0
										});
								return false;
							});
				}
			} else {
				if (region == 'north') {
					if (panels.north.panel('options').onBeforeCollapse
							.call(panels.north) == false) {
						return;
					}
					var hh = cc.height() - 28;
					if (isVisible(panels.expandSouth)) {
						hh -= panels.expandSouth.panel('options').height;
					} else {
						if (isVisible(panels.south)) {
							hh -= panels.south.panel('options').height;
						}
					}
					panels.center.panel('resize', {
								top : 28,
								height : hh
							});
					panels.east.panel('resize', {
								top : 28,
								height : hh
							});
					panels.west.panel('resize', {
								top : 28,
								height : hh
							});
					if (isVisible(panels.expandEast)) {
						panels.expandEast.panel('resize', {
									top : 28,
									height : hh
								});
					}
					if (isVisible(panels.expandWest)) {
						panels.expandWest.panel('resize', {
									top : 28,
									height : hh
								});
					}
					panels.north.panel('panel').animate({
								top : -panels.north.panel('options').height
							}, function() {
								panels.north.panel('close');
								panels.expandNorth.panel('open').panel('resize', {
											top : 0,
											left : 0,
											width : cc.width(),
											height : 28
										});
								panels.north.panel('options').onCollapse
										.call(panels.north);
							});
					if (!panels.expandNorth) {
						panels.expandNorth = createExpandPanel('north');
						panels.expandNorth.panel('panel').click(function() {
							panels.north.panel('open').panel('resize', {
										top : -panels.north.panel('options').height
									});
							panels.north.panel('panel').animate({
										top : 0
									});
							return false;
						});
					}
				} else {
					if (region == 'south') {
						if (panels.south.panel('options').onBeforeCollapse
								.call(panels.south) == false) {
							return;
						}
						var hh = cc.height() - 28;
						if (isVisible(panels.expandNorth)) {
							hh -= panels.expandNorth.panel('options').height;
						} else {
							if (isVisible(panels.north)) {
								hh -= panels.north.panel('options').height;
							}
						}
						panels.center.panel('resize', {
									height : hh
								});
						panels.east.panel('resize', {
									height : hh
								});
						panels.west.panel('resize', {
									height : hh
								});
						if (isVisible(panels.expandEast)) {
							panels.expandEast.panel('resize', {
										height : hh
									});
						}
						if (isVisible(panels.expandWest)) {
							panels.expandWest.panel('resize', {
										height : hh
									});
						}
						panels.south.panel('panel').animate({
									top : cc.height()
								}, function() {
									panels.south.panel('close');
									panels.expandSouth.panel('open').panel(
											'resize', {
												top : cc.height() - 28,
												left : 0,
												width : cc.width(),
												height : 28
											});
									panels.south.panel('options').onCollapse
											.call(panels.south);
								});
						if (!panels.expandSouth) {
							panels.expandSouth = createExpandPanel('south');
							panels.expandSouth.panel('panel').click(function() {
								panels.south.panel('open').panel('resize', {
											top : cc.height()
										});
								panels.south.panel('panel').animate({
									top : cc.height()
											- panels.south.panel('options').height
								});
								return false;
							});
						}
					}
				}
			}
		}
	};
	function expandPanel(container, region) {
		var panels = $.data(container, 'layout').panels;
		var cc = $(container);
		if (region == 'east' && panels.expandEast) {
			if (panels.east.panel('options').onBeforeExpand.call(panels.east) == false) {
				return;
			}
			panels.expandEast.panel('close');
			panels.east.panel('panel').stop(true, true);
			panels.east.panel('open').panel('resize', {
						left : cc.width()
					});
			panels.east.panel('panel').animate({
						left : cc.width() - panels.east.panel('options').width
					}, function() {
						setSize(container);
						panels.east.panel('options').onExpand.call(panels.east);
					});
		} else {
			if (region == 'west' && panels.expandWest) {
				if (panels.west.panel('options').onBeforeExpand.call(panels.west) == false) {
					return;
				}
				panels.expandWest.panel('close');
				panels.west.panel('panel').stop(true, true);
				panels.west.panel('open').panel('resize', {
							left : -panels.west.panel('options').width
						});
				panels.west.panel('panel').animate({
							left : 0
						}, function() {
							setSize(container);
							panels.west.panel('options').onExpand.call(panels.west);
						});
			} else {
				if (region == 'north' && panels.expandNorth) {
					if (panels.north.panel('options').onBeforeExpand
							.call(panels.north) == false) {
						return;
					}
					panels.expandNorth.panel('close');
					panels.north.panel('panel').stop(true, true);
					panels.north.panel('open').panel('resize', {
								top : -panels.north.panel('options').height
							});
					panels.north.panel('panel').animate({
								top : 0
							}, function() {
								setSize(container);
								panels.north.panel('options').onExpand
										.call(panels.north);
							});
				} else {
					if (region == 'south' && panels.expandSouth) {
						if (panels.south.panel('options').onBeforeExpand
								.call(panels.south) == false) {
							return;
						}
						panels.expandSouth.panel('close');
						panels.south.panel('panel').stop(true, true);
						panels.south.panel('open').panel('resize', {
									top : cc.height()
								});
						panels.south.panel('panel').animate({
							top : cc.height()
									- panels.south.panel('options').height
						}, function() {
							setSize(container);
							panels.south.panel('options').onExpand.call(panels.south);
						});
					}
				}
			}
		}
	};
	function bindEvents(container) {
		var panels = $.data(container, 'layout').panels;
		var cc = $(container);
		if (panels.east.length) {
			panels.east.panel('panel').bind('mouseover', 'east', collapsePanel);
		}
		if (panels.west.length) {
			panels.west.panel('panel').bind('mouseover', 'west', collapsePanel);
		}
		if (panels.north.length) {
			panels.north.panel('panel').bind('mouseover', 'north', collapsePanel);
		}
		if (panels.south.length) {
			panels.south.panel('panel').bind('mouseover', 'south', collapsePanel);
		}
		panels.center.panel('panel').bind('mouseover', 'center', collapsePanel);
		function collapsePanel(e) {
			if (resizing == true) {
				return;
			}
			if (e.data != 'east' && isVisible(panels.east) && isVisible(panels.expandEast)) {
				panels.east.panel('panel').animate({
							left : cc.width()
						}, function() {
							panels.east.panel('close');
						});
			}
			if (e.data != 'west' && isVisible(panels.west) && isVisible(panels.expandWest)) {
				panels.west.panel('panel').animate({
							left : -panels.west.panel('options').width
						}, function() {
							panels.west.panel('close');
						});
			}
			if (e.data != 'north' && isVisible(panels.north) && isVisible(panels.expandNorth)) {
				panels.north.panel('panel').animate({
							top : -panels.north.panel('options').height
						}, function() {
							panels.north.panel('close');
						});
			}
			if (e.data != 'south' && isVisible(panels.south) && isVisible(panels.expandSouth)) {
				panels.south.panel('panel').animate({
							top : cc.height()
						}, function() {
							panels.south.panel('close');
						});
			}
			return false;
		};
	};
	function isVisible(pp) {
		if (!pp) {
			return false;
		}
		if (pp.length) {
			return pp.panel('panel').is(':visible');
		} else {
			return false;
		}
	};
	$.fn.layout = function(options, param) {
		if (typeof options == 'string') {
			return $.fn.layout.methods[options](this, param);
		}
		return this.each(function() {
					var state = $.data(this, 'layout');
					if (!state) {
						var opts = $.extend({}, {
									fit : $(this).attr('fit') == 'true'
								});
						$.data(this, 'layout', {
									options : opts,
									panels : init(this)
								});
						bindEvents(this);
					}
					setSize(this);
				});
	};
	$.fn.layout.methods = {
		resize : function(jq) {
			return jq.each(function() {
						setSize(this);
					});
		},
		panel : function(jq, param) {
			return $.data(jq[0], 'layout').panels[param];
		},
		collapse : function(jq, param) {
			return jq.each(function() {
						collapsePanel(this, param);
					});
		},
		expand : function(jq, param) {
			return jq.each(function() {
						expandPanel(this, param);
					});
		}
	};
})(jQuery);

/**
 * menu - jQuery EasyUI
 * 
 * Licensed under the GPL:
 *   http://www.gnu.org/licenses/gpl.txt
 *
 * Copyright 2010 stworthy [ stworthy@gmail.com ] 
 */


/**
 * menubutton - jQuery EasyUI
 * 
 * Licensed under the GPL:
 *   http://www.gnu.org/licenses/gpl.txt
 *
 * Copyright 2010 stworthy [ stworthy@gmail.com ] 
 * 
 * Dependencies:
 *   linkbutton
 *   menu
 */

/**
 * datagrid - jQuery EasyUI
 * 
 * Licensed under the GPL:
 *   http://www.gnu.org/licenses/gpl.txt
 *
 * Copyright 2010 stworthy [ stworthy@gmail.com ] 
 * 
 * Dependencies:
 * 	resizable
 * 	linkbutton
 * 	pagination
 * 
 */





/**
 * shadow - jQuery EasyUI
 * 
 * Licensed under the GPL:
 *   http://www.gnu.org/licenses/gpl.txt
 *
 * Copyright 2009 stworthy [ stworthy@gmail.com ] 
 * 
 * options:
 * 	hidden: boolean false to show the shadow and true to hide the shadow 
 * 	fit: boolean true to fit the parent container and false not
 * 	width: integer width The width in pixels of the shadow. Default: 8
 * 
 */
(function($){
	$.fn.shadow = function(options){
		
		return this.each(function(){
			
			// wrap the element and return the jQuery object
			function wrapElem(target) {
				var wraps = [
				             '<div class="shadow">',
				             '<div class="shadow-one">',
				             '<div class="shadow-corner-a"></div>',
				             '<div class="shadow-corner-b"></div>',
				             '<div class="shadow-two">',
				             '	<div class="shadow-three">',
				             '		<div class="shadow-four">',
				             '		</div>',
				             '	</div>',
				             '</div>',
				             '</div>',
				             '</div>'
				             ];
				
				var shadow = $(wraps.join('')).insertAfter($(target));
				$(target).appendTo($('.shadow-four', shadow));
				return shadow;
			}
			
			if ($.data(this, 'shadow')) {
				$.extend($.data(this, 'shadow').options, options || {});
			} else {
				$.data(this, 'shadow', {
					options: $.extend({}, $.fn.shadow.defaults, options || {}),
					shadow: wrapElem(this),
					oldWidth: $(this).width(),	// the element old width and height
					oldHeight: $(this).height()
				});
			}
			
			if (!$.data(this, 'shadow').shadow) {
				$.data(this, 'shadow').shadow = wrapElem(this);
			}
			
			var opts = $.data(this, 'shadow').options;
			var shadow = $.data(this, 'shadow').shadow;
			
			if (opts.hidden == true) {
				$(this).insertAfter(shadow);
				shadow.remove();
				$.data(this, 'shadow').shadow = null;
				return;
			}
			
			$('.shadow-one', shadow).css({
				paddingLeft: opts.width * 2,
				paddingTop: opts.width * 2
			});
			$('.shadow-corner-a', shadow).css({
				width: opts.width * 2,
				height: opts.width * 2
			});
			$('.shadow-corner-b', shadow).css({
				width: opts.width * 2,
				height: opts.width * 2
			});
			$('.shadow-three', shadow).css({
				left: opts.width * -2,
				top: opts.width * -2
			});
			$('.shadow-four', shadow).css({
				left: opts.width,
				top: opts.width
			});
			
			if (opts.fit == true) {
				// make element and shadow fit the parent container
				
				var parent = $(shadow).parent();	// the parent container
				
				if ($.boxModel == true) {
					var delta = $(this).outerWidth(true) - $(this).width();
					$(this).css({
						width: parent.width() - 2*opts.width - delta,
						height: parent.height() - 2*opts.width - delta
					});
					$(shadow).css({
						width: parent.width(),
						height: parent.height()
					});
					$('.shadow-one', shadow).css({
						width: parent.width() - 2*opts.width,
						height: parent.height() - 2*opts.width
					});
				
				} else {
					$(this).css({
						width:'100%',
						height:'100%'
					});
					$(shadow).css({
						width: parent.width(),
						height: parent.height()
					});
					$('.shadow-one', shadow).css({
						width: parent.width(),
						height: parent.height()
					});
				}
			} else {
				// restore the element's width and height
				$(this).width($.data(this, 'shadow').oldWidth)
						.height($.data(this, 'shadow').oldHeight);
				
				$('.shadow-one', shadow).css({
					width:'100%',
					height:'100%'
				});
				
				if ($.boxModel == true) {
					$(shadow).css({
						width: $(this).outerWidth(),
						height: $(this).outerHeight()
					});
				} else {
					$(shadow).css({
						width: $.data(this, 'shadow').oldWidth + 2*opts.width,
						height: $.data(this, 'shadow').oldHeight + 2*opts.width
					});
				}
			}
			
		});
	};
	
	$.fn.shadow.defaults = {
			hidden: false,
			fit: false,
			width: 8
	};
})(jQuery);