(function ($) {
    var defaults = {
        width: '',
        height: '',
        frame: false,
        alignType: 'left',
        eventType: 'click',
        onShow: $.noop,
        onClose: $.noop
    };

    function Popup(ev, url, opts) {
        var self = this;
        self.eId = ev.id;
        self.id = "#" + ev.id;
        self.url = url;
       // self.popupId = ev.id + '-popup';
        // self.frameId = self.popupId + "-frame";
        self.popupId = 'popup-wrapper';
        self.frameId = 'popup-wrapper-frame';
        self.settings = $.extend({}, defaults, opts);
    }
    Popup.prototype = {
        _getPosition: function () {
            var self = this, $this = $(self.id), p = $this.offset();
            var set = self.settings, nw = 0;

            if (set.alignType == 'left' || set.alignType =='') {
                nw = 0;
                nh=$this.get(0).offsetHeight;
            }

            if (set.alignType == 'right') {
                nw = $this.outerWidth() - set.width;
                nh = $this.get(0).offsetHeight;
            }

            if (set.alignType == 'topright') {
                nw = $this.outerWidth() - set.width;
                nh = $this.outerHeight() - set.height-$this.get(0).offsetHeight;
            }
            if (set.alignType == 'topleft') {
                nw =0;
                nh = $this.outerHeight() - set.height - $this.get(0).offsetHeight;
            }

            return {
                left: p.left + nw,
                top: p.top + nh
            };
        },
        init: function () {
            var self = this, set = self.settings;

            $(self.id).bind(set.eventType, function () {
                self.show();
            });

            return self;
        },
        show: function () {
            var self = this, set = self.settings, $this = $(self.id);

            var popup = $("<div class='popup' />").attr("id", self.popupId)
					.appendTo("body");

            if (set.width) {
                popup.css("width", set.width+"px");
            }
            if (set.height) {
                popup.css("height", set.height + "px");
            }
            popup.css(self._getPosition());

            if (set.frame) {
                popup.append("<iframe id='" + self.frameId + "' name = '"
						+ self.frameId + "'  frameborder=\"0\" />");

            } else {
                popup.append("<div class='waiting'>loading...</div>");
            }

            popup.show();
            $.popup = self;
            $(document.body)
					.bind(
							"mousedown.popup",
							function (event) {
							    if ($(event.target).parents("#" + self.popupId).length > 0
										|| $(event.target).is(
												"#" + self.popupId)) {
							        return;
							    }
							    self.close();
							});

            if (set.frame) {
                $("#" + self.frameId).each(function () {
                    var doc = this.contentWindow.document;
                    doc.write("<html><head><style type='text/css'>");
                    doc.write(".waiting { background: url(loading.gif) 0 center no-repeat;	margin: 0 auto;	text-indent: 16px;	width:80px;}");
                    doc.write("</style><body><div class='waiting'>loading...</div></body></html>");
                    this.src = self.url;
                });
            } else {
                $.get(self.url, function (d) {
                    var popup = $("#" + self.popupId).empty().append(
							$(d).not("SCRIPT[src]"));
                    if ($.isFunction(set.onShow))
                        set.onShow(self);
                }, "html");
            }
        },
        close: function () {
            var self = this, set = self.settings, $this = $(self.id);

            if ($.isFunction(set.onClose))
                if (set.onClose(this) == false)
                    return;

            $("#" + self.popupId).remove();

            $(document.body).unbind("mousedown.popup");
            $.popup = null;
        }
    };

    $.fn.extend({
        popup: function (url, opts) {
           // $.popup = $.popup || {};
            $(this).each(function () {
                new Popup(this, url, opts).init();
                return false;
            });
        }
    });
})(jQuery);


