// JavaScript Document

$(function () {

    $('#tabs').tabs({
        onSelect: function (title) {
            var currTab = $('#tabs').tabs('getTab', title);
            var iframe = $(currTab.panel('options').content);
            var src = iframe.attr('src');
            if (src)
                $('#tabs').tabs('update', { tab: currTab, options: { content: createFrame(src)} });
        }
    });

})

/************增加Tab页****************************
*
* title:Tab页的标题
* href:链接页面
* icon:页面显示icon风格
* closable:是否有关闭图标
*
*************************************************/
function addTabLinkWay(title, href, icon, closable) {
    if ($("#ifChange").val() == "1") {
        $.messager.confirm("操作提示", "还有项目没保存!您确定放弃保存，打开新栏目吗？\n", function (data) {
            if (data) {
                $("#ifChange").val("0");

                $.ajax({
                    type: "get",
                    url: href,
                    beforeSend: function () {
                        addTab(title, "Utility/loadingDiv.htm", icon, closable);
                    }, //执行ajax前执行loading函数.直到success 
                    success: function () {
                        var currTab = $('#tabs').tabs('getTab', title);
                        $('#tabs').tabs('update', { tab: currTab, options: { content: createFrame(href)} });
                    } //成功时执行
                });
             //   addTab(title, href, icon, closable);
            }
            else
            { return false; }
        });
    }
    else {
        tabAllClose();
        $.ajax({
            type: "get",
            url: href,
            beforeSend: function () {
                addTab(title, "Utility/loadingDiv.htm", icon, closable);
            }, //执行ajax前执行loading函数.直到success 
            success: function () {
                var currTab = $('#tabs').tabs('getTab', title);
                $('#tabs').tabs('update', { tab: currTab, options: { content: createFrame(href)} });
                // addTab(title, href, icon, closable);
            } //成功时执行
        });
       // addTab(title, href, icon, closable);
    }

}

function addTab(title, href, icon, closable) {

    var tt = $('#tabs');
    if (tt.tabs('exists', title)) {//如果tab已经存在,则选中并刷新该tab          
        tt.tabs('select', title);
        updateTab({ tabTitle: title, url: href });
    }
    else {
        if ($('.tabs-inner').size() >= 8) {
            $.messager.alert("提示", "同时打开页面不能超过8个,请关闭部分页面后再继续！", "info");
            return;
        }
        else {
            tt.tabs('add', {
                title: title,
                closable: closable,
                content: createFrame(href),
                iconCls: icon || 'icon-default'
            });

        
        }

    }

}

function createFrame(href) {
    var s = "";
    if (href) {
        s = '<iframe scrolling="auto" frameborder="0"  src="' + href + '" style="width:100%;height:100%;"></iframe>';
    } else {
        s = '无内容';
    }
    return s;
}
/******************刷新tab**********************   
*  
* @param  
* example: {tabTitle:'tabTitle',url:'updateUrl'} 
* 如果tabTitle为空，则默认刷新当前选中的tab 
* 如果url为空，则默认以原来的url进行reload
* 
*************************************************/
function updateTab(param) {
    var update_tab = param.tabTitle ? $('#tabs').tabs('getTab', param.tabTitle) : $('#tabs').tabs('getSelected');
    if (update_tab && update_tab.find('iframe').length > 0) {
        var update_tab_ifram = update_tab.find('iframe')[0];
        var update_url = param.url ? param.url : update_tab_ifram.src;
        update_tab_ifram.contentWindow.location.href = update_url;
    }
}

/******************Tab双击关闭**********************/
function tabDoubleClick() {
    $(".tabs-inner").dblclick(function () {
        var subtitle = $(this).children(".tabs-closable").text();
        $('#tabs').tabs('close', subtitle);
    })

}

/******************Tab全部关闭**********************/
function tabAllClose() {
    $('.tabs-inner span').each(function (i, n) {
        var t = $(n).text();
        $('#tabs').tabs('close', t);
    });
}


/******************选择第几个Tab**********************/
function tabSelect(item) {
    $('.tabs-inner span').each(function (i, n) {
        var t = $(n).text();
        if (item == i) {
            $('#tabs').tabs('select', t);
        }
    });
}
/******************Tab右键事件**********************/


