﻿/*
Author by Czou.com
Data:2012-11
While retaining the copyright case can be modified
*/
using System;
using System.Collections.Generic;
using System.Data;
using System.Data.SqlClient;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Configuration;

using Czou.Common;
using Czou.Business;
using Czou.Business.Login;
using Czou.Business.CommonRule;

namespace Czou2012.UI.Manager.Utility
{
    public partial class linkWay : System.Web.UI.Page
    {
 	/// <summary>
	/// linkWay 的摘要说明。
	/// </summary>
    /// 
      
      
            private void Page_Load(object sender, System.EventArgs e)
            {
                // 在此处放置用户代码以初始化页面

                CommonClass.SessionEntity.ValidSession();

                int nColumnID = 0;


               

                if (Request.QueryString["nID"] != null)
                {
                    nColumnID = int.Parse(ComStringHelper.GetSafeString(Request.QueryString["nID"].ToString()));
                }
                else
                {
                    nColumnID = 0;
                }

                //获取此栏目的初始权限
                CommonClass.OperatorRight.GetColumnRight(nColumnID);
                HttpContext.Current.Session["nColumnID"]=nColumnID;

                //获取显示路径
                string strUserUrl = "#",strAdminUrl = "#",strUrl="";
                string strColumnCode="",strColumnName="";
                bool ifUserAndManager = false;

                BusLinkWayRule nBusLinkWayRule = new BusLinkWayRule();
                DataSet objDataSet = nBusLinkWayRule.UrlDataset(nColumnID);
                if (!Object.Equals(objDataSet, null))
                {                   
                    strColumnCode= objDataSet.Tables[0].Rows[0]["ColumnCode"].ToString();
                    strColumnName = objDataSet.Tables[0].Rows[0]["ColumnName"].ToString();
                    strUserUrl = objDataSet.Tables[0].Rows[0]["UserUrl"].ToString();
                    strAdminUrl = objDataSet.Tables[0].Rows[0]["AdminUrl"].ToString();

                    if (strUserUrl.Length < 5) { strUserUrl = "#"; }
                    if (strAdminUrl.Length < 5) { strAdminUrl = "#"; }

                    objDataSet.Dispose();
                 }

                if (strUserUrl.Length > 5 && strAdminUrl.Length > 5)
                { ifUserAndManager = true; }
            

                string strAction = ComStringHelper.GetSafeString(Request.QueryString["action"]);
                int intQueryString = strAdminUrl.IndexOf("?");

                if (ComStringHelper.CompareString(strAction, "CManager"))
                {
                    if (intQueryString > 0)
                    {
                        //strUrl = strAdminUrl + "&ColumnID=" + intID; 
                        strUrl = strAdminUrl + "&ColumnCode=" + strColumnCode + "&SendTime=" + System.DateTime.Now.Millisecond;                        
                    }
                    else
                    {
                        //strUrl = strAdminUrl + "&ColumnID=" + intID; 
                        strUrl = strAdminUrl + "?ColumnCode=" + strColumnCode + "&SendTime=" + System.DateTime.Now.Millisecond;
                    }
                    //是否同时有UserUrl和AdminUrl
                    if (ifUserAndManager)
                    {
                        strColumnName = strColumnName + "(管理)";
                    }                
                }
                else
                {
                    if (intQueryString > 0)
                    { strUrl = strUserUrl + "&ColumnCode=" + strColumnCode + "&SendTime=" + System.DateTime.Now.Millisecond; }
                    else
                    { strUrl = strUserUrl + "?ColumnCode=" + strColumnCode + "&SendTime=" + System.DateTime.Now.Millisecond; }      
                }


                //记录日志
                BusEventLogRule.WriteEvent("访问栏目", "打开栏目：" + strColumnName);

                //打开TAB页
                ComJavascriptHelper.InsertJs("window.top.addTabLinkWay('" + strColumnName + "','" + strUrl + "','icon icon-tab',false)");
               // ComJavascriptHelper.InsertJs("LinkWay('" + strColumnName + "','" + strUrl + "','icon icon-tab',false)");  
             }

           

    }
}