﻿/*
Author by Czou.com
Data:2012-11
While retaining the copyright case can be modified
*/
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

using Czou.Common;
using Czou.DataModel;
using Czou.Business.Login;

namespace Czou2012.UI.Manager.Utility
{
    public partial class reLogin : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {
                HttpContext.Current.Session.RemoveAll();
                //判断访问类型
                string type = Request.QueryString["type"];
                if (type == "reLogin")
                {
                    UserReLogin(); }               
                else
                { Response.Write(type); }
            }
        }


        private void UserReLogin()
        {
            HttpContext.Current.Session.RemoveAll();

            string userName = ComStringHelper.GetSafeString(Request.QueryString["userName"]);
            string password = ComStringHelper.GetSafeString(Request.QueryString["password"]);

            if (!string.IsNullOrEmpty(userName) && !string.IsNullOrEmpty(password))
            {

                int loginTimes;
                if (Request.Cookies["LoginTimesCookie"] != null)
                { loginTimes = ComStringHelper.IntParse(Request.Cookies["LoginTimesCookie"].Value.ToString()); }
                else
                { loginTimes = 0; }

                if (loginTimes >= 3)
                {
                    Response.Write("loginOverTimes");
                    Response.End();
                }

                DmAdminUser TbUser = new DmAdminUser();
                TbUser.UserName =userName;
                // TbUser.Password = ComStringHelper.MD5Encrypt(password);
                TbUser.Password =password;

                BusLoginRule nBusAdminRule = new BusLoginRule();
                string loginInfo = nBusAdminRule.LoginValidate(TbUser);

                //登录Cookie记录,查询数据库时开始计数               
                if (Request.Cookies["LoginTimesCookie"] == null)
                {
                    Response.Cookies["LoginTimesCookie"].Value = "1";
                    Response.Cookies["LoginTimesCookie"].Expires = DateTime.Now.AddDays(1);            //设置保存时间是1天
                }
                else
                {
                    loginTimes = ComStringHelper.IntParse(Request.Cookies["LoginTimesCookie"].Value.ToString());
                    loginTimes = loginTimes + 1;
                    Response.Cookies["LoginTimesCookie"].Value = loginTimes.ToString();
                    Response.Cookies["LoginTimesCookie"].Expires = DateTime.Now.AddDays(1);   //设置保存时间是1天                  
                }

                //返回登录状态信息
                if (loginInfo != "loginSuccess")
                {
                    Response.Write("loginError");
                    Response.End();
                }
                else
                {
                    //登录成功后记录登录用户名及登录状态
                    Response.Cookies["UserNameCookie"].Value = userName;
                    Response.Cookies["TrueNameSession"].Value = HttpUtility.UrlEncode(HttpContext.Current.Session["TrueNameSession"].ToString());
                    Response.Cookies["IsLoginCookie"].Value = "yes";
                    //登录成功后，登录次数归0
                    Response.Cookies["LoginTimesCookie"].Value = "0";

                    Response.Write("ok");
                    Response.End();
                }


            }
            else
            {

                Response.Write("loginUnknown");
                Response.End();
            }
        }
  
    }
}