﻿/*
Author by Czou.com
Data:2012-11
While retaining the copyright case can be modified
*/
using System;
using System.Collections;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using System.IO;
using System.Drawing;
using System.Drawing.Imaging;

namespace Czou2012.UI.Manager.Utility
{
    public partial class ValidateCode : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {

            string sCode = "";
            //清除页缓存
            Response.Buffer = true;
            Response.ExpiresAbsolute = System.DateTime.Now.AddMilliseconds(0);
            Response.Expires = 0;
            Response.CacheControl = "no-cache";
            Response.AppendHeader("Pragma", "No-Cache");

            //将图片写入内存，并以"image/png"格式输出

            MemoryStream oStream = new MemoryStream();
            try
            {
                CreateValidateCodeImage(oStream, ref sCode, 4, 90, 35, 20);

                //HttpCookie cookie = new HttpCookie("_ValidateCode");
                //cookie.Value = sCode;
                //Response.Cookies.Add(cookie);

                Session["_ValidateCode"] = sCode;
                Response.ClearContent();
                Response.ContentType = "image/Png";
                Response.BinaryWrite(oStream.ToArray());
            }
            finally
            {
                // '释放内存
                oStream.Dispose();
            }
        }
        /// <summary>
        /// 产生图形验证码。
        /// </summary>
        /// <param name="MemoryStream">内存流</param>
        /// <param name="Code">验证码</param>
        /// <param name="CodeLength">验证码长度</param>
        /// <param name="Width">验证码图片宽度</param>
        /// <param name="Height">验证码图片高度</param>
        /// <param name="FontSize">验证码图片字体大小</param>
        public void CreateValidateCodeImage(MemoryStream MemoryStream, ref string Code, int CodeLength, int Width, int Height, int FontSize)
        {
            Bitmap oBmp;
            oBmp = CreateValidateCodeImage(ref Code, CodeLength, Width, Height, FontSize);
            try
            {
                oBmp.Save(MemoryStream, ImageFormat.Png);
            }
            finally { oBmp.Dispose(); }
        }

        public Bitmap CreateValidateCodeImage(ref string Code, int CodeLength, int Width, int Height, int FontSize)
        {
            String sCode = String.Empty;
            //颜色列表，用于验证码、噪线、噪点
            Color[] oColors ={
             System.Drawing.Color.Black,
             System.Drawing.Color.Red,
             System.Drawing.Color.Blue,
             System.Drawing.Color.Green,
             System.Drawing.Color.Orange,
             System.Drawing.Color.Brown,
             System.Drawing.Color.Brown,
             System.Drawing.Color.DarkBlue
            };
            //字体列表，用于验证码
            string[] oFontNames = { "Times New Roman", "MS Mincho", "Book Antiqua", "Gungsuh", "PMingLiU", "Impact" };
            //验证码字符集，去掉一些容易混淆的字符
            char[] oCharacter = {'2','3','4','5','6','7','8','9','A','B','C','D','E','F','G','H','J','K','L','M','N','P','Q','R','S','T','U','V','W','X','Y'
  };
            Random oRnd = new Random();
            Bitmap oBmp = null;
            Graphics oGraphics = null;
            int N1 = 0;
            System.Drawing.Point oPoint1 = default(System.Drawing.Point);
            System.Drawing.Point oPoint2 = default(System.Drawing.Point);
            string sFontName = null;
            Font oFont = null;
            Color oColor = default(Color);

            //生成字符串
            for (N1 = 0; N1 <= CodeLength - 1; N1++)
            {
                sCode += oCharacter[oRnd.Next(oCharacter.Length)];
            }

            oBmp = new Bitmap(Width, Height);
            oGraphics = Graphics.FromImage(oBmp);
            oGraphics.Clear(System.Drawing.Color.White);
            try
            {
               //画噪线
               for (N1 = 0; N1 <= 1; N1++)
               {
                   
                    oPoint1.X = oRnd.Next(Width);
                    oPoint1.Y = oRnd.Next(Height);
                    oPoint2.X = oRnd.Next(Width);
                    oPoint2.Y = oRnd.Next(Height);
                    oColor = oColors[oRnd.Next(oColors.Length)];
                    oGraphics.DrawLine(new Pen(oColor), oPoint1, oPoint2);
                }

                //画字符串
                for (N1 = 0; N1 <= sCode.Length - 1; N1++)
                {
                    
                    sFontName = oFontNames[oRnd.Next(oFontNames.Length)];
                    oFont = new Font(sFontName, FontSize, FontStyle.Italic);
                    oColor = oColors[oRnd.Next(oColors.Length)];
                    oGraphics.DrawString(sCode[N1].ToString(), oFont, new SolidBrush(oColor), Convert.ToSingle(N1) * FontSize +2, Convert.ToSingle(1));

                }

                //画噪点
                for (int i = 0; i <= 6; i++)
                {
                    int x = oRnd.Next(oBmp.Width);
                    int y = oRnd.Next(oBmp.Height);
                    Color clr = oColors[oRnd.Next(oColors.Length)];
                    oBmp.SetPixel(x, y, clr);
                }

               //画外框
               // oGraphics.DrawRectangle(new Pen(System.Drawing.Color.Blue), 0, 0,84, 34);
                


                Code = sCode;
                return oBmp;
            }
            finally
            {
                oGraphics.Dispose();
            }


        }
    }
}