﻿<%@ WebHandler Language="C#" Class="PreviewPage"%>
using System;
using System.Web;
using System.Web.SessionState;

public class PreviewPage : IHttpHandler, IRequiresSessionState
{
    public void ProcessRequest(HttpContext context)
    {
        if (context.Session["adminserveraccountid"] == null || (int)context.Session["adminserveraccountid"] != 10001)
        {
            context.Response.Write("没有权限");
            return;
        }

        string applicationPath = null;
        if (context.Request.QueryString["applicationpath"] != null)
        {
            applicationPath = context.Request.QueryString["applicationpath"];
        }
        else if (context.Session["previewapplicationpath"] != null)
        {
            applicationPath = context.Session["previewapplicationpath"].ToString();
        }
        else
        {
            context.Response.Write("调试已过期,请重新点调试按钮");
            return;
        }
        context.Session["previewapplicationpath"] = applicationPath;
        string templatePath = applicationPath + "app_data/template/";
        HaiLi.CMSBSDevelop.Web.PreviewPage ui = new HaiLi.CMSBSDevelop.Web.PreviewPage(applicationPath, templatePath);
    }

    public bool IsReusable
    {
        get
        {
            return true;
        }
    }
}