﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;

public partial class _Default : System.Web.UI.Page
{
    XabaraCom xc = new XabaraCom();

    protected void Page_Load(object sender, EventArgs e)
    {
        dbDataFunction db = new dbDataFunction();
        xabaraAD ad = new xabaraAD();
        XabaraClass xClass = new XabaraClass();
        webPublic wp = new webPublic();

        this.Page.Title = xc.readXmlData("xabara.config", "webName") + xc.readXmlData("xabara.config", "titleMeta");

        if (!IsPostBack)
        {
            widthAD.ClassID = "62|680|250";  //广告参数
            ad9601.Text = ad.getAdCode(65, 0, 0, 1, 0, true, "");
            ad9602.Text = ad.getAdCode(66, 0, 0, 1, 0, true, "");

            DataTable dt;

            //分块最新商品读取
            dt = db.getDataTable("SELECT Tid,TreeName,ids FROM newstree WHERE TreeID=0 AND TreeType='taobaoke' ORDER BY listID ASC,Tid ASC");
            int count = dt.Rows.Count;
            for (int i = 0; i < count; i++)
            {
                string Tid = dt.Rows[i]["Tid"].ToString().Trim();
                string ids = dt.Rows[i]["ids"].ToString().Trim();
                string divCss = "divLeft";
                if ((i + 1) % 2 == 1)
                {
                    ppHtm.Text += "<div class=\"divWidth\">";
                }
                else
                {
                    divCss = "divRight";
                }

                ppHtm.Text += "<div class=\"" + divCss + "\" style=\"width:476px;\">";
                ppHtm.Text += "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr>";
                ppHtm.Text += "<td style=\"width:233px;\">";
                ppHtm.Text += "<ul><li class=\"tittle333\">" + dt.Rows[i]["TreeName"].ToString().Trim() + "</li><li class=\"height5px\"></li><li class=\"divHuiLine\" style=\"padding:5px;\">";
                ppHtm.Text += "<table cellspacing=\"2\" cellpadding=\"2\" border=\"0\">";

                DataTable dtPP = db.getDataTable(this.sql(ids, "volume", Tid));
                for (int pp = 0; pp < dtPP.Rows.Count; pp++)
                {
                    if ((pp + 1) % 2 == 1)
                    {
                        ppHtm.Text += "<tr>";
                    }
                    string title = dtPP.Rows[pp]["title"].ToString().Trim();
                    ppHtm.Text += "<td><a href=\"/show/" + dtPP.Rows[pp]["num_iid"].ToString().Trim() + ".htm\" target=\"_blank\" title=\"" + title + "\"><img src=\"" + dtPP.Rows[pp]["pic_url"].ToString().Trim() + "_b.jpg\" id=\"imgshow\" style=\"width:105px; height:105px;\" alt=\"" + title + "\" title=\"" + title + "\" /></a></td>";
                    if ((pp + 1) % 2 == 0)
                    {
                        ppHtm.Text += "</tr>";
                    }
                }
                dtPP.Dispose();

                ppHtm.Text += "</table>";
                ppHtm.Text += "</li></ul>";
                ppHtm.Text += "</td>";
                ppHtm.Text += "<td style=\"width:10px;\"></td>";
                ppHtm.Text += "<td style=\"width:233px;\">";
                ppHtm.Text += "<ul><li style=\"height:10px; font-size:0px;\"></li><li style=\"height:28px; line-height:28px; text-align:right;\"><a href=\"" + Tid + "-0-0-0.htm\" target=\"_blank\">更多 >></a></li><li class=\"height5px\"></li><li class=\"divHuiLine\" style=\"padding:5px;\">";
                ppHtm.Text += "<table cellspacing=\"2\" cellpadding=\"2\" border=\"0\"><tr>";

                dtPP = db.getDataTable(this.sql(ids, "commission", Tid));
                for (int pp = 0; pp < dtPP.Rows.Count; pp++)
                {
                    if ((pp + 1) % 2 == 1)
                    {
                        ppHtm.Text += "<tr>";
                    }
                    string title = dtPP.Rows[pp]["title"].ToString().Trim();
                    ppHtm.Text += "<td><a href=\"/show/" + dtPP.Rows[pp]["num_iid"].ToString().Trim() + ".htm\" target=\"_blank\" title=\"" + title + "\"><img src=\"" + dtPP.Rows[pp]["pic_url"].ToString().Trim() + "_b.jpg\" id=\"imgshow\" style=\"width:105px; height:105px;\" alt=\"" + title + "\" title=\"" + title + "\" /></a></td>";
                    if ((pp + 1) % 2 == 0)
                    {
                        ppHtm.Text += "</tr>";
                    }
                }
                dtPP.Dispose();

                ppHtm.Text += "</tr></table>";
                ppHtm.Text += "</li></ul>";
                ppHtm.Text += "</td></tr></table>";
                ppHtm.Text += "</div>";

                if ((i + 1) % 2 == 0)
                {
                    ppHtm.Text += "</div>";
                    if (i < count - 1)
                    {
                        ppHtm.Text += "<div class=\"height10px\"></div><div class=\"divWidth\"><div style=\"height:20px; background-image:url('images/line.gif'); background-repeat:repeat-x; background-position:center;\"></div></div>";
                    }
                }
            }
            dt.Dispose();

            cheapShop.DataSource = db.getDataTable("select * from taobaoke where title like '%品牌特卖%' and isBad=0 order by volume DESC,commission DESC LIMIT 0,8");
            cheapShop.DataBind();
            cheapShop.Dispose();

            hotRepeater.DataSource = db.getDataTable("select * from taobaoke where isGood=1 and isBad=0 and volume>500 and price>100 order by RAND() LIMIT 0,40");
            hotRepeater.DataBind();
            hotRepeater.Dispose();

            xc.webMeta(this.Page, xc.readXmlData("xabara.config", "KeyWord"), xc.readXmlData("xabara.config", "metaStr"));

            //域名跳转
            ClientScriptManager cs = Page.ClientScript;
            cs.RegisterStartupScript(this.GetType(), "domainUrl", "<script type=\"text/javascript\">try {var s_domain = location.host;var js_path = \"" + Request.Url.Host + "\";if (s_domain != js_path) {top.location.href = \"http://\" + js_path;}}catch (e) { }</script>");
        }
    }

    private string sql(string cidStr, string orderBy, string Tid)
    {
        string str = string.Empty;
        string ifStr = string.Empty;

        if (cidStr.IndexOf(",") > 0)
        {
            string[] ids = cidStr.Split(new char[] { ',' });
            for (int c = 0; c <= ids.GetUpperBound(0); c++)
            {
                ifStr += "( select num_iid,title,pic_url,price,click_url,commission,volume from taobaoke where isGood=1 and classID=" + ids[c].ToString().Trim() + " order by " + orderBy + " DESC LIMIT 0,2 ) union ";
            }
        }
        else
        {
            ifStr += "select num_iid,title,pic_url,price,click_url,commission,volume from taobaoke where isGood=1 and classID=" + Tid + " order by " + orderBy + " DESC LIMIT 0,4 ";
        }
        ifStr = "(" + ifStr.Substring(0, ifStr.Length - 6) + ") as news";
        str = "select * from " + ifStr + " order by " + orderBy + " DESC Limit 0,4";

        return str;
    }

    public string cut(string str, int num)
    {
        str = xc.SafeHtml(str);
        str = str.Replace("【", "");
        str = str.Replace("】", "");
        str = str.Replace("品牌特卖", "");
        str = str.Replace("不参加满减", "");
        str = str.Trim();
        return xc.CutWord(str, num);
    }
}