﻿<%@  Language="C#" AutoEventWireup="true" CodeFile="widthAD.ascx.cs" Inherits="ad_widthAD" %>
<style type="text/css">
    .containerAD .ad
    {
        margin-bottom: 0px;
        width: <%=adW%>px;
        height: <%=adH%>px;
        overflow: hidden;
        position: relative;
    }
    .containerAD .slider, .containerAD .num
    {
        position: absolute;
    }
    .containerAD .slider li
    {
        list-style: none;
        display: inline;
    }
    .containerAD .slider img
    {
        width: <%=adW%>px;
        height: <%=adH%>px;
        display: block;
    }
    .containerAD .num
    {
        right: 5px;
        bottom: 5px;
    }
    .containerAD .num li
    {
        float: left;
        color: #FF7300;
        text-align: center;
        line-height: 16px;
        width: 16px;
        height: 16px;
        font-family: arial;
        font-size: 11px;
        cursor: pointer;
        overflow: hidden;
        margin: 2px 1px;
        border: 1px solid #FF7300;
        background-color: #fff;
    }
    .containerAD .num li.on
    {
        color: #fff;
        line-height: 18px;
        width: 18px;
        height: 18px;
        font-size: 14px;
        margin: 0 1px;
        border: 0;
        background-color: #FF7300;
        font-weight: bold;
    }
</style>

<script type="text/javascript">
    $(function () {
        var len = $(".num > li").length;
        var index = 0;
        var adTimer;
        $(".num li").mouseover(function () {
            index = $(".num li").index(this);
            showImg(index);
        }).eq(0).mouseover();
        //滑入 停止动画，滑出开始动画.
        $('.ad').hover(function () {
            clearInterval(adTimer);
        }, function () {
            adTimer = setInterval(function () {
                showImg(index)
                index++;
                if (index == len) { index = 0; }
            }, 3000);
        }).trigger("mouseleave");
    })

    // 通过控制top ，来显示不同的幻灯片
    function showImg(index) {
        var adHeight = $(".containerAD .ad").height();
        $(".slider").stop(true, false).animate({ top: -adHeight * index }, <%=adW%>);
        $(".num li").removeClass("on")
			.eq(index).addClass("on");
    }
</script>

<div class="containerAD">
    <div class="ad">
        <ul class="slider" id="idSlider">
            <asp:Literal ID="divImg" runat="server"></asp:Literal>
        </ul>
        <ul class="num" id="idNum">
            <asp:Literal ID="divCount" runat="server"></asp:Literal>
        </ul>
    </div>
</div>