/*Table structure for table `adminuser` */

DROP TABLE IF EXISTS `adminuser`;

CREATE TABLE `adminuser` (
  `Uid` bigint(20) NOT NULL AUTO_INCREMENT,
  `UserId` varchar(20) NOT NULL,
  `classID` bigint(10) NOT NULL,
  `UserName` varchar(20) NOT NULL,
  `userEmail` varchar(100) DEFAULT NULL,
  `userTel` varchar(20) DEFAULT NULL,
  `userMobile` varchar(20) DEFAULT NULL,
  `userQQ` varchar(20) DEFAULT NULL,
  `UserAdmin` varchar(200) DEFAULT NULL,
  `UserPW` varchar(40) NOT NULL,
  `SessionError` varchar(40) NOT NULL,
  `loginFlag` int(2) NOT NULL,
  `LoginNum` bigint(10) NOT NULL,
  `RegDate` datetime NOT NULL,
  `LoginDate` datetime NOT NULL,
  `LoginIP` varchar(50) NOT NULL,
  PRIMARY KEY (`Uid`),
  KEY `indexs` (`classID`,`UserPW`,`SessionError`,`UserId`,`loginFlag`,`UserAdmin`)
) CHARSET=utf8;

/*Table structure for table `ads` */

DROP TABLE IF EXISTS `ads`;

CREATE TABLE `ads` (
  `aID` bigint(20) NOT NULL AUTO_INCREMENT,
  `classID` bigint(20) NOT NULL,
  `adW` int(10) DEFAULT NULL,
  `adH` int(10) DEFAULT NULL,
  `adImg` varchar(30) DEFAULT NULL,
  `adHttp` varchar(255) DEFAULT NULL,
  `adCode` text NOT NULL,
  `starDate` datetime NOT NULL,
  `stopDate` datetime NOT NULL,
  `postDate` datetime NOT NULL,
  `postIP` varchar(50) NOT NULL,
  `adminID` varchar(30) NOT NULL,
  PRIMARY KEY (`aID`),
  KEY `indexs` (`classID`,`adW`,`adH`,`starDate`,`stopDate`)
) CHARSET=utf8;

/*Table structure for table `classadmin` */

DROP TABLE IF EXISTS `classadmin`;

CREATE TABLE `classadmin` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `listClass` varchar(50) NOT NULL,
  `listID` bigint(10) NOT NULL,
  `className` varchar(50) NOT NULL,
  `classCode` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id` (`id`)
) CHARSET=utf8;

/*Table structure for table `keywordid` */

DROP TABLE IF EXISTS `keywordid`;

CREATE TABLE `keywordid` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `treeID` bigint(20) NOT NULL,
  `listID` int(11) NOT NULL,
  `wordName` char(20) NOT NULL,
  `keywords` char(20) NOT NULL,
  `isTmall` char(5) NOT NULL,
  `useType` char(5) NOT NULL,
  `startPrice` int(11) NOT NULL,
  `endPrice` int(11) NOT NULL,
  `isBad` int(2) NOT NULL,
  `updateDate` datetime NOT NULL,
  `postID` char(50) NOT NULL,
  `postDate` datetime NOT NULL,
  `postIP` char(50) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `indexof` (`treeID`,`listID`,`keywords`,`updateDate`,`id`,`useType`,`isBad`)
) CHARSET=utf8;

/*Table structure for table `loglogin` */

DROP TABLE IF EXISTS `loglogin`;

CREATE TABLE `loglogin` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `userID` varchar(50) NOT NULL,
  `userType` varchar(20) NOT NULL,
  `loginIP` varchar(50) NOT NULL,
  `loginDate` datetime NOT NULL,
  `exeTitle` varchar(255) NOT NULL,
  `exeUrl` text,
  PRIMARY KEY (`id`),
  KEY `indexs` (`userID`,`userType`)
) CHARSET=utf8;

/*Table structure for table `newstree` */

DROP TABLE IF EXISTS `newstree`;

CREATE TABLE `newstree` (
  `Tid` bigint(20) NOT NULL AUTO_INCREMENT,
  `TreeID` bigint(20) NOT NULL,
  `ListID` int(10) NOT NULL,
  `TidNums` int(10) NOT NULL,
  `idLayerStr` varchar(1000) DEFAULT NULL,
  `ids` text,
  `TreeName` varchar(50) NOT NULL,
  `treeNameTxt` varchar(100) DEFAULT NULL,
  `TreeNameImg` varchar(50) DEFAULT NULL,
  `TreeUrl` varchar(100) DEFAULT NULL,
  `TreeType` varchar(10) NOT NULL,
  `treeAdmin` int(10) NOT NULL,
  `treeDel` int(10) NOT NULL,
  `PostDate` datetime NOT NULL,
  `AdminIP` varchar(50) NOT NULL,
  `AdminID` varchar(20) NOT NULL,
  PRIMARY KEY (`Tid`),
  KEY `NewIndex` (`TreeID`,`ListID`,`idLayerStr`(255),`TreeType`,`PostDate`)
) CHARSET=utf8;

/*Table structure for table `taobaoke` */

DROP TABLE IF EXISTS `taobaoke`;

CREATE TABLE `taobaoke` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `classID` bigint(20) NOT NULL,
  `ppID` bigint(20) NOT NULL,
  `wordID` bigint(20) NOT NULL,
  `num_iid` varchar(50) NOT NULL,
  `title` varchar(255) NOT NULL,
  `nick` varchar(100) DEFAULT NULL,
  `pic_url` varchar(200) DEFAULT NULL,
  `price` double NOT NULL,
  `click_url` varchar(1000) DEFAULT NULL,
  `commission` double NOT NULL,
  `commission_rate` double DEFAULT NULL,
  `commission_num` double DEFAULT NULL,
  `commission_volume` double DEFAULT NULL,
  `shop_click_url` varchar(1000) DEFAULT NULL,
  `seller_credit_score` int(11) DEFAULT NULL,
  `item_location` varchar(50) NOT NULL,
  `volume` bigint(20) NOT NULL,
  `isGood` int(10) NOT NULL,
  `updateDate` datetime NOT NULL,
  `isBad` int(11) NOT NULL,
  `postID` varchar(50) NOT NULL,
  `postDate` datetime NOT NULL,
  `postIP` varchar(50) NOT NULL,
  PRIMARY KEY (`id`,`classID`,`ppID`,`wordID`,`num_iid`,`title`,`price`,`commission`,`volume`,`isGood`,`updateDate`,`isBad`),
  KEY `NewIndex` (`classID`,`num_iid`,`title`,`price`,`volume`,`isGood`,`updateDate`,`commission`,`id`,`wordID`,`isBad`,`ppID`)
) CHARSET=utf8;