﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.IO;
using MySql.Data.MySqlClient;

public partial class setup_step02 : System.Web.UI.Page
{
    XabaraCom xc = new XabaraCom();

    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            ServerOS.Text = Environment.OSVersion.ToString();
            ServerOSVer.Text = xc.os(Environment.OSVersion.ToString());
            ServerSoft.Text = Request.ServerVariables["SERVER_SOFTWARE"];
            netVer.Text = Environment.Version.ToString();
        }
    }

    protected void step_Click(object sender, EventArgs e)
    {
        string connXml = xc.readXmlData("xabara.config", "ConnStr");
        if (!string.IsNullOrEmpty(connXml as string))
        {
            Response.Redirect("step03.aspx", true);
        }
        else
        {
            string connStr = "Data Source=" + IP.Text.Trim() + "; Database=" + sqlName.Text.Trim() + "; User Id=" + UserID.Text.Trim() + "; Password=" + passWord.Text.Trim() + "; pooling=true; CharSet=utf8; port=" + sqlPort.Text.Trim() + "; Allow Zero Datetime=true";

            MySqlConnection conn = new MySqlConnection(connStr);

            try
            {
                conn.Open();
                xc.xmlSave("ConnStr", connStr);                

                Response.Redirect("step03.aspx", true);
            }
            catch
            {
                xc.divError("数据库连接", "连接失败，xabara.config 文件是否有写入权限！", 350, 150, "", "");
            }
        }
    }
}