﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Xml;
using System.IO;
using System.Data;

public partial class WebXabara_frame_otherSet : System.Web.UI.Page
{
    XabaraCom xc = new XabaraCom();
    dbDataFunction db = new dbDataFunction();
    public string soft = "";

    protected void Page_Load(object sender, EventArgs e)
    {
        xc.CheckAdminLogin("xabaraCOM");
        if (!IsPostBack)
        {
            EncryptDecrypt ed = new EncryptDecrypt();
            soft = ed.softName();
            string[] softName = soft.Split(new char[] { '_' });
            soft = softName[0];

            string pathFlie = Server.MapPath("/xabara.config");
            XmlDocument xmlDoc = new XmlDocument();
            xmlDoc.Load(pathFlie);

            taobaoKeAppKey.Text = xmlDoc.DocumentElement.SelectSingleNode("//add[@key='taobaoKeAppKey']").Attributes["value"].Value;
            taobaoKeAppSecret.Text = xmlDoc.DocumentElement.SelectSingleNode("//add[@key='taobaoKeAppSecret']").Attributes["value"].Value;
            taobaoKeAlimamaID.Text = xmlDoc.DocumentElement.SelectSingleNode("//add[@key='taobaoKeAlimamaID']").Attributes["value"].Value;
            hotSearch.Text = xmlDoc.DocumentElement.SelectSingleNode("//add[@key='hotSearch']").Attributes["value"].Value;
            aliPayID.Text = xmlDoc.DocumentElement.SelectSingleNode("//add[@key='aliPayID']").Attributes["value"].Value;
            aliPayKey.Text = xmlDoc.DocumentElement.SelectSingleNode("//add[@key='aliPayKey']").Attributes["value"].Value;
            aliPayEmail.Text = xmlDoc.DocumentElement.SelectSingleNode("//add[@key='aliPayEmail']").Attributes["value"].Value;
            aliPayFee.Text = xmlDoc.DocumentElement.SelectSingleNode("//add[@key='alipayFee']").Attributes["value"].Value;
            adPrice.Text = xmlDoc.DocumentElement.SelectSingleNode("//add[@key='adPrice']").Attributes["value"].Value;

            xmlDoc = null;

            FormCheck fc = new FormCheck();
            aliPayRegularExp.ValidationExpression = fc.RegExpressionValidator("double", 0, 0, false);
            aliPayRegularExp.ErrorMessage = fc.RegExpressionValidator("double", 0, 0, true);
            adRegularExp.ValidationExpression = fc.RegExpressionValidator("double", 0, 0, false);
            adRegularExp.ErrorMessage = fc.RegExpressionValidator("double", 0, 0, true);
        }
    }

    protected void sysSet_Click(object sender, EventArgs e)
    {
        string pathFlie = Server.MapPath("/xabara.config");
        XmlDocument xmlDoc = new XmlDocument();
        xmlDoc.Load(pathFlie);

        XmlNodeList topM = xmlDoc.DocumentElement.ChildNodes; //得到顶层节点列表
        foreach (XmlElement xElement in topM)
        {
            if (xElement.Name == "appSettings") //判断读取子层
            {
                XmlNodeList nodelist = xElement.ChildNodes; //得到该节点的子节点               
                if (nodelist.Count > 0)
                {
                    foreach (XmlNode xnode in nodelist)
                    {
                        XmlElement xe = (XmlElement)xnode;

                        string xeStr = xe.Attributes["value"].Value;
                        switch (xe.Attributes["key"].Value) //修改值
                        {
                            case "taobaoKeAppKey":
                                xeStr = taobaoKeAppKey.Text.Trim();
                                break;
                            case "taobaoKeAppSecret":
                                xeStr = taobaoKeAppSecret.Text.Trim();
                                break;
                            case "taobaoKeAlimamaID":
                                xeStr = taobaoKeAlimamaID.Text.Trim();
                                break;
                            case "hotSearch":
                                xeStr = hotSearch.Text.Trim();
                                break;
                            case "aliPayID":
                                xeStr = aliPayID.Text.Trim();
                                break;
                            case "aliPayKey":
                                xeStr = aliPayKey.Text.Trim();
                                break;
                            case "aliPayEmail":
                                xeStr = aliPayEmail.Text.Trim();
                                break;
                            case "alipayFee":
                                xeStr = aliPayFee.Text.Trim();
                                break;
                            case "adPrice":
                                {
                                    xeStr = adPrice.Text.Trim();
                                }
                                break;
                        }
                        xe.Attributes["value"].Value = xeStr;
                    }
                }
            }
        }

        xmlDoc.Save(pathFlie);
        xmlDoc = null;

        xc.insertMyLog(xc.adminID, "admin", "网店参数设置");

        Response.Redirect("otherSet.aspx", true);
    }
}
