﻿var ScrollAcross = function(ulId,liTag,leftBtnId,rightBtnId){

	this.ul = null;
	this.lis = null;
	this.leftBtn = null;
	this.rightBtn = null;
	
	this.isScroll = false;
	
	this.init(ulId,liTag,leftBtnId,rightBtnId);
}
ScrollAcross.prototype = {

	init : function(ulId,liTag,leftBtnId,rightBtnId){
	
		this.ul = Y.one("#"+ulId);
		this.lis = Y.get("#"+ulId+" "+liTag);
		this.leftBtn = Y.one("#"+leftBtnId);
		this.rightBtn =Y.one("#"+rightBtnId);
		var _len = this.lis.length /2;
		if( _len<1 || _len < this.nowScroll)return;
		
		var scrollDis = this.lis[0].offsetWidth,li,This = this;
		scrollDis = scrollDis /2;
		//alert(_len + "|" + scrollDis);
		this.leftBtn.onclick = function(){
			This.scroll('left',scrollDis);
		}
		this.rightBtn.onclick = function(){
			This.scroll('right',scrollDis);
		}
		
	},
	scroll : function(dir,scrollDis){
		
		var This = this,cut =30;
		
		if(this.isScroll)return false;
		
		this.isScroll = true;
		
		var li = null;
		
		if(dir == 'left')li = this.lis.shift();
		else{
			
			li = this.ul.removeChild(this.lis.pop());
			
			li.style.marginLeft =-1 * scrollDis + 'px';
			
			this.ul.insertBefore(li,this.lis[0]);
		}
		
		var process = function(){
			
			li.style.marginLeft = parseInt(li.style.marginLeft?li.style.marginLeft:'0',10) + (dir=='left'?-1*cut:cut) + 'px';
			
			var left = parseInt(li.style.marginLeft,10);
			
			if((dir=='left' && left*-1 < scrollDis) || (dir=='right' && left < 0)){
				setTimeout(process,20);
			}
			else This.callback(li,dir);
		}
		process();
	},
	callback : function(li,dir){
	
		li.style.marginLeft = '0px';
		if(dir == 'left'){
			var temp = this.ul.removeChild(li);
			
			this.ul.appendChild(temp);
			
			this.lis.push(temp);
		}
		else{
			this.lis = [li].concat(this.lis);
		}
		
		this.isScroll = false;
	}
}