﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class Admin_AddRole:System.Web.UI.Page
{
	protected void Page_Load(object sender,EventArgs e)
	{
		if(Session[SystemConst.USERIDKEY] == null)
		{
			Response.Write(SysOperation.OpenDialog(
				"你还没有登录，请先登录..."));
			Response.Write("<script>history.back()<script>");
			return;
		}
	}
	protected void Btn_Command(object sender,CommandEventArgs e)
	{
		string sCmdName = e.CommandName.ToLower();
		if(SysOperation.StringNullChecked(sCmdName) == false)
		{
			return;
		}
		switch(sCmdName)
		{
			case "add":
				{
					AddRole();
					break;
				}
			case "set":
				{
					SetRoleAuthenticate();
					break;
				}
			case "return":
				{
					Response.Redirect("~/Admin/RoleManage.aspx");
					break;
				}
			default: break;
		}
	}

	private void AddRole()
	{
		IRole role = new Role();
		try
		{
			int nRoleID = role.AddRole(Name.Text.Trim());
			if(nRoleID > 0)
			{
				btnSetAuth.Enabled = true;
				ViewState[SystemConst.ROLEIDKEY] = nRoleID.ToString();
				Response.Write(SysOperation.OpenDialog(
					SysInfomation.ADD_DATA_SUCESS));
			}			
		}
		catch(Exception ex)
		{
			Server.Transfer(SysOperation.FormatErrorPageUrl(
				SysOperation.FormatErrorUrl(Request.RawUrl),ex.Message),
				false);
		}
	}

	private void SetRoleAuthenticate()
	{
		if(ViewState[SystemConst.ROLEIDKEY] != null)
		{
			Response.Redirect("~/Admin/RoleAuthenticate.aspx?RoleID="
				+ ViewState[SystemConst.ROLEIDKEY].ToString());
		}
	}
}
