﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;

public partial class Admin_AddUser:System.Web.UI.Page
{
	protected void Page_Load(object sender,EventArgs e)
	{
		if(Session[SystemConst.USERIDKEY] == null)
		{
			Response.Write(SysOperation.OpenDialog(
				"你还没有登录，请先登录..."));
			Response.Write("<script>history.back()<script>");
			return;
		}
		if(!Page.IsPostBack)
		{
			BindRoleData();
		}
	}
	private void BindRoleData()
	{
		IRole role = new Role();
		SqlDataReader dr = role.GetRoles();

		RoleList.DataSource = dr;
		RoleList.DataTextField = "Name";
		RoleList.DataValueField = "ID";
		RoleList.DataBind();

		dr.Close();
	}

	protected void Btn_Command(object sender,CommandEventArgs e)
	{
		string sCmdName = e.CommandName.ToLower();
		if(SysOperation.StringNullChecked(sCmdName) == false)
		{
			return;
		}
		switch(sCmdName)
		{
			case "add":
				{
					AddUser();
					break;
				}			
			case "return":
				{
					Response.Redirect("~/Admin/UserManage.aspx");
					break;
				}
			default: break;
		}
	}

	private void AddUser()
	{
		IUser user = new User();
		try
		{
			if(user.AddUser(tbUserName.Text.Trim(),tbPassword.Text.Trim(),
				tbEmail.Text.Trim(),2) > 0)
			{
				Response.Write(SysOperation.OpenDialog(
					SysInfomation.ADD_DATA_SUCESS));
			}			
		}
		catch(Exception ex)
		{
			Server.Transfer(SysOperation.FormatErrorPageUrl(
				SysOperation.FormatErrorUrl(Request.RawUrl),ex.Message),
				false);
		}
	}
}
