﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;

public partial class Admin_RoleAuthenticate:System.Web.UI.Page
{
	int nRoleID = -1;
	protected void Page_Load(object sender,EventArgs e)
	{
		if(Session[SystemConst.USERIDKEY] == null)
		{
			Response.Write(SysOperation.OpenDialog(
				"你还没有登录，请先登录..."));
			Response.Write("<script>history.back()<script>");
			return;
		}
		CatalogView.Attributes.Add("OnCheck","TreeView_OnCheck(CatalogView)");
		if(Request.Params["RoleID"] != null)
		{
			if(Int32.TryParse(Request.Params["RoleID"].ToString(),out nRoleID) == false)
			{
				return;
			}
		}
		if(!Page.IsPostBack)
		{
			InitCatalogView();
			if(nRoleID > -1)
			{
				BindRoleData(nRoleID);
			}
		}
		//btnSetAuth.Enabled = nRoleID > -1 ? true : false;
		btnSetAuth.Enabled = true;
	}
	private void BindRoleData(int nRoleID)
	{
		IRole role = new Role();
		SqlDataReader dr = role.GetSingleRole(nRoleID);
		if(dr.Read())
		{
			lbName.Text = dr["Name"].ToString();
		}
		dr.Close();
	}	
	private void InitCatalogView()
	{
		ICatalog cata = new Catalog();
		cata.BindCatalogTreeView(CatalogView,true,"-1");
	}

	protected void Btn_Command(object sender,CommandEventArgs e)
	{
		string sCmdName = e.CommandName.ToLower();
		if(SysOperation.StringNullChecked(sCmdName) == false)
		{
			return;
		}
		switch(sCmdName)
		{
			case "set":
				{
					SetRoleAuthenticate();
					break;
				}
			case "return":
				{
					Response.Redirect("~/Admin/RoleManage.aspx");
					break;
				}
			default: break;
		}
	}

	private void SetRoleAuthenticate()
	{
		IRole role = new Role();
		try
		{
			foreach(TreeNode node in CatalogView.CheckedNodes)
			{
				Response.Write(node.Text + "<br>");
			}
			//role.AddRoleAuthenticate(nRoleID,0,true);

			Response.Write(SysOperation.OpenDialog(
				SysInfomation.UPDATE_DATA_SUCESS));
		}
		catch(Exception ex)
		{
			Server.Transfer(SysOperation.FormatErrorPageUrl(
				SysOperation.FormatErrorUrl(Request.RawUrl),ex.Message),
				false);
		}
	}
	protected void CatalogView_TreeNodeCheckChanged(object sender,TreeNodeEventArgs e)
	{
		CheckedChildNode(e.Node,e.Node.Checked);
		TreeNode node = e.Node;
		//node.SelectAction = TreeNodeSelectAction.
	}

	private void CheckedChildNode(TreeNode parentNode,bool bChecked)
	{
		foreach(TreeNode node in parentNode.ChildNodes)
		{
			if(node.ShowCheckBox.HasValue)
			{
				node.Checked = bChecked;
			}
			CheckedChildNode(node,bChecked);
		}
	}
	protected void CatalogView_SelectedNodeChanged(object sender,EventArgs e)
	{
		CheckedChildNode(CatalogView.SelectedNode,true);
	}
	protected void Button1_Click(object sender,EventArgs e)
	{
		///
	}
}
