﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;

public partial class Admin_RoleManage:System.Web.UI.Page
{
	protected void Page_Load(object sender,EventArgs e)
	{
		if(Session[SystemConst.USERIDKEY] == null)
		{
			Response.Write(SysOperation.OpenDialog(
				"你还没有登录，请先登录..."));
			Response.Write("<script>history.back()<script>");
			return;
		}
		if(!Page.IsPostBack)
		{
			BindRoleData();
		}
		ibtDelete.Enabled = ibtUpdate.Enabled = ibtSetAuth.Enabled
			= RoleList.Items.Count > 0 ? true : false;
		ibtDelete.Attributes.Add("onclick","return confirm('你确定要删除所选择的数据吗?');");		
	}
	private void BindRoleData()
	{
		IRole role = new Role();
		SqlDataReader dr = role.GetRoles();

		RoleList.DataSource = dr;
		RoleList.DataTextField = "Name";
		RoleList.DataValueField = "ID";
		RoleList.DataBind();

		dr.Close();
	}

	protected void Btn_Command(object sender,CommandEventArgs e)
	{
		string sCmdName = e.CommandName.ToLower();
		if(SysOperation.StringNullChecked(sCmdName) == false)
		{
			return;
		}
		switch(sCmdName)
		{
			case "add":
				{
					Response.Redirect("~/Admin/AddRole.aspx");
					break;
				}
			case "update":
				{
					if(RoleList.SelectedIndex <= -1)
					{
						Response.Write(SysOperation.OpenDialog(
							SysInfomation.SELECT_DATA_NO_ITEM));
						return;
					}
					Response.Redirect("~/Admin/UpdateRole.aspx?RoleID="
						+ RoleList.SelectedValue);
					break;
				}
			case "set":
				{
					if(RoleList.SelectedIndex <= -1)
					{
						Response.Write(SysOperation.OpenDialog(
							SysInfomation.SELECT_DATA_NO_ITEM));
						return;
					}
					Response.Redirect("~/Admin/RoleAuthenticate.aspx?RoleID="
						+ RoleList.SelectedValue);
					break;
				}
			case "delete":
				{
					if(RoleList.SelectedIndex <= -1)
					{
						Response.Write(SysOperation.OpenDialog(
							SysInfomation.SELECT_DATA_NO_ITEM));
						return;
					}
					DeleteRole();
					break;
				}		
			default: break;
		}
	}

	private void DeleteRole()
	{
		IRole role = new Role();
		try
		{
			role.DeleteRole(Int32.Parse(RoleList.SelectedValue));
			BindRoleData();
			Response.Write(SysOperation.OpenDialog(
					SysInfomation.DELETE_DATA_SUCESS));
		}
		catch(Exception ex)
		{
			Server.Transfer(SysOperation.FormatErrorPageUrl(
				SysOperation.FormatErrorUrl(Request.RawUrl),ex.Message),
				false);
		}
	}	
}
