﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class Admin_SysConfigure:System.Web.UI.Page
{
	protected void Page_Load(object sender,EventArgs e)
	{
		if(Session[SystemConst.USERIDKEY] == null)
		{
			Response.Write(SysOperation.OpenDialog(
				"你还没有登录，请先登录..."));
			Response.Write("<script>history.back()<script>");
			return;
		}
		if(!Page.IsPostBack)
		{
			ShowSystemConfigure();
		}
	}

	private void ShowSystemConfigure()
	{
		SystemConfigure sc = new SystemConfigure();
		DataSet ds = new DataSet("SystemConfigure");
		sc.GetSystemConfigure(ref ds);
		if(ds.Tables.Count <= 0)
		{
			return;
		}
		foreach(DataRow row in ds.Tables[0].Rows)
		{
			TextBox box = (TextBox)FindControl("tb" + row["Name"].ToString().Trim());
			if(box != null)
			{
				box.Text = row["Value"].ToString();
			}
		}
	}
	
	protected void btnSaveAsConfigure_Click(object sender,EventArgs e)
	{
		SystemConfigure sc = new SystemConfigure();

		try
		{
			foreach(Control c in ControlTable.Controls)
			{
				if(c is HtmlTableRow == false)
				{
					continue;
				}
				foreach(Control cc in c.Controls)
				{
					if(cc is HtmlTableCell == false)
					{
						continue;
					}
					foreach(Control cct in cc.Controls)
					{
						if(cct is TextBox)
						{
							sc.SaveAsSystemConfigure(cct.ID.Substring(2),((TextBox)cct).Text.Trim());
						}
					}
				}
			}

			Response.Write(SysOperation.OpenDialog(
				SysInfomation.ADD_DATA_SUCESS));
		}
		catch(Exception ex)
		{
			Server.Transfer(SysOperation.FormatErrorPageUrl(
				SysOperation.FormatErrorUrl(Request.RawUrl),ex.Message),
				false);
		}
	}
}
